/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheEntry;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheInvalidator;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheStorage;
import ch.boye.httpclientandroidlib.client.utils.DateUtils;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheKeyGenerator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

@Immutable
class CacheInvalidator
implements HttpCacheInvalidator {
    private final HttpCacheStorage storage;
    private final CacheKeyGenerator cacheKeyGenerator;
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());

    public CacheInvalidator(CacheKeyGenerator cacheKeyGenerator, HttpCacheStorage httpCacheStorage) {
        this.cacheKeyGenerator = cacheKeyGenerator;
        this.storage = httpCacheStorage;
    }

    @Override
    public void flushInvalidatedCacheEntries(HttpHost httpHost, HttpRequest httpRequest) {
        if (this.requestShouldNotBeCached(httpRequest)) {
            Object object;
            Object object2;
            Object object3;
            this.log.debug("Request should not be cached");
            String string = this.cacheKeyGenerator.getURI(httpHost, httpRequest);
            HttpCacheEntry httpCacheEntry = this.getEntry(string);
            this.log.debug("parent entry: " + httpCacheEntry);
            if (httpCacheEntry != null) {
                object3 = httpCacheEntry.getVariantMap().values().iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    this.flushEntry((String)object2);
                }
                this.flushEntry(string);
            }
            if ((object3 = this.getAbsoluteURL(string)) == null) {
                this.log.error("Couldn't transform request into valid URL");
                return;
            }
            object2 = httpRequest.getFirstHeader("Content-Location");
            if (object2 != null && !this.flushAbsoluteUriFromSameHost((URL)object3, (String)(object = object2.getValue()))) {
                this.flushRelativeUriFromSameHost((URL)object3, (String)object);
            }
            if ((object = httpRequest.getFirstHeader("Location")) != null) {
                this.flushAbsoluteUriFromSameHost((URL)object3, object.getValue());
            }
        }
    }

    private void flushEntry(String string) {
        try {
            this.storage.removeEntry(string);
        }
        catch (IOException iOException) {
            this.log.warn("unable to flush cache entry", iOException);
        }
    }

    private HttpCacheEntry getEntry(String string) {
        try {
            return this.storage.getEntry(string);
        }
        catch (IOException iOException) {
            this.log.warn("could not retrieve entry from storage", iOException);
            return null;
        }
    }

    protected void flushUriIfSameHost(URL uRL, URL uRL2) {
        URL uRL3 = this.getAbsoluteURL(this.cacheKeyGenerator.canonicalizeUri(uRL2.toString()));
        if (uRL3 == null) {
            return;
        }
        if (uRL3.getAuthority().equalsIgnoreCase(uRL.getAuthority())) {
            this.flushEntry(uRL3.toString());
        }
    }

    protected void flushRelativeUriFromSameHost(URL uRL, String string) {
        URL uRL2 = this.getRelativeURL(uRL, string);
        if (uRL2 == null) {
            return;
        }
        this.flushUriIfSameHost(uRL, uRL2);
    }

    protected boolean flushAbsoluteUriFromSameHost(URL uRL, String string) {
        URL uRL2 = this.getAbsoluteURL(string);
        if (uRL2 == null) {
            return false;
        }
        this.flushUriIfSameHost(uRL, uRL2);
        return true;
    }

    private URL getAbsoluteURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private URL getRelativeURL(URL uRL, String string) {
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL2;
    }

    protected boolean requestShouldNotBeCached(HttpRequest httpRequest) {
        String string = httpRequest.getRequestLine().getMethod();
        return this.notGetOrHeadRequest(string);
    }

    private boolean notGetOrHeadRequest(String string) {
        return !"GET".equals(string) && !"HEAD".equals(string);
    }

    @Override
    public void flushInvalidatedCacheEntries(HttpHost httpHost, HttpRequest httpRequest, HttpResponse httpResponse) {
        URL uRL;
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n < 200 || n > 299) {
            return;
        }
        URL uRL2 = this.getAbsoluteURL(this.cacheKeyGenerator.getURI(httpHost, httpRequest));
        if (uRL2 == null) {
            return;
        }
        URL uRL3 = this.getContentLocationURL(uRL2, httpResponse);
        if (uRL3 != null) {
            this.flushLocationCacheEntry(uRL2, httpResponse, uRL3);
        }
        if ((uRL = this.getLocationURL(uRL2, httpResponse)) != null) {
            this.flushLocationCacheEntry(uRL2, httpResponse, uRL);
        }
    }

    private void flushLocationCacheEntry(URL uRL, HttpResponse httpResponse, URL uRL2) {
        String string = this.cacheKeyGenerator.canonicalizeUri(uRL2.toString());
        HttpCacheEntry httpCacheEntry = this.getEntry(string);
        if (httpCacheEntry == null) {
            return;
        }
        if (this.responseDateOlderThanEntryDate(httpResponse, httpCacheEntry)) {
            return;
        }
        if (!this.responseAndEntryEtagsDiffer(httpResponse, httpCacheEntry)) {
            return;
        }
        this.flushUriIfSameHost(uRL, uRL2);
    }

    private URL getContentLocationURL(URL uRL, HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader("Content-Location");
        if (header == null) {
            return null;
        }
        String string = header.getValue();
        URL uRL2 = this.getAbsoluteURL(string);
        if (uRL2 != null) {
            return uRL2;
        }
        return this.getRelativeURL(uRL, string);
    }

    private URL getLocationURL(URL uRL, HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader("Location");
        if (header == null) {
            return null;
        }
        String string = header.getValue();
        URL uRL2 = this.getAbsoluteURL(string);
        if (uRL2 != null) {
            return uRL2;
        }
        return this.getRelativeURL(uRL, string);
    }

    private boolean responseAndEntryEtagsDiffer(HttpResponse httpResponse, HttpCacheEntry httpCacheEntry) {
        Header header = httpCacheEntry.getFirstHeader("ETag");
        Header header2 = httpResponse.getFirstHeader("ETag");
        if (header == null || header2 == null) {
            return false;
        }
        return !header.getValue().equals(header2.getValue());
    }

    private boolean responseDateOlderThanEntryDate(HttpResponse httpResponse, HttpCacheEntry httpCacheEntry) {
        Header header = httpCacheEntry.getFirstHeader("Date");
        Header header2 = httpResponse.getFirstHeader("Date");
        if (header == null || header2 == null) {
            return false;
        }
        Date date = DateUtils.parseDate(header.getValue());
        Date date2 = DateUtils.parseDate(header2.getValue());
        if (date == null || date2 == null) {
            return false;
        }
        return date2.before(date);
    }
}

