/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.common.log;

import android.util.Log;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mozilla.gecko.background.common.log.writers.AndroidLevelCachingLogWriter;
import org.mozilla.gecko.background.common.log.writers.AndroidLogWriter;
import org.mozilla.gecko.background.common.log.writers.LogWriter;
import org.mozilla.gecko.background.common.log.writers.PrintLogWriter;
import org.mozilla.gecko.background.common.log.writers.SimpleTagLogWriter;
import org.mozilla.gecko.background.common.log.writers.ThreadLocalTagLogWriter;

public class Logger {
    public static final String LOGGER_TAG = "Logger";
    public static final String DEFAULT_LOG_TAG = "GeckoLogger";
    public static boolean LOG_PERSONAL_INFORMATION = false;
    private static final InheritableThreadLocal<String> logTag = new InheritableThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return Logger.DEFAULT_LOG_TAG;
        }
    };
    protected static final Set<LogWriter> logWriters;

    public static void setThreadLogTag(String string2) {
        logTag.set(string2);
    }

    public static String getThreadLogTag() {
        return (String)logTag.get();
    }

    public static final Set<LogWriter> defaultLogWriters() {
        String string2 = "org.mozilla.fennec".replace("org.mozilla.", "");
        LinkedHashSet<LogWriter> linkedHashSet = new LinkedHashSet<LogWriter>();
        AndroidLogWriter androidLogWriter = new AndroidLogWriter();
        AndroidLevelCachingLogWriter androidLevelCachingLogWriter = new AndroidLevelCachingLogWriter(androidLogWriter);
        SimpleTagLogWriter simpleTagLogWriter = new SimpleTagLogWriter(string2, new ThreadLocalTagLogWriter(logTag, androidLevelCachingLogWriter));
        linkedHashSet.add(simpleTagLogWriter);
        return linkedHashSet;
    }

    public static synchronized void startLoggingTo(LogWriter logWriter) {
        logWriters.add(logWriter);
    }

    public static synchronized void startLoggingToWriters(Set<LogWriter> set) {
        logWriters.addAll(set);
    }

    public static synchronized void stopLoggingTo(LogWriter logWriter) {
        try {
            logWriter.close();
        }
        catch (Exception exception) {
            Log.e((String)LOGGER_TAG, (String)("Got exception closing and removing LogWriter " + logWriter + "."), (Throwable)exception);
        }
        logWriters.remove(logWriter);
    }

    public static synchronized void stopLoggingToAll() {
        for (LogWriter logWriter : logWriters) {
            try {
                logWriter.close();
            }
            catch (Exception exception) {
                Log.e((String)LOGGER_TAG, (String)("Got exception closing and removing LogWriter " + logWriter + "."), (Throwable)exception);
            }
        }
        logWriters.clear();
    }

    public static synchronized void resetLogging() {
        Logger.stopLoggingToAll();
        logWriters.addAll(Logger.defaultLogWriters());
    }

    public static synchronized void startLoggingToConsole() {
        Logger.setThreadLogTag("Test");
        Logger.startLoggingTo(new PrintLogWriter(new PrintWriter(System.out, true)));
    }

    public static synchronized boolean shouldLogVerbose(String string2) {
        for (LogWriter logWriter : logWriters) {
            if (!logWriter.shouldLogVerbose(string2)) continue;
            return true;
        }
        return false;
    }

    public static void error(String string2, String string3) {
        Logger.error(string2, string3, null);
    }

    public static void warn(String string2, String string3) {
        Logger.warn(string2, string3, null);
    }

    public static void info(String string2, String string3) {
        Logger.info(string2, string3, null);
    }

    public static void debug(String string2, String string3) {
        Logger.debug(string2, string3, null);
    }

    public static void trace(String string2, String string3) {
        Logger.trace(string2, string3, null);
    }

    public static void pii(String string2, String string3) {
        if (LOG_PERSONAL_INFORMATION) {
            Logger.debug(string2, "$$PII$$: " + string3);
        }
    }

    public static synchronized void error(String string2, String string3, Throwable throwable) {
        Iterator<LogWriter> iterator = logWriters.iterator();
        while (iterator.hasNext()) {
            LogWriter logWriter = iterator.next();
            try {
                logWriter.error(string2, string3, throwable);
            }
            catch (Exception exception) {
                Log.e((String)LOGGER_TAG, (String)("Got exception logging; removing LogWriter " + logWriter + "."), (Throwable)exception);
                iterator.remove();
            }
        }
    }

    public static synchronized void warn(String string2, String string3, Throwable throwable) {
        Iterator<LogWriter> iterator = logWriters.iterator();
        while (iterator.hasNext()) {
            LogWriter logWriter = iterator.next();
            try {
                logWriter.warn(string2, string3, throwable);
            }
            catch (Exception exception) {
                Log.e((String)LOGGER_TAG, (String)("Got exception logging; removing LogWriter " + logWriter + "."), (Throwable)exception);
                iterator.remove();
            }
        }
    }

    public static synchronized void info(String string2, String string3, Throwable throwable) {
        Iterator<LogWriter> iterator = logWriters.iterator();
        while (iterator.hasNext()) {
            LogWriter logWriter = iterator.next();
            try {
                logWriter.info(string2, string3, throwable);
            }
            catch (Exception exception) {
                Log.e((String)LOGGER_TAG, (String)("Got exception logging; removing LogWriter " + logWriter + "."), (Throwable)exception);
                iterator.remove();
            }
        }
    }

    public static synchronized void debug(String string2, String string3, Throwable throwable) {
        Iterator<LogWriter> iterator = logWriters.iterator();
        while (iterator.hasNext()) {
            LogWriter logWriter = iterator.next();
            try {
                logWriter.debug(string2, string3, throwable);
            }
            catch (Exception exception) {
                Log.e((String)LOGGER_TAG, (String)("Got exception logging; removing LogWriter " + logWriter + "."), (Throwable)exception);
                iterator.remove();
            }
        }
    }

    public static synchronized void trace(String string2, String string3, Throwable throwable) {
        Iterator<LogWriter> iterator = logWriters.iterator();
        while (iterator.hasNext()) {
            LogWriter logWriter = iterator.next();
            try {
                logWriter.trace(string2, string3, throwable);
            }
            catch (Exception exception) {
                Log.e((String)LOGGER_TAG, (String)("Got exception logging; removing LogWriter " + logWriter + "."), (Throwable)exception);
                iterator.remove();
            }
        }
    }

    static {
        Set<LogWriter> set = Logger.defaultLogWriters();
        logWriters = new LinkedHashSet<LogWriter>(set);
    }
}

