/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.datareporting;

import android.util.Base64;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.json.JSONObject;
import org.mozilla.gecko.background.common.log.Logger;

public class TelemetryRecorder {
    private final String LOG_TAG = "TelemetryRecorder";
    private final File parentDir;
    private final String filename;
    private File tmpFile;
    private File destFile;
    private final File cacheDir;
    private OutputStream outputStream;
    private MessageDigest checksum;
    private String base64Checksum;
    private String charset = "us-ascii";
    private int blockSize = 0;

    public TelemetryRecorder(File file, File file2, String string2) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Expecting directory, got non-directory File instead.");
        }
        this.parentDir = file;
        this.filename = string2;
        this.cacheDir = file2;
    }

    public TelemetryRecorder(File file, File file2, String string2, String string3) {
        this(file, file2, string2);
        this.charset = string3;
    }

    public TelemetryRecorder(File file, File file2, String string2, String string3, int n) {
        this(file, file2, string2, string3);
        this.blockSize = n;
    }

    public void startPingFile() throws Exception {
        try {
            this.tmpFile = File.createTempFile(this.filename, "tmp", this.cacheDir);
        }
        catch (IOException iOException) {
            this.tmpFile = new File(this.parentDir, this.filename + ".tmp");
            try {
                this.tmpFile.createNewFile();
            }
            catch (IOException iOException2) {
                this.cleanUpAndRethrow("Failed to create tmp file in temp directory or ping directory.", iOException2);
            }
        }
        try {
            this.outputStream = this.blockSize > 0 ? new BufferedOutputStream(new FileOutputStream(this.tmpFile), this.blockSize) : new BufferedOutputStream(new FileOutputStream(this.tmpFile));
            this.checksum = MessageDigest.getInstance("SHA-256");
            byte[] byArray = this.makePingHeader(this.filename);
            this.outputStream.write(byArray);
            Logger.debug("TelemetryRecorder", "Wrote " + byArray.length + " header bytes.");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.cleanUpAndRethrow("Error creating checksum digest", noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.cleanUpAndRethrow("Error writing header", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            this.cleanUpAndRethrow("Error writing to stream", iOException);
        }
    }

    private byte[] makePingHeader(String string2) throws UnsupportedEncodingException {
        return ("{\"slug\":" + JSONObject.quote((String)string2) + "," + "\"payload\":\"").getBytes(this.charset);
    }

    public int appendPayload(String string2) throws Exception {
        if (string2 == null) {
            this.cleanUpAndRethrow("Payload is null", new Exception());
            return -1;
        }
        try {
            byte[] byArray = string2.getBytes(this.charset);
            this.checksum.update(byArray);
            byte[] byArray2 = JSONObject.quote((String)string2).getBytes(this.charset);
            int n = byArray2.length - 2;
            this.outputStream.write(byArray2, 1, n);
            return n;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.cleanUpAndRethrow("Error encoding payload", unsupportedEncodingException);
            return -1;
        }
        catch (IOException iOException) {
            this.cleanUpAndRethrow("Error writing to stream", iOException);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishPingFile() throws Exception {
        Object object;
        try {
            object = this.makePingFooter(this.checksum);
            this.outputStream.write((byte[])object);
            this.outputStream.flush();
            Logger.debug("TelemetryRecorder", "Wrote " + ((byte[])object).length + " footer bytes.");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.cleanUpAndRethrow("Checksum encoding exception", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            this.cleanUpAndRethrow("Error writing footer to stream", iOException);
        }
        finally {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                this.outputStream = null;
            }
        }
        try {
            boolean bl;
            object = new File(this.parentDir, this.filename);
            if (((File)object).exists()) {
                ((File)object).delete();
            }
            if (!(bl = this.tmpFile.renameTo((File)object))) {
                throw new IOException("Could not move tmp file to destination.");
            }
        }
        finally {
            this.cleanUp();
        }
    }

    private byte[] makePingFooter(MessageDigest messageDigest) throws UnsupportedEncodingException {
        this.base64Checksum = Base64.encodeToString((byte[])messageDigest.digest(), (int)2);
        return ("\",\"checksum\":" + JSONObject.quote((String)this.base64Checksum) + "}").getBytes(this.charset);
    }

    protected String getFinalChecksum() {
        return this.base64Checksum;
    }

    public String getCharset() {
        return this.charset;
    }

    private void cleanUp() {
        this.checksum.reset();
        if (this.tmpFile != null && this.tmpFile.exists()) {
            this.tmpFile.delete();
        }
        this.tmpFile = null;
    }

    private void cleanUpAndRethrow(String string2, Exception exception) throws Exception {
        Logger.error("TelemetryRecorder", string2, exception);
        this.cleanUp();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.destFile != null && this.destFile.exists()) {
            this.destFile.delete();
        }
        throw exception;
    }
}

