/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.AccountAuthenticatorActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.View;
import android.widget.TextView;
import java.util.Locale;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountAgeLockoutHelper;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.activities.FxAccountCreateAccountActivity;
import org.mozilla.gecko.fxa.activities.FxAccountCreateAccountNotAllowedActivity;
import org.mozilla.gecko.fxa.activities.FxAccountStatusActivity;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;

public class FxAccountGetStartedActivity
extends AccountAuthenticatorActivity {
    protected static final String LOG_TAG = FxAccountGetStartedActivity.class.getSimpleName();
    private static final int CHILD_REQUEST_CODE = 1;

    public void onCreate(Bundle bundle) {
        Logger.setThreadLogTag("FxAccounts");
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        Locales.initializeLocale(this.getApplicationContext());
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_get_started);
        this.linkifyOldFirefoxLink();
        View view = this.findViewById(R.id.get_started_button);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Bundle bundle = null;
                if (FxAccountGetStartedActivity.this.getIntent() != null) {
                    bundle = FxAccountGetStartedActivity.this.getIntent().getExtras();
                }
                FxAccountGetStartedActivity.this.startFlow(bundle);
            }
        });
    }

    protected void startFlow(Bundle bundle) {
        Intent intent = new Intent((Context)this, FxAccountCreateAccountActivity.class);
        intent.setFlags(65536);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        this.startActivityForResult(intent, 1);
    }

    public void onResume() {
        super.onResume();
        Intent intent = null;
        if (FxAccountAgeLockoutHelper.isLockedOut(SystemClock.elapsedRealtime())) {
            intent = new Intent((Context)this, FxAccountCreateAccountNotAllowedActivity.class);
        } else if (FirefoxAccounts.firefoxAccountsExist((Context)this)) {
            intent = new Intent((Context)this, FxAccountStatusActivity.class);
        }
        if (intent != null) {
            this.setAccountAuthenticatorResult(null);
            this.setResult(0);
            intent.setFlags(65536);
            this.startActivity(intent);
            this.finish();
        }
        Bundle bundle = null;
        if (this.getIntent() != null) {
            bundle = this.getIntent().getExtras();
        }
        if (bundle != null && bundle.containsKey("extras")) {
            this.getIntent().replaceExtras(Bundle.EMPTY);
            this.startFlow((Bundle)bundle.clone());
            return;
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        Logger.debug(LOG_TAG, "onActivityResult: " + n + ", " + n2);
        if (n != 1) {
            super.onActivityResult(n, n2, intent);
            return;
        }
        this.setResult(n, intent);
        if (intent != null) {
            this.setAccountAuthenticatorResult(intent.getExtras());
            this.finish();
        }
    }

    protected void linkifyOldFirefoxLink() {
        TextView textView = (TextView)this.findViewById(R.id.old_firefox);
        String string2 = this.getResources().getString(R.string.fxaccount_getting_started_old_firefox);
        String string3 = FirefoxAccounts.getOldSyncUpgradeURL(this.getResources(), Locale.getDefault());
        FxAccountUtils.pii(LOG_TAG, "Old Firefox url is: " + string3);
        ActivityUtils.linkTextView(textView, string2, string3);
    }
}

