/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.login;

import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.fxa.login.FxAccountLoginStateMachine;
import org.mozilla.gecko.fxa.login.FxAccountLoginTransition;
import org.mozilla.gecko.fxa.login.Separated;
import org.mozilla.gecko.fxa.login.State;

public abstract class BaseRequestDelegate<T>
implements FxAccountClient10.RequestDelegate<T> {
    protected final FxAccountLoginStateMachine.ExecuteDelegate delegate;
    protected final State state;

    public BaseRequestDelegate(State state, FxAccountLoginStateMachine.ExecuteDelegate executeDelegate) {
        this.delegate = executeDelegate;
        this.state = state;
    }

    @Override
    public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
        if (fxAccountClientRemoteException.isUpgradeRequired()) {
            this.delegate.handleTransition(new FxAccountLoginTransition.RemoteError(fxAccountClientRemoteException), new Separated(this.state.email, this.state.uid, this.state.verified));
            return;
        }
        if (fxAccountClientRemoteException.isInvalidAuthentication()) {
            this.delegate.handleTransition(new FxAccountLoginTransition.RemoteError(fxAccountClientRemoteException), new Separated(this.state.email, this.state.uid, this.state.verified));
            return;
        }
        if (fxAccountClientRemoteException.isUnverified()) {
            this.delegate.handleTransition(new FxAccountLoginTransition.AccountNeedsVerification(), this.state);
            return;
        }
        this.delegate.handleTransition(new FxAccountLoginTransition.RemoteError(fxAccountClientRemoteException), this.state);
    }

    @Override
    public void handleError(Exception exception) {
        this.delegate.handleTransition(new FxAccountLoginTransition.LocalError(exception), this.state);
    }
}

