/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search.autocomplete;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.Loader;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SuggestClient;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.search.AcceptsSearchQuery;
import org.mozilla.search.autocomplete.AutoCompleteAdapter;
import org.mozilla.search.providers.SearchEngine;

public class SuggestionsFragment
extends Fragment {
    private static final String LOG_TAG = "SuggestionsFragment";
    private static final int LOADER_ID_SUGGESTION = 0;
    private static final String KEY_SEARCH_TERM = "search_term";
    private static final int SUGGESTION_TIMEOUT = 3000;
    private static final int SUGGESTION_MAX = 5;
    public static final String GECKO_SEARCH_TERMS_URL_PARAM = "__searchTerms__";
    private AcceptsSearchQuery searchListener;
    private SuggestClient suggestClient;
    private SuggestionLoaderCallbacks suggestionLoaderCallbacks;
    private AutoCompleteAdapter autoCompleteAdapter;
    private ListView suggestionsList;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof AcceptsSearchQuery)) {
            throw new ClassCastException(activity.toString() + " must implement AcceptsSearchQuery.");
        }
        this.searchListener = (AcceptsSearchQuery)activity;
        this.suggestionLoaderCallbacks = new SuggestionLoaderCallbacks();
        this.autoCompleteAdapter = new AutoCompleteAdapter((Context)activity);
    }

    public void onDetach() {
        super.onDetach();
        this.searchListener = null;
        this.suggestionLoaderCallbacks = null;
        this.autoCompleteAdapter = null;
        this.suggestClient = null;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.suggestionsList = (ListView)layoutInflater.inflate(R.layout.search_sugestions, viewGroup, false);
        this.suggestionsList.setAdapter((ListAdapter)this.autoCompleteAdapter);
        this.suggestionsList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                Suggestion suggestion = (Suggestion)SuggestionsFragment.this.suggestionsList.getItemAtPosition(n);
                final Rect rect = new Rect();
                view.getGlobalVisibleRect(rect);
                Telemetry.sendUIEvent((TelemetryContract.Event)TelemetryContract.Event.SEARCH, (TelemetryContract.Method)TelemetryContract.Method.SUGGESTION, (long)n);
                SuggestionsFragment.this.searchListener.onSearch(suggestion.value, new AcceptsSearchQuery.SuggestionAnimation(){

                    @Override
                    public Rect getStartBounds() {
                        return rect;
                    }
                });
            }
        });
        return this.suggestionsList;
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (null != this.suggestionsList) {
            this.suggestionsList.setOnItemClickListener(null);
            this.suggestionsList.setAdapter(null);
            this.suggestionsList = null;
        }
    }

    public void setEngine(SearchEngine searchEngine) {
        this.suggestClient = new SuggestClient((Context)this.getActivity(), searchEngine.getSuggestionTemplate(GECKO_SEARCH_TERMS_URL_PARAM), 3000, 5, true);
    }

    public void loadSuggestions(String string2) {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_SEARCH_TERM, string2);
        LoaderManager loaderManager = this.getLoaderManager();
        if (loaderManager.getLoader(0) == null) {
            loaderManager.initLoader(0, bundle, (LoaderManager.LoaderCallbacks)this.suggestionLoaderCallbacks);
        } else {
            loaderManager.restartLoader(0, bundle, (LoaderManager.LoaderCallbacks)this.suggestionLoaderCallbacks);
        }
    }

    private static class SuggestionAsyncLoader
    extends AsyncTaskLoader<List<Suggestion>> {
        private final SuggestClient suggestClient;
        private final String searchTerm;
        private List<Suggestion> suggestions;
        private final int suggestionHighlightColor;

        public SuggestionAsyncLoader(Context context, SuggestClient suggestClient, String string2) {
            super(context);
            this.suggestClient = suggestClient;
            this.searchTerm = string2;
            this.suggestions = null;
            this.suggestionHighlightColor = context.getResources().getColor(R.color.suggestion_highlight);
        }

        public List<Suggestion> loadInBackground() {
            ArrayList arrayList = this.suggestClient.query(this.searchTerm);
            ArrayList<Suggestion> arrayList2 = new ArrayList<Suggestion>(arrayList.size());
            for (String string2 : arrayList) {
                arrayList2.add(new Suggestion(string2, this.searchTerm, this.suggestionHighlightColor));
            }
            return arrayList2;
        }

        public void deliverResult(List<Suggestion> list) {
            this.suggestions = list;
            if (this.isStarted()) {
                super.deliverResult(list);
            }
        }

        protected void onStartLoading() {
            if (this.suggestions != null) {
                this.deliverResult(this.suggestions);
            }
            if (this.takeContentChanged() || this.suggestions == null) {
                this.forceLoad();
            }
        }

        protected void onStopLoading() {
            this.cancelLoad();
        }

        protected void onReset() {
            super.onReset();
            this.onStopLoading();
            this.suggestions = null;
        }
    }

    private class SuggestionLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<List<Suggestion>> {
        private SuggestionLoaderCallbacks() {
        }

        public Loader<List<Suggestion>> onCreateLoader(int n, Bundle bundle) {
            if (SuggestionsFragment.this.suggestClient != null) {
                return new SuggestionAsyncLoader((Context)SuggestionsFragment.this.getActivity(), SuggestionsFragment.this.suggestClient, bundle.getString(SuggestionsFragment.KEY_SEARCH_TERM));
            }
            Log.e((String)SuggestionsFragment.LOG_TAG, (String)"Autocomplete setup failed; suggestClient not ready yet.");
            return null;
        }

        public void onLoadFinished(Loader<List<Suggestion>> loader, List<Suggestion> list) {
            if (list.size() > 0) {
                SuggestionsFragment.this.autoCompleteAdapter.update(list);
                SuggestionsFragment.this.suggestionsList.setVisibility(0);
            } else {
                SuggestionsFragment.this.suggestionsList.setVisibility(4);
            }
        }

        public void onLoaderReset(Loader<List<Suggestion>> loader) {
        }
    }

    public static class Suggestion {
        public final String value;
        public final SpannableString display;
        public final ForegroundColorSpan colorSpan;

        public Suggestion(String string2, String string3, int n) {
            this.value = string2;
            this.display = new SpannableString((CharSequence)string2);
            this.colorSpan = new ForegroundColorSpan(n);
            int n2 = string2.toLowerCase().indexOf(string3.toLowerCase());
            if (n2 >= 0) {
                this.display.setSpan((Object)this.colorSpan, n2, n2 + string3.length(), 0);
            }
        }
    }
}

