/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.ProtocolException;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheEntry;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestWrapper;
import ch.boye.httpclientandroidlib.impl.client.cache.Variant;
import java.util.Map;

@Immutable
class ConditionalRequestBuilder {
    ConditionalRequestBuilder() {
    }

    public HttpRequestWrapper buildConditionalRequest(HttpRequestWrapper httpRequestWrapper, HttpCacheEntry httpCacheEntry) throws ProtocolException {
        Header header;
        HttpRequestWrapper httpRequestWrapper2 = HttpRequestWrapper.wrap(httpRequestWrapper.getOriginal());
        httpRequestWrapper2.setHeaders(httpRequestWrapper.getAllHeaders());
        Header header2 = httpCacheEntry.getFirstHeader("ETag");
        if (header2 != null) {
            httpRequestWrapper2.setHeader("If-None-Match", header2.getValue());
        }
        if ((header = httpCacheEntry.getFirstHeader("Last-Modified")) != null) {
            httpRequestWrapper2.setHeader("If-Modified-Since", header.getValue());
        }
        boolean bl = false;
        block0: for (Header header3 : httpCacheEntry.getHeaders("Cache-Control")) {
            for (HeaderElement headerElement : header3.getElements()) {
                if (!"must-revalidate".equalsIgnoreCase(headerElement.getName()) && !"proxy-revalidate".equalsIgnoreCase(headerElement.getName())) continue;
                bl = true;
                continue block0;
            }
        }
        if (bl) {
            httpRequestWrapper2.addHeader("Cache-Control", "max-age=0");
        }
        return httpRequestWrapper2;
    }

    public HttpRequestWrapper buildConditionalRequestFromVariants(HttpRequestWrapper httpRequestWrapper, Map<String, Variant> map) {
        HttpRequestWrapper httpRequestWrapper2 = HttpRequestWrapper.wrap(httpRequestWrapper.getOriginal());
        httpRequestWrapper2.setHeaders(httpRequestWrapper.getAllHeaders());
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : map.keySet()) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(string);
        }
        httpRequestWrapper2.setHeader("If-None-Match", stringBuilder.toString());
        return httpRequestWrapper2;
    }

    public HttpRequestWrapper buildUnconditionalRequest(HttpRequestWrapper httpRequestWrapper, HttpCacheEntry httpCacheEntry) {
        HttpRequestWrapper httpRequestWrapper2 = HttpRequestWrapper.wrap(httpRequestWrapper.getOriginal());
        httpRequestWrapper2.setHeaders(httpRequestWrapper.getAllHeaders());
        httpRequestWrapper2.addHeader("Cache-Control", "no-cache");
        httpRequestWrapper2.addHeader("Pragma", "no-cache");
        httpRequestWrapper2.removeHeaders("If-Range");
        httpRequestWrapper2.removeHeaders("If-Match");
        httpRequestWrapper2.removeHeaders("If-None-Match");
        httpRequestWrapper2.removeHeaders("If-Unmodified-Since");
        httpRequestWrapper2.removeHeaders("If-Modified-Since");
        return httpRequestWrapper2;
    }
}

