/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.browserid;

public class ASNUtils {
    public static byte[][] decodeTwoArraysFromASN1(byte[] byArray) throws IllegalArgumentException {
        if (byArray == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        if (byArray.length <= 3) {
            throw new IllegalArgumentException("bad length");
        }
        if (byArray[0] != 48) {
            throw new IllegalArgumentException("bad encoding");
        }
        if ((byArray[1] & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException("bad length encoding");
        }
        if (byArray[2] != 2) {
            throw new IllegalArgumentException("bad encoding");
        }
        if ((byArray[3] & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException("bad length encoding");
        }
        byte by = byArray[3];
        if (byArray.length <= 5 + by) {
            throw new IllegalArgumentException("bad length");
        }
        if (byArray[4 + by] != 2) {
            throw new IllegalArgumentException("bad encoding");
        }
        if ((byArray[5 + by] & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException("bad length encoding");
        }
        byte by2 = byArray[5 + by];
        if (byArray.length != 6 + by2 + by) {
            throw new IllegalArgumentException("bad length");
        }
        byte[] byArray2 = new byte[by];
        byte[] byArray3 = new byte[by2];
        System.arraycopy(byArray, 4, byArray2, 0, by);
        System.arraycopy(byArray, 6 + by, byArray3, 0, by2);
        return new byte[][]{byArray2, byArray3};
    }

    public static byte[] encodeTwoArraysToASN1(byte[] byArray, byte[] byArray2) throws IllegalArgumentException {
        if (byArray == null) {
            throw new IllegalArgumentException("first must not be null");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("second must not be null");
        }
        byte[] byArray3 = new byte[6 + byArray.length + byArray2.length];
        byArray3[0] = 48;
        if (4 + byArray.length + byArray2.length > 255) {
            throw new IllegalArgumentException("bad length");
        }
        byArray3[1] = (byte)(4 + byArray.length + byArray2.length);
        if ((byArray3[1] & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException("bad length encoding");
        }
        byArray3[2] = 2;
        byArray3[3] = (byte)byArray.length;
        if ((byArray3[3] & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException("bad length encoding");
        }
        System.arraycopy(byArray, 0, byArray3, 4, byArray.length);
        byArray3[4 + byArray.length] = 2;
        byArray3[5 + byArray.length] = (byte)byArray2.length;
        if ((byArray3[5 + byArray.length] & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException("bad length encoding");
        }
        System.arraycopy(byArray2, 0, byArray3, 6 + byArray.length, byArray2.length);
        return byArray3;
    }
}

