/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.jpake.stage;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Timer;
import java.util.TimerTask;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.jpake.JPakeClient;
import org.mozilla.gecko.sync.jpake.stage.JPakeStage;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.Resource;

public class PutRequestStage
extends JPakeStage {
    @Override
    public void execute(final JPakeClient jPakeClient) {
        Resource resource;
        Logger.debug("SyncJPakeStage", "Upload message.");
        PutRequestStageDelegate putRequestStageDelegate = new PutRequestStageDelegate(){

            @Override
            public void handleSuccess(HttpResponse httpResponse) {
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        jPakeClient.runNextStage();
                    }
                };
                Timer timer = new Timer();
                Logger.debug("SyncJPakeStage", "Pause for 2 * pollInterval before continuing.");
                timer.schedule(timerTask, 2 * jPakeClient.jpakePollInterval);
            }

            @Override
            public void handleFailure(String string2) {
                Logger.error("SyncJPakeStage", "Got HTTP failure: " + string2);
                jPakeClient.abort(string2);
            }

            @Override
            public void handleError(Exception exception) {
                Logger.error("SyncJPakeStage", "HTTP exception.", exception);
                jPakeClient.abort("jpake.error.network");
            }
        };
        try {
            resource = this.createPutRequest(putRequestStageDelegate, jPakeClient);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.error("SyncJPakeStage", "URISyntaxException", uRISyntaxException);
            jPakeClient.abort("jpake.error.channel");
            return;
        }
        try {
            resource.put((HttpEntity)JPakeClient.jsonEntity(jPakeClient.jOutgoing.object));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.error("SyncJPakeStage", "UnsupportedEncodingException", unsupportedEncodingException);
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        Logger.debug("SyncJPakeStage", "Outgoing message: " + jPakeClient.jOutgoing.toJSONString());
    }

    private Resource createPutRequest(final PutRequestStageDelegate putRequestStageDelegate, final JPakeClient jPakeClient) throws URISyntaxException {
        BaseResource baseResource = new BaseResource(jPakeClient.channelUrl);
        baseResource.delegate = new BaseResourceDelegate(baseResource){

            @Override
            public String getUserAgent() {
                return "Firefox AndroidSync 1.38.0a1.0 (Nightly)";
            }

            @Override
            public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
                httpRequestBase.setHeader((Header)new BasicHeader("X-KeyExchange-Id", jPakeClient.clientId));
                if (jPakeClient.theirEtag != null) {
                    httpRequestBase.setHeader((Header)new BasicHeader("If-Match", jPakeClient.theirEtag));
                } else {
                    httpRequestBase.setHeader((Header)new BasicHeader("If-None-Match", "*"));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void handleHttpResponse(HttpResponse httpResponse) {
                try {
                    int n = httpResponse.getStatusLine().getStatusCode();
                    switch (n) {
                        case 200: {
                            Header header = httpResponse.getFirstHeader("etag");
                            if (header == null) {
                                Logger.error("SyncJPakeStage", "Server did not supply ETag.");
                                putRequestStageDelegate.handleFailure("jpake.error.server");
                                return;
                            }
                            jPakeClient.myEtag = header.getValue();
                            putRequestStageDelegate.handleSuccess(httpResponse);
                            return;
                        }
                        default: {
                            Logger.error("SyncJPakeStage", "Could not upload data. Server responded with HTTP " + n);
                            putRequestStageDelegate.handleFailure("jpake.error.server");
                            return;
                        }
                    }
                }
                finally {
                    BaseResource.consumeEntity(httpResponse);
                }
            }

            @Override
            public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
                putRequestStageDelegate.handleError((Exception)clientProtocolException);
            }

            @Override
            public void handleHttpIOException(IOException iOException) {
                putRequestStageDelegate.handleError(iOException);
            }

            @Override
            public void handleTransportException(GeneralSecurityException generalSecurityException) {
                putRequestStageDelegate.handleError(generalSecurityException);
            }

            @Override
            public int connectionTimeout() {
                return 60000;
            }
        };
        return baseResource;
    }

    private static interface PutRequestStageDelegate {
        public void handleSuccess(HttpResponse var1);

        public void handleFailure(String var1);

        public void handleError(Exception var1);
    }
}

