/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.Context;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserRepositoryDataAccessor;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionCleanDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionCreationDelegate;

public abstract class AndroidBrowserRepository
extends Repository {
    @Override
    public void createSession(RepositorySessionCreationDelegate repositorySessionCreationDelegate, Context context) {
        new CreateSessionThread(repositorySessionCreationDelegate, context).start();
    }

    @Override
    public void clean(boolean bl, RepositorySessionCleanDelegate repositorySessionCleanDelegate, Context context) {
        if (bl) {
            new CleanThread(repositorySessionCleanDelegate, context).start();
        }
    }

    protected abstract AndroidBrowserRepositoryDataAccessor getDataAccessor(Context var1);

    protected abstract void sessionCreator(RepositorySessionCreationDelegate var1, Context var2);

    class CreateSessionThread
    extends Thread {
        private final RepositorySessionCreationDelegate delegate;
        private final Context context;

        public CreateSessionThread(RepositorySessionCreationDelegate repositorySessionCreationDelegate, Context context) {
            if (context == null) {
                throw new IllegalArgumentException("context is null.");
            }
            this.delegate = repositorySessionCreationDelegate;
            this.context = context;
        }

        @Override
        public void run() {
            AndroidBrowserRepository.this.sessionCreator(this.delegate, this.context);
        }
    }

    class CleanThread
    extends Thread {
        private final RepositorySessionCleanDelegate delegate;
        private final Context context;

        public CleanThread(RepositorySessionCleanDelegate repositorySessionCleanDelegate, Context context) {
            if (context == null) {
                throw new IllegalArgumentException("context is null");
            }
            this.delegate = repositorySessionCleanDelegate;
            this.context = context;
        }

        @Override
        public void run() {
            try {
                AndroidBrowserRepository.this.getDataAccessor(this.context).purgeDeleted();
            }
            catch (Exception exception) {
                this.delegate.onCleanFailed(AndroidBrowserRepository.this, exception);
                return;
            }
            this.delegate.onCleaned(AndroidBrowserRepository.this);
        }
    }
}

