/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.toolbar.BrowserToolbarPhoneBase;
import org.mozilla.gecko.util.HardwareUtils;

class BrowserToolbarPhone
extends BrowserToolbarPhoneBase {
    private final PropertyAnimator.PropertyAnimationListener showEditingListener = new PropertyAnimator.PropertyAnimationListener(){

        @Override
        public void onPropertyAnimationStart() {
        }

        @Override
        public void onPropertyAnimationEnd() {
            BrowserToolbarPhone.this.isAnimatingEntry = false;
        }
    };
    private final PropertyAnimator.PropertyAnimationListener stopEditingListener = new PropertyAnimator.PropertyAnimationListener(){

        @Override
        public void onPropertyAnimationStart() {
        }

        @Override
        public void onPropertyAnimationEnd() {
            BrowserToolbarPhone.this.urlBarTranslatingEdge.setVisibility(4);
            PropertyAnimator propertyAnimator = new PropertyAnimator(300L);
            BrowserToolbarPhone.this.urlDisplayLayout.prepareStopEditingAnimation(propertyAnimator);
            propertyAnimator.start();
            BrowserToolbarPhone.this.isAnimatingEntry = false;
            BrowserToolbarPhone.this.updateTabCountAndAnimate(Tabs.getInstance().getDisplayCount());
        }
    };
    protected boolean isAnimatingEntry;

    protected BrowserToolbarPhone(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    @Override
    public boolean isAnimating() {
        return this.isAnimatingEntry;
    }

    @Override
    protected void triggerStartEditingTransition(PropertyAnimator propertyAnimator) {
        if (this.isAnimatingEntry) {
            return;
        }
        this.urlEditLayout.clearFocus();
        this.urlDisplayLayout.prepareStartEditingAnimation();
        this.addAnimationsForEditing(propertyAnimator, true);
        this.showUrlEditLayout(propertyAnimator);
        this.urlBarTranslatingEdge.setVisibility(0);
        propertyAnimator.addPropertyAnimationListener(this.showEditingListener);
        this.isAnimatingEntry = true;
    }

    @Override
    protected void triggerStopEditingTransition() {
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.setUseHardwareLayer(false);
        this.addAnimationsForEditing(propertyAnimator, false);
        this.hideUrlEditLayout(propertyAnimator);
        propertyAnimator.addPropertyAnimationListener(this.stopEditingListener);
        this.isAnimatingEntry = true;
        propertyAnimator.start();
    }

    private void addAnimationsForEditing(PropertyAnimator propertyAnimator, boolean bl) {
        int n;
        int n2;
        if (bl) {
            n2 = this.getUrlBarCurveTranslation();
            n = this.getUrlBarEntryTranslation();
        } else {
            n2 = 0;
            n = 0;
        }
        propertyAnimator.attach((View)this.urlBarTranslatingEdge, PropertyAnimator.Property.TRANSLATION_X, n);
        propertyAnimator.attach((View)this.tabsButton, PropertyAnimator.Property.TRANSLATION_X, n2);
        propertyAnimator.attach((View)this.tabsCounter, PropertyAnimator.Property.TRANSLATION_X, n2);
        if (!HardwareUtils.hasMenuButton()) {
            propertyAnimator.attach((View)this.menuButton, PropertyAnimator.Property.TRANSLATION_X, n2);
            propertyAnimator.attach((View)this.menuIcon, PropertyAnimator.Property.TRANSLATION_X, n2);
        }
    }
}

