/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.util.Log;
import android.widget.Toast;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public final class ReadingListHelper
implements NativeEventListener {
    private static final String LOGTAG = "ReadingListHelper";
    protected final Context context;

    public ReadingListHelper(Context context) {
        this.context = context;
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Reader:AddToList", "Reader:FaviconRequest", "Reader:ListStatusRequest", "Reader:RemoveFromList");
    }

    public void uninit() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Reader:AddToList", "Reader:FaviconRequest", "Reader:ListStatusRequest", "Reader:RemoveFromList");
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        switch (string2) {
            case "Reader:AddToList": {
                this.handleAddToList(eventCallback, nativeJSObject);
                break;
            }
            case "Reader:FaviconRequest": {
                this.handleReaderModeFaviconRequest(eventCallback, nativeJSObject.getString("url"));
                break;
            }
            case "Reader:RemoveFromList": {
                this.handleRemoveFromList(nativeJSObject.getString("url"));
                break;
            }
            case "Reader:ListStatusRequest": {
                this.handleReadingListStatusRequest(eventCallback, nativeJSObject.getString("url"));
            }
        }
    }

    private void handleAddToList(final EventCallback eventCallback, NativeJSObject nativeJSObject) {
        final ContentResolver contentResolver = this.context.getContentResolver();
        final String string2 = nativeJSObject.getString("url");
        final ContentValues contentValues = new ContentValues();
        contentValues.put("url", string2);
        contentValues.put("title", nativeJSObject.getString("title"));
        contentValues.put("length", Integer.valueOf(nativeJSObject.getInt("length")));
        contentValues.put("excerpt", nativeJSObject.getString("excerpt"));
        contentValues.put("content_status", Integer.valueOf(nativeJSObject.getInt("status")));
        final BrowserDB browserDB = GeckoProfile.get(this.context).getDB();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (browserDB.isReadingListItem(contentResolver, string2)) {
                    ReadingListHelper.this.showToast(R.string.reading_list_duplicate, 0);
                    eventCallback.sendError((Object)("URL already in reading list: " + string2));
                } else {
                    browserDB.addReadingListItem(contentResolver, contentValues);
                    ReadingListHelper.this.showToast(R.string.reading_list_added, 0);
                    eventCallback.sendSuccess((Object)string2);
                }
            }
        });
    }

    private void handleReaderModeFaviconRequest(final EventCallback eventCallback, final String string2) {
        final BrowserDB browserDB = GeckoProfile.get(this.context).getDB();
        new UIAsyncTask.WithoutParams<String>(ThreadUtils.getBackgroundHandler()){

            public String doInBackground() {
                return Favicons.getFaviconURLForPageURL(browserDB, ReadingListHelper.this.context.getContentResolver(), string2);
            }

            public void onPostExecute(String string22) {
                JSONObject jSONObject = new JSONObject();
                if (string22 != null) {
                    try {
                        jSONObject.put("url", (Object)string2);
                        jSONObject.put("faviconUrl", (Object)string22);
                    }
                    catch (JSONException jSONException) {
                        Log.w((String)ReadingListHelper.LOGTAG, (String)"Error building JSON favicon arguments.", (Throwable)jSONException);
                    }
                }
                eventCallback.sendSuccess((Object)jSONObject.toString());
            }
        }.execute();
    }

    private void handleRemoveFromList(final String string2) {
        final BrowserDB browserDB = GeckoProfile.get(this.context).getDB();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                browserDB.removeReadingListItemWithURL(ReadingListHelper.this.context.getContentResolver(), string2);
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Reader:Removed", string2));
                ReadingListHelper.this.showToast(R.string.page_removed, 0);
            }
        });
    }

    private void handleReadingListStatusRequest(final EventCallback eventCallback, final String string2) {
        final BrowserDB browserDB = GeckoProfile.get(this.context).getDB();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                int n = browserDB.isReadingListItem(ReadingListHelper.this.context.getContentResolver(), string2) ? 1 : 0;
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("url", (Object)string2);
                    jSONObject.put("inReadingList", n);
                }
                catch (JSONException jSONException) {
                    Log.e((String)ReadingListHelper.LOGTAG, (String)"JSON error - failed to return inReadingList status", (Throwable)jSONException);
                }
                eventCallback.sendSuccess((Object)jSONObject.toString());
            }
        });
    }

    private void showToast(final int n, final int n2) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)ReadingListHelper.this.context, (int)n, (int)n2).show();
            }
        });
    }
}

