/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.gfx.PointUtils;
import org.mozilla.gecko.mozglue.DirectBufferAllocator;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class ZoomedView
extends FrameLayout
implements LayerView.OnMetricsChangedListener,
LayerView.ZoomedViewListener,
GeckoEventListener {
    private static final String LOGTAG = "Gecko" + ZoomedView.class.getSimpleName();
    private static final int ZOOM_FACTOR = 2;
    private static final int W_CAPTURED_VIEW_IN_PERCENT = 80;
    private static final int H_CAPTURED_VIEW_IN_PERCENT = 50;
    private static final int MINIMUM_DELAY_BETWEEN_TWO_RENDER_CALLS_NS = 1000000;
    private static final int DELAY_BEFORE_NEXT_RENDER_REQUEST_MS = 2000;
    private ImageView zoomedImageView;
    private LayerView layerView;
    private int viewWidth;
    private int viewHeight;
    private Point lastPosition;
    private boolean shouldSetVisibleOnUpdate;
    private PointF returnValue = new PointF();
    private boolean stopUpdateView;
    private int lastOrientation;
    private ByteBuffer buffer;
    private Runnable requestRenderRunnable = new Runnable(){

        @Override
        public void run() {
            ZoomedView.this.requestZoomedViewRender();
        }
    };
    private long startTimeReRender;
    private long lastStartTimeReRender;

    public ZoomedView(Context context) {
        this(context, null, 0);
    }

    public ZoomedView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ZoomedView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Gesture:nothingDoneOnLongPress", "Gesture:clusteredLinksClicked", "Window:Resize", "Content:LocationChange");
    }

    void destroy() {
        ThreadUtils.removeCallbacksFromUiThread((Runnable)this.requestRenderRunnable);
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Gesture:nothingDoneOnLongPress", "Gesture:clusteredLinksClicked", "Window:Resize", "Content:LocationChange");
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        ImageView imageView = (ImageView)this.findViewById(R.id.dialog_close);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ZoomedView.this.stopZoomDisplay();
            }
        });
        this.zoomedImageView = (ImageView)this.findViewById(R.id.zoomed_image_view);
        this.zoomedImageView.setOnTouchListener((View.OnTouchListener)new ZoomedViewTouchListener());
    }

    private PointF getUnzoomedPositionFromPointInZoomedView(float f, float f2) {
        ImmutableViewportMetrics immutableViewportMetrics = this.layerView.getViewportMetrics();
        PointF pointF = immutableViewportMetrics.getMarginOffset();
        float f3 = immutableViewportMetrics.getWidth();
        float f4 = immutableViewportMetrics.getHeight();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        this.returnValue.x = (int)(f / 2.0f + pointF.x + ((float)layoutParams.leftMargin - pointF.x) * ((f3 - pointF.x - (float)(this.viewWidth / 2)) / (f3 - pointF.x - (float)this.viewWidth)));
        this.returnValue.y = (int)(f2 / 2.0f + pointF.y + ((float)layoutParams.topMargin - pointF.y) * ((f4 - pointF.y - (float)(this.viewHeight / 2)) / (f4 - pointF.y - (float)this.viewHeight)));
        return this.returnValue;
    }

    private PointF getZoomedViewTopLeftPositionFromTouchPosition(float f, float f2) {
        ImmutableViewportMetrics immutableViewportMetrics = this.layerView.getViewportMetrics();
        PointF pointF = immutableViewportMetrics.getMarginOffset();
        float f3 = immutableViewportMetrics.getWidth();
        float f4 = immutableViewportMetrics.getHeight();
        this.returnValue.x = (int)((f - (float)(this.viewWidth / 4)) / ((f3 - pointF.x - (float)(this.viewWidth / 2)) / (f3 - pointF.x - (float)this.viewWidth)) + pointF.x);
        this.returnValue.y = (int)((f2 - (float)(this.viewHeight / 4)) / ((f4 - pointF.y - (float)(this.viewHeight / 2)) / (f4 - pointF.y - (float)this.viewHeight)) + pointF.y);
        return this.returnValue;
    }

    private void moveZoomedView(ImmutableViewportMetrics immutableViewportMetrics, float f, float f2) {
        float f3 = immutableViewportMetrics.getWidth();
        float f4 = immutableViewportMetrics.getHeight();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        layoutParams.leftMargin = (int)f;
        layoutParams.topMargin = (int)f2;
        PointF pointF = immutableViewportMetrics.getMarginOffset();
        int n = (int)pointF.y;
        int n2 = (int)pointF.x;
        if (f2 < (float)n) {
            layoutParams.topMargin = n;
        } else if (f2 + (float)this.viewHeight > f4) {
            layoutParams.topMargin = (int)(f4 - (float)this.viewHeight);
        }
        if (f < (float)n2) {
            layoutParams.leftMargin = n2;
        } else if (f + (float)this.viewWidth > f3) {
            layoutParams.leftMargin = (int)(f3 - (float)this.viewWidth);
        }
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        PointF pointF2 = this.getUnzoomedPositionFromPointInZoomedView(0.0f, 0.0f);
        this.lastPosition = PointUtils.round(pointF2);
        this.requestZoomedViewRender();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.lastOrientation != configuration.orientation) {
            this.shouldBlockUpdate(true);
            this.lastOrientation = configuration.orientation;
        }
    }

    private void refreshZoomedViewSize(ImmutableViewportMetrics immutableViewportMetrics) {
        if (this.layerView == null) {
            return;
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        this.setCapturedSize(immutableViewportMetrics);
        this.moveZoomedView(immutableViewportMetrics, layoutParams.leftMargin, layoutParams.topMargin);
    }

    private void setCapturedSize(ImmutableViewportMetrics immutableViewportMetrics) {
        float f = Math.min(immutableViewportMetrics.getWidth(), immutableViewportMetrics.getHeight());
        this.viewWidth = (int)((double)(f * 80.0f) / 200.0) * 2;
        this.viewHeight = (int)((double)(f * 50.0f) / 200.0) * 2;
    }

    private void shouldBlockUpdate(boolean bl) {
        this.stopUpdateView = bl;
    }

    private Bitmap.Config getBitmapConfig() {
        return GeckoAppShell.getScreenDepth() == 24 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
    }

    private void startZoomDisplay(LayerView layerView, int n, int n2) {
        if (this.layerView == null) {
            this.layerView = layerView;
            this.layerView.addZoomedViewListener(this);
            this.layerView.setOnMetricsChangedZoomedViewportListener(this);
            ImmutableViewportMetrics immutableViewportMetrics = this.layerView.getViewportMetrics();
            this.setCapturedSize(immutableViewportMetrics);
        }
        this.startTimeReRender = 0L;
        this.shouldSetVisibleOnUpdate = true;
        this.moveUsingGeckoPosition(n, n2);
    }

    private void stopZoomDisplay() {
        this.shouldSetVisibleOnUpdate = false;
        this.setVisibility(8);
        ThreadUtils.removeCallbacksFromUiThread((Runnable)this.requestRenderRunnable);
        if (this.layerView != null) {
            this.layerView.setOnMetricsChangedZoomedViewportListener(null);
            this.layerView.removeZoomedViewListener(this);
            this.layerView = null;
        }
    }

    public void handleMessage(final String string2, final JSONObject jSONObject) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (string2.equals("Gesture:nothingDoneOnLongPress") || string2.equals("Gesture:clusteredLinksClicked")) {
                        JSONObject jSONObject2 = jSONObject.getJSONObject("clickPosition");
                        int n = jSONObject2.getInt("x");
                        int n2 = jSONObject2.getInt("y");
                        LayerView layerView = GeckoAppShell.getLayerView();
                        if (layerView != null) {
                            ZoomedView.this.startZoomDisplay(layerView, n, n2);
                        }
                    } else if (string2.equals("Window:Resize")) {
                        ImmutableViewportMetrics immutableViewportMetrics = ZoomedView.this.layerView.getViewportMetrics();
                        ZoomedView.this.refreshZoomedViewSize(immutableViewportMetrics);
                    } else if (string2.equals("Content:LocationChange")) {
                        ZoomedView.this.stopZoomDisplay();
                    }
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)"JSON exception", (Throwable)jSONException);
                }
            }
        });
    }

    private void moveUsingGeckoPosition(int n, int n2) {
        ImmutableViewportMetrics immutableViewportMetrics = this.layerView.getViewportMetrics();
        PointF pointF = this.getZoomedViewTopLeftPositionFromTouchPosition((float)n * immutableViewportMetrics.zoomFactor, (float)n2 * immutableViewportMetrics.zoomFactor);
        this.moveZoomedView(immutableViewportMetrics, pointF.x, pointF.y);
    }

    @Override
    public void onMetricsChanged(final ImmutableViewportMetrics immutableViewportMetrics) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ZoomedView.this.shouldBlockUpdate(false);
                ZoomedView.this.refreshZoomedViewSize(immutableViewportMetrics);
            }
        });
    }

    @Override
    public void onPanZoomStopped() {
    }

    @Override
    public void updateView(ByteBuffer byteBuffer) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.viewWidth, (int)this.viewHeight, (Bitmap.Config)this.getBitmapConfig());
        if (bitmap != null) {
            byteBuffer.rewind();
            try {
                bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            }
            catch (Exception exception) {
                Log.w((String)LOGTAG, (String)exception.toString());
            }
            BitmapDrawable bitmapDrawable = new BitmapDrawable(this.getResources(), bitmap);
            if (this.zoomedImageView != null) {
                this.zoomedImageView.setImageDrawable((Drawable)bitmapDrawable);
            }
        }
        if (this.shouldSetVisibleOnUpdate) {
            this.setVisibility(0);
            this.shouldSetVisibleOnUpdate = false;
        }
        this.lastStartTimeReRender = this.startTimeReRender;
        this.startTimeReRender = 0L;
    }

    private void updateBufferSize() {
        int n = GeckoAppShell.getScreenDepth() == 24 ? 4 : 2;
        int n2 = this.viewWidth * this.viewHeight * n;
        if (this.buffer == null || this.buffer.capacity() != n2) {
            this.buffer = DirectBufferAllocator.free((ByteBuffer)this.buffer);
            this.buffer = DirectBufferAllocator.allocate((int)n2);
        }
    }

    private boolean isRendering() {
        return this.startTimeReRender != 0L;
    }

    private boolean renderFrequencyTooHigh() {
        return System.nanoTime() - this.lastStartTimeReRender < 1000000L;
    }

    @Override
    public void requestZoomedViewRender() {
        if (this.stopUpdateView) {
            return;
        }
        ThreadUtils.removeCallbacksFromUiThread((Runnable)this.requestRenderRunnable);
        if (this.isRendering()) {
            ThreadUtils.postDelayedToUiThread((Runnable)this.requestRenderRunnable, (long)2000L);
            return;
        }
        if (this.renderFrequencyTooHigh()) {
            ThreadUtils.postDelayedToUiThread((Runnable)this.requestRenderRunnable, (long)2000L);
            return;
        }
        this.startTimeReRender = System.nanoTime();
        this.updateBufferSize();
        int n = Tabs.getInstance().getSelectedTab().getId();
        ImmutableViewportMetrics immutableViewportMetrics = this.layerView.getViewportMetrics();
        PointF pointF = immutableViewportMetrics.getOrigin();
        PointF pointF2 = immutableViewportMetrics.getMarginOffset();
        int n2 = (int)(pointF.x - pointF2.x) + this.lastPosition.x;
        int n3 = (int)(pointF.y - pointF2.y) + this.lastPosition.y;
        GeckoEvent geckoEvent = GeckoEvent.createZoomedViewEvent(n, n2, n3, this.viewWidth, this.viewHeight, 2.0f * immutableViewportMetrics.zoomFactor, this.buffer);
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    private class ZoomedViewTouchListener
    implements View.OnTouchListener {
        private float originRawX;
        private float originRawY;
        private boolean dragged;
        private MotionEvent actionDownEvent;

        private ZoomedViewTouchListener() {
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (ZoomedView.this.layerView == null) {
                return false;
            }
            switch (motionEvent.getAction()) {
                case 2: {
                    if (!this.moveZoomedView(motionEvent)) break;
                    this.dragged = true;
                    break;
                }
                case 1: {
                    if (this.dragged) {
                        this.dragged = false;
                        break;
                    }
                    ZoomedView.this.layerView.dispatchTouchEvent(this.actionDownEvent);
                    this.actionDownEvent.recycle();
                    PointF pointF = ZoomedView.this.getUnzoomedPositionFromPointInZoomedView(motionEvent.getX(), motionEvent.getY());
                    MotionEvent motionEvent2 = MotionEvent.obtain((long)motionEvent.getDownTime(), (long)motionEvent.getEventTime(), (int)1, (float)pointF.x, (float)pointF.y, (int)motionEvent.getMetaState());
                    ZoomedView.this.layerView.dispatchTouchEvent(motionEvent2);
                    motionEvent2.recycle();
                    break;
                }
                case 0: {
                    this.dragged = false;
                    this.originRawX = motionEvent.getRawX();
                    this.originRawY = motionEvent.getRawY();
                    PointF pointF = ZoomedView.this.getUnzoomedPositionFromPointInZoomedView(motionEvent.getX(), motionEvent.getY());
                    this.actionDownEvent = MotionEvent.obtain((long)motionEvent.getDownTime(), (long)motionEvent.getEventTime(), (int)0, (float)pointF.x, (float)pointF.y, (int)motionEvent.getMetaState());
                }
            }
            return true;
        }

        private boolean moveZoomedView(MotionEvent motionEvent) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)ZoomedView.this.getLayoutParams();
            if (!this.dragged && (float)Math.abs((int)(motionEvent.getRawX() - this.originRawX)) < PanZoomController.CLICK_THRESHOLD && (float)Math.abs((int)(motionEvent.getRawY() - this.originRawY)) < PanZoomController.CLICK_THRESHOLD) {
                return false;
            }
            float f = (float)layoutParams.leftMargin + motionEvent.getRawX() - this.originRawX;
            float f2 = (float)layoutParams.topMargin + motionEvent.getRawY() - this.originRawY;
            ImmutableViewportMetrics immutableViewportMetrics = ZoomedView.this.layerView.getViewportMetrics();
            ZoomedView.this.moveZoomedView(immutableViewportMetrics, f, f2);
            this.originRawX = motionEvent.getRawX();
            this.originRawY = motionEvent.getRawY();
            return true;
        }
    }
}

