/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.common.telemetry.TelemetryWrapper;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.fxa.PasswordStretcher;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractSetupActivity;
import org.mozilla.gecko.fxa.activities.FxAccountStatusActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.Engaged;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.tasks.FxAccountSignInTask;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;

public abstract class FxAccountAbstractUpdateCredentialsActivity
extends FxAccountAbstractSetupActivity {
    protected static final String LOG_TAG = FxAccountAbstractUpdateCredentialsActivity.class.getSimpleName();
    protected AndroidFxAccount fxAccount;
    protected final int layoutResourceId;

    public FxAccountAbstractUpdateCredentialsActivity(int n) {
        super(2);
        this.layoutResourceId = n;
    }

    @Override
    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(this.layoutResourceId);
        this.emailEdit = (AutoCompleteTextView)this.ensureFindViewById(null, R.id.email, "email edit");
        this.passwordEdit = (EditText)this.ensureFindViewById(null, R.id.password, "password edit");
        this.showPasswordButton = (Button)this.ensureFindViewById(null, R.id.show_password, "show password button");
        this.remoteErrorTextView = (TextView)this.ensureFindViewById(null, R.id.remote_error, "remote error text view");
        this.button = (Button)this.ensureFindViewById(null, R.id.button, "update credentials");
        this.progressBar = (ProgressBar)this.ensureFindViewById(null, R.id.progress, "progress bar");
        this.minimumPasswordLength = 1;
        this.createButton();
        this.addListeners();
        this.updateButtonState();
        this.createShowPasswordButton();
        this.emailEdit.setEnabled(false);
        TextView textView = (TextView)this.findViewById(R.id.forgot_password_link);
        ActivityUtils.linkTextView(textView, R.string.fxaccount_sign_in_forgot_password, R.string.fxaccount_link_forgot_password);
        this.updateFromIntentExtras();
        this.maybeEnableAnimations();
    }

    public void updateCredentials(String string2, String string3) {
        String string4 = this.fxAccount.getAccountServerURI();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string4, executorService);
        PasswordStretcher passwordStretcher = this.makePasswordStretcher(string3);
        try {
            this.hideRemoteError();
            UpdateCredentialsDelegate updateCredentialsDelegate = new UpdateCredentialsDelegate(string2, passwordStretcher, string4);
            new FxAccountSignInTask((Context)this, this, string2, passwordStretcher, fxAccountClient20, this.getQueryParameters(), updateCredentialsDelegate).execute(new Void[0]);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception updating credentials for account.", exception);
            this.showRemoteError(exception, R.string.fxaccount_update_credentials_unknown_error);
        }
    }

    protected void createButton() {
        this.button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = FxAccountAbstractUpdateCredentialsActivity.this.emailEdit.getText().toString();
                String string3 = FxAccountAbstractUpdateCredentialsActivity.this.passwordEdit.getText().toString();
                FxAccountAbstractUpdateCredentialsActivity.this.updateCredentials(string2, string3);
            }
        });
    }

    protected class UpdateCredentialsDelegate
    implements FxAccountClient10.RequestDelegate<FxAccountClient20.LoginResponse> {
        public final String email;
        public final String serverURI;
        public final PasswordStretcher passwordStretcher;

        public UpdateCredentialsDelegate(String string2, PasswordStretcher passwordStretcher, String string3) {
            this.email = string2;
            this.serverURI = string3;
            this.passwordStretcher = passwordStretcher;
        }

        @Override
        public void handleError(Exception exception) {
            FxAccountAbstractUpdateCredentialsActivity.this.showRemoteError(exception, R.string.fxaccount_update_credentials_unknown_error);
        }

        @Override
        public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
            if (fxAccountClientRemoteException.isUpgradeRequired()) {
                Logger.error(LOG_TAG, "Got upgrade required from remote server; transitioning Firefox Account to Doghouse state.");
                State state = FxAccountAbstractUpdateCredentialsActivity.this.fxAccount.getState();
                FxAccountAbstractUpdateCredentialsActivity.this.fxAccount.setState(state.makeDoghouseState());
                FxAccountAbstractUpdateCredentialsActivity.this.redirectToActivity(FxAccountStatusActivity.class);
                return;
            }
            FxAccountAbstractUpdateCredentialsActivity.this.showRemoteError(fxAccountClientRemoteException, R.string.fxaccount_update_credentials_unknown_error);
        }

        @Override
        public void handleSuccess(FxAccountClient20.LoginResponse loginResponse) {
            byte[] byArray;
            Object object;
            Logger.info(LOG_TAG, "Got success signing in.");
            if (FxAccountAbstractUpdateCredentialsActivity.this.fxAccount == null) {
                this.handleError(new IllegalStateException("fxAccount must not be null"));
                return;
            }
            try {
                object = this.passwordStretcher.getQuickStretchedPW(loginResponse.remoteEmail.getBytes("UTF-8"));
                byArray = FxAccountUtils.generateUnwrapBKey(object);
            }
            catch (Exception exception) {
                this.handleError(exception);
                return;
            }
            FxAccountAbstractUpdateCredentialsActivity.this.fxAccount.setState(new Engaged(this.email, loginResponse.uid, loginResponse.verified, byArray, loginResponse.sessionToken, loginResponse.keyFetchToken));
            FxAccountAbstractUpdateCredentialsActivity.this.fxAccount.requestSync(FirefoxAccounts.FORCE);
            if (FxAccountUtils.LOG_PERSONAL_INFORMATION) {
                FxAccountAbstractUpdateCredentialsActivity.this.fxAccount.dump();
            }
            FxAccountAbstractUpdateCredentialsActivity.this.setResult(-1);
            object = FxAccountAbstractUpdateCredentialsActivity.this.makeSuccessIntent(this.email, loginResponse);
            if (object != null) {
                FxAccountAbstractUpdateCredentialsActivity.this.startActivity((Intent)object);
            }
            FxAccountAbstractUpdateCredentialsActivity.this.finish();
            TelemetryWrapper.addToHistogram("FENNEC_SYNC11_MIGRATIONS_COMPLETED", 1);
        }
    }
}

