/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.os.Bundle;
import android.view.View;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;

public class FxAccountVerifiedAccountActivity
extends FxAccountAbstractActivity {
    private static final String LOG_TAG = FxAccountVerifiedAccountActivity.class.getSimpleName();
    protected AndroidFxAccount fxAccount;

    public FxAccountVerifiedAccountActivity() {
        super(2);
    }

    @Override
    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_account_verified);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.fxAccount = this.getAndroidFxAccount();
        if (this.fxAccount == null) {
            Logger.warn(LOG_TAG, "Could not get Firefox Account.");
            this.setResult(0);
            this.finish();
            return;
        }
        State state = this.fxAccount.getState();
        if (!state.verified) {
            Logger.warn(LOG_TAG, "Firefox Account is not verified; not displaying verified account activity.");
            this.setResult(0);
            this.finish();
            return;
        }
        View view = this.ensureFindViewById(null, R.id.button, "back to browsing button");
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ActivityUtils.openURLInFennec(view.getContext(), null);
            }
        });
    }
}

