/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import java.io.IOException;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.NewTabletUI;
import org.mozilla.gecko.R;
import org.mozilla.gecko.menu.GeckoMenuItem;
import org.mozilla.gecko.util.HardwareUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GeckoMenuInflater
extends MenuInflater {
    private static final String TAG_MENU = "menu";
    private static final String TAG_ITEM = "item";
    private static final int NO_ID = 0;
    private final Context mContext;

    public GeckoMenuInflater(Context context) {
        super(context);
        this.mContext = context;
    }

    public void inflate(int n, Menu menu) {
        try (XmlResourceParser xmlResourceParser = null;){
            xmlResourceParser = this.mContext.getResources().getXml(n);
            AttributeSet attributeSet = Xml.asAttributeSet((XmlPullParser)xmlResourceParser);
            this.parseMenu(xmlResourceParser, attributeSet, menu);
        }
    }

    private void parseMenu(XmlResourceParser xmlResourceParser, AttributeSet attributeSet, Menu menu) throws XmlPullParserException, IOException {
        ParsedItem parsedItem = null;
        int n = xmlResourceParser.getEventType();
        block4: do {
            String string2 = xmlResourceParser.getName();
            switch (n) {
                case 2: {
                    if (string2.equals(TAG_ITEM)) {
                        parsedItem = new ParsedItem();
                        this.parseItem(parsedItem, attributeSet);
                        break;
                    }
                    if (!string2.equals(TAG_MENU) || parsedItem == null) continue block4;
                    MenuItem menuItem = menu.addSubMenu(0, parsedItem.id, parsedItem.order, parsedItem.title);
                    parsedItem.hasSubMenu = true;
                    MenuItem menuItem2 = menuItem.getItem();
                    this.setValues(parsedItem, menuItem2);
                    this.parseMenu(xmlResourceParser, attributeSet, (Menu)menuItem);
                    break;
                }
                case 3: {
                    MenuItem menuItem;
                    if (xmlResourceParser.getName().equals(TAG_ITEM)) {
                        if (parsedItem.hasSubMenu) break;
                        menuItem = menu.add(0, parsedItem.id, parsedItem.order, parsedItem.title);
                        this.setValues(parsedItem, menuItem);
                        break;
                    }
                    if (!string2.equals(TAG_MENU)) break;
                    return;
                }
            }
        } while ((n = xmlResourceParser.next()) != 1);
    }

    public void parseItem(ParsedItem parsedItem, AttributeSet attributeSet) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attributeSet, R.styleable.MenuItem);
        parsedItem.id = typedArray.getResourceId(R.styleable.MenuItem_android_id, 0);
        parsedItem.order = typedArray.getInt(R.styleable.MenuItem_android_orderInCategory, 0);
        parsedItem.title = typedArray.getText(R.styleable.MenuItem_android_title);
        parsedItem.checkable = typedArray.getBoolean(R.styleable.MenuItem_android_checkable, false);
        parsedItem.checked = typedArray.getBoolean(R.styleable.MenuItem_android_checked, false);
        parsedItem.visible = typedArray.getBoolean(R.styleable.MenuItem_android_visible, true);
        parsedItem.enabled = typedArray.getBoolean(R.styleable.MenuItem_android_enabled, true);
        parsedItem.hasSubMenu = false;
        int n = !NewTabletUI.isEnabled(this.mContext) ? typedArray.getResourceId(R.styleable.MenuItem_android_icon, 0) : (parsedItem.id == R.id.reload ? R.drawable.new_tablet_ic_menu_reload : (HardwareUtils.isLargeTablet() && parsedItem.id == R.id.bookmark ? R.drawable.new_tablet_ic_menu_bookmark_add : typedArray.getResourceId(R.styleable.MenuItem_android_icon, 0)));
        parsedItem.iconRes = n;
        if (AppConstants.Versions.feature11Plus) {
            parsedItem.showAsAction = typedArray.getInt(R.styleable.MenuItem_android_showAsAction, 0);
        }
        typedArray.recycle();
    }

    public void setValues(ParsedItem parsedItem, MenuItem menuItem) {
        GeckoMenuItem geckoMenuItem = null;
        if (menuItem instanceof GeckoMenuItem) {
            geckoMenuItem = (GeckoMenuItem)menuItem;
        }
        if (geckoMenuItem != null) {
            geckoMenuItem.stopDispatchingChanges();
        }
        menuItem.setChecked(parsedItem.checked).setVisible(parsedItem.visible).setEnabled(parsedItem.enabled).setCheckable(parsedItem.checkable).setIcon(parsedItem.iconRes);
        if (AppConstants.Versions.feature11Plus) {
            menuItem.setShowAsAction(parsedItem.showAsAction);
        }
        if (geckoMenuItem != null) {
            geckoMenuItem.resumeDispatchingChanges();
        }
    }

    private class ParsedItem {
        public int id;
        public int order;
        public CharSequence title;
        public int iconRes;
        public boolean checkable;
        public boolean checked;
        public boolean visible;
        public boolean enabled;
        public int showAsAction;
        public boolean hasSubMenu;

        private ParsedItem() {
        }
    }
}

