/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.webapp;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.webapp.Allocator;
import org.mozilla.gecko.webapp.ApkResources;

public class InstallHelper
implements NativeEventListener {
    private static final String LOGTAG = "GeckoWebappInstallHelper";
    private static final String[] INSTALL_EVENT_NAMES = new String[]{"Webapps:Postinstall"};
    private final Context mContext;
    private final InstallCallback mCallback;
    private final ApkResources mApkResources;

    public InstallHelper(Context context, ApkResources apkResources, InstallCallback installCallback) {
        this.mContext = context;
        this.mCallback = installCallback;
        this.mApkResources = apkResources;
    }

    public void startInstall(String string2) throws IOException {
        this.startInstall(string2, null);
    }

    public void startInstall(final String string2, final JSONObject jSONObject) throws IOException {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    InstallHelper.this.install(string2, jSONObject);
                }
                catch (IOException iOException) {
                    InstallHelper.this.handleException(iOException);
                }
            }
        });
    }

    protected void handleException(Exception exception) {
        if (this.mCallback != null) {
            this.mCallback.installErrored(this, exception);
        } else {
            Log.e((String)LOGTAG, (String)"mozApps.install failed", (Throwable)exception);
        }
    }

    void install(String string2, JSONObject jSONObject) throws IOException {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        GeckoProfile geckoProfile = GeckoProfile.get(this.mContext, string2);
        try {
            jSONObject.put("apkPackageName", (Object)this.mApkResources.getPackageName());
            jSONObject.put("manifestURL", (Object)this.mApkResources.getManifestUrl());
            jSONObject.put("title", (Object)this.mApkResources.getAppName());
            jSONObject.put("manifest", (Object)new JSONObject(this.mApkResources.getManifest(this.mContext)));
            String string3 = this.mApkResources.getWebappType();
            jSONObject.putOpt("type", (Object)string3);
            if ("packaged".equals(string3)) {
                jSONObject.putOpt("updateManifest", (Object)new JSONObject(this.mApkResources.getMiniManifest(this.mContext)));
            }
            jSONObject.putOpt("profilePath", (Object)geckoProfile.getDir());
            if (this.mApkResources.isPackaged()) {
                File file = this.copyApplicationZipFile();
                jSONObject.putOpt("zipFilePath", (Object)Uri.fromFile((File)file).toString());
            }
        }
        catch (JSONException jSONException) {
            this.handleException((Exception)((Object)jSONException));
            return;
        }
        this.registerGeckoListener();
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Webapps:AutoInstall", jSONObject.toString()));
        this.calculateColor();
    }

    public File copyApplicationZipFile() throws IOException {
        if (!this.mApkResources.isPackaged()) {
            return null;
        }
        Uri uri = this.mApkResources.getZipFileUri();
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        File file = new File(this.mApkResources.getFileDirectory(), "application.zip");
        try {
            inputStream = this.mContext.getContentResolver().openInputStream(uri);
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            try {
                throw iOException;
            }
            catch (Throwable throwable) {
                InstallHelper.close(inputStream);
                InstallHelper.close(fileOutputStream);
                throw throwable;
            }
        }
        InstallHelper.close(inputStream);
        InstallHelper.close(fileOutputStream);
        return file;
    }

    private static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void registerGeckoListener() {
        EventDispatcher.getInstance().registerGeckoThreadListener(this, INSTALL_EVENT_NAMES);
    }

    private void calculateColor() {
        ThreadUtils.assertOnBackgroundThread();
        Allocator allocator = Allocator.getInstance(this.mContext);
        int n = allocator.getIndexForApp(this.mApkResources.getPackageName());
        Bitmap bitmap = BitmapUtils.getBitmapFromDrawable(this.mApkResources.getAppIcon());
        allocator.updateColor(n, BitmapUtils.getDominantColor(bitmap));
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, INSTALL_EVENT_NAMES);
        if (this.mCallback != null) {
            this.mCallback.installCompleted(this, string2, nativeJSObject);
        }
    }

    public static interface InstallCallback {
        public void installCompleted(InstallHelper var1, String var2, NativeJSObject var3);

        public void installErrored(InstallHelper var1, Exception var2);
    }
}

