/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search.providers;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.distribution.Distribution;
import org.mozilla.gecko.util.FileUtils;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.RawResource;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.search.providers.SearchEngine;
import org.xmlpull.v1.XmlPullParserException;

public class SearchEngineManager
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String LOG_TAG = "GeckoSearchEngineManager";
    private static final String PREF_GECKO_DEFAULT_ENGINE = "browser.search.defaultenginename";
    private static final String PREF_DEFAULT_ENGINE_KEY = "search.engines.defaultname";
    private Context context;
    private Distribution distribution;
    private SearchEngineCallback changeCallback;
    private SearchEngine engine;
    private String fallbackLocale;
    private int ignorePreferenceChange = 0;

    public SearchEngineManager(Context context, Distribution distribution) {
        this.context = context;
        this.distribution = distribution;
        GeckoSharedPrefs.forApp((Context)context).registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public void setChangeCallback(SearchEngineCallback searchEngineCallback) {
        this.changeCallback = searchEngineCallback;
    }

    public void getEngine(SearchEngineCallback searchEngineCallback) {
        if (this.engine != null) {
            searchEngineCallback.execute(this.engine);
        } else {
            this.getDefaultEngine(searchEngineCallback);
        }
    }

    public void destroy() {
        GeckoSharedPrefs.forApp((Context)this.context).unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        this.context = null;
        this.distribution = null;
        this.changeCallback = null;
        this.engine = null;
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string) {
        if (!TextUtils.equals((CharSequence)PREF_DEFAULT_ENGINE_KEY, (CharSequence)string)) {
            return;
        }
        if (this.ignorePreferenceChange > 0) {
            --this.ignorePreferenceChange;
            return;
        }
        this.getDefaultEngine(this.changeCallback);
    }

    private void runCallback(final SearchEngine searchEngine, final SearchEngineCallback searchEngineCallback) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SearchEngineManager.this.engine = searchEngine;
                searchEngineCallback.execute(searchEngine);
            }
        });
    }

    private void getDefaultEngine(final SearchEngineCallback searchEngineCallback) {
        this.distribution.addOnDistributionReadyCallback(new Distribution.ReadyCallback(){

            public void distributionNotFound() {
                this.defaultBehavior();
            }

            public void distributionFound(Distribution distribution) {
                this.defaultBehavior();
            }

            public void distributionArrivedLate(Distribution distribution) {
                String string = SearchEngineManager.this.getDefaultEngineNameFromDistribution();
                if (string == null) {
                    return;
                }
                SearchEngineManager.this.ignorePreferenceChange++;
                GeckoSharedPrefs.forApp((Context)SearchEngineManager.this.context).edit().putString(SearchEngineManager.PREF_DEFAULT_ENGINE_KEY, string).apply();
                SearchEngine searchEngine = SearchEngineManager.this.createEngineFromName(string);
                SearchEngineManager.this.runCallback(searchEngine, searchEngineCallback);
            }

            private void defaultBehavior() {
                String string = GeckoSharedPrefs.forApp((Context)SearchEngineManager.this.context).getString(SearchEngineManager.PREF_DEFAULT_ENGINE_KEY, null);
                if (string != null) {
                    Log.d((String)SearchEngineManager.LOG_TAG, (String)("Found default engine name in SharedPreferences: " + string));
                } else {
                    string = SearchEngineManager.this.getDefaultEngineNameFromDistribution();
                    if (string == null) {
                        string = SearchEngineManager.this.getDefaultEngineNameFromLocale();
                    }
                    SearchEngineManager.this.ignorePreferenceChange++;
                    GeckoSharedPrefs.forApp((Context)SearchEngineManager.this.context).edit().putString(SearchEngineManager.PREF_DEFAULT_ENGINE_KEY, string).apply();
                }
                SearchEngine searchEngine = SearchEngineManager.this.createEngineFromName(string);
                SearchEngineManager.this.runCallback(searchEngine, searchEngineCallback);
            }
        });
    }

    private String getDefaultEngineNameFromDistribution() {
        if (!this.distribution.exists()) {
            return null;
        }
        File file = this.distribution.getDistributionFile("preferences.json");
        if (file == null) {
            return null;
        }
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2 = new JSONObject(FileUtils.getFileContents((File)file));
            String string = Locales.getLanguageTag((Locale)Locale.getDefault());
            String string2 = "LocalizablePreferences." + string;
            if (jSONObject2.has(string2) && (jSONObject = jSONObject2.getJSONObject(string2)).has(PREF_GECKO_DEFAULT_ENGINE)) {
                Log.d((String)LOG_TAG, (String)"Found default engine name in distribution LocalizablePreferences override.");
                return jSONObject.getString(PREF_GECKO_DEFAULT_ENGINE);
            }
            if (jSONObject2.has("LocalizablePreferences") && (jSONObject = jSONObject2.getJSONObject("LocalizablePreferences")).has(PREF_GECKO_DEFAULT_ENGINE)) {
                Log.d((String)LOG_TAG, (String)"Found default engine name in distribution LocalizablePreferences.");
                return jSONObject.getString(PREF_GECKO_DEFAULT_ENGINE);
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)"Error getting search engine name from preferences.json", (Throwable)iOException);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOG_TAG, (String)"Error parsing preferences.json", (Throwable)jSONException);
        }
        return null;
    }

    private String getDefaultEngineNameFromLocale() {
        try {
            JSONObject jSONObject = new JSONObject(RawResource.getAsString((Context)this.context, (int)R.raw.browsersearch));
            if (jSONObject.has("default")) {
                Log.d((String)LOG_TAG, (String)"Found default engine name in browsersearch.json.");
                return jSONObject.getString("default");
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)"Error getting search engine name from browsersearch.json", (Throwable)iOException);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOG_TAG, (String)"Error parsing browsersearch.json", (Throwable)jSONException);
        }
        return null;
    }

    private SearchEngine createEngineFromName(String string) {
        SearchEngine searchEngine = this.createEngineFromDistribution(string);
        if (searchEngine == null) {
            searchEngine = this.createEngineFromLocale(string);
        }
        if (searchEngine == null) {
            searchEngine = this.createEngineFromProfile(string);
        }
        if (searchEngine == null) {
            Log.e((String)LOG_TAG, (String)("Could not create search engine from name: " + string));
        }
        return searchEngine;
    }

    private SearchEngine createEngineFromDistribution(String string) {
        if (!this.distribution.exists()) {
            return null;
        }
        File file = this.distribution.getDistributionFile("searchplugins");
        if (file == null) {
            return null;
        }
        File[] fileArray = new File(file, "common").listFiles();
        if (fileArray == null) {
            Log.e((String)LOG_TAG, (String)"Could not find search plugin files in distribution directory");
            return null;
        }
        return this.createEngineFromFileList(fileArray, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchEngine createEngineFromLocale(String string) {
        InputStream inputStream = this.getInputStreamFromSearchPluginsJar("list.txt");
        BufferedReader bufferedReader = this.getBufferedReader(inputStream);
        try {
            while (true) {
                String string2;
                if ((string2 = bufferedReader.readLine()) != null) {
                    InputStream inputStream2 = this.getInputStreamFromSearchPluginsJar(string2 + ".xml");
                    SearchEngine searchEngine = this.createEngineFromInputStream(string2, inputStream2);
                    if (searchEngine == null || !searchEngine.getName().equals(string)) continue;
                    SearchEngine searchEngine2 = searchEngine;
                    return searchEngine2;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)("Error creating shipped search engine from name: " + string), (Throwable)iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private SearchEngine createEngineFromProfile(String string) {
        File file = GeckoProfile.get((Context)this.context).getFile("searchplugins");
        if (file == null) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            Log.e((String)LOG_TAG, (String)"Could not find search plugin files in profile directory");
            return null;
        }
        return this.createEngineFromFileList(fileArray, string);
    }

    private SearchEngine createEngineFromFileList(File[] fileArray, String string) {
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                SearchEngine searchEngine = this.createEngineFromInputStream(null, fileInputStream);
                if (searchEngine == null || !searchEngine.getName().equals(string)) continue;
                return searchEngine;
            }
            catch (IOException iOException) {
                Log.e((String)LOG_TAG, (String)("Error creating earch engine from name: " + string), (Throwable)iOException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchEngine createEngineFromInputStream(String string, InputStream inputStream) {
        SearchEngine searchEngine;
        try {
            searchEngine = new SearchEngine(string, inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException | XmlPullParserException throwable2) {
                Log.e((String)LOG_TAG, (String)"Exception creating search engine", (Throwable)throwable2);
                return null;
            }
        }
        inputStream.close();
        return searchEngine;
    }

    private InputStream getInputStreamFromSearchPluginsJar(String string) {
        Locale locale = Locale.getDefault();
        String string2 = Locales.getLanguageTag((Locale)locale);
        String string3 = this.getSearchPluginsJarURL(string2, string);
        InputStream inputStream = GeckoJarReader.getStream((String)string3);
        if (inputStream != null) {
            return inputStream;
        }
        String string4 = Locales.getLanguage((Locale)locale);
        if (!string2.equals(string4) && (inputStream = GeckoJarReader.getStream((String)(string3 = this.getSearchPluginsJarURL(string4, string)))) != null) {
            return inputStream;
        }
        string3 = this.getSearchPluginsJarURL(this.getFallbackLocale(), string);
        return GeckoJarReader.getStream((String)string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFallbackLocale() {
        if (this.fallbackLocale != null) {
            return this.fallbackLocale;
        }
        InputStream inputStream = GeckoJarReader.getStream((String)this.getJarURL("!/chrome/chrome.manifest"));
        BufferedReader bufferedReader = this.getBufferedReader(inputStream);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("locale global ")) continue;
                this.fallbackLocale = string.split(" ", 4)[2];
                break;
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)"Error reading fallback locale from chrome registry", (Throwable)iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        return this.fallbackLocale;
    }

    private String getSearchPluginsJarURL(String string, String string2) {
        String string3 = "!/chrome/" + string + "/locale/" + string + "/browser/searchplugins/" + string2;
        return this.getJarURL(string3);
    }

    private String getJarURL(String string) {
        return "jar:jar:file://" + this.context.getPackageResourcePath() + "!/" + "assets/omni.ja" + string;
    }

    private BufferedReader getBufferedReader(InputStream inputStream) {
        try {
            return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static interface SearchEngineCallback {
        public void execute(SearchEngine var1);
    }
}

