/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.conn.ssl;

import ch.boye.httpclientandroidlib.NameValuePair;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.conn.ssl.TokenParser;
import ch.boye.httpclientandroidlib.message.BasicNameValuePair;
import ch.boye.httpclientandroidlib.message.ParserCursor;
import ch.boye.httpclientandroidlib.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

@Immutable
final class DistinguishedNameParser {
    public static final DistinguishedNameParser INSTANCE = new DistinguishedNameParser();
    private static final BitSet EQUAL_OR_COMMA_OR_PLUS = TokenParser.INIT_BITSET(61, 44, 43);
    private static final BitSet COMMA_OR_PLUS = TokenParser.INIT_BITSET(44, 43);
    private final TokenParser tokenParser = new InternalTokenParser();

    DistinguishedNameParser() {
    }

    String parseToken(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet) {
        return this.tokenParser.parseToken(charArrayBuffer, parserCursor, bitSet);
    }

    String parseValue(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet) {
        return this.tokenParser.parseValue(charArrayBuffer, parserCursor, bitSet);
    }

    NameValuePair parseParameter(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        String string = this.parseToken(charArrayBuffer, parserCursor, EQUAL_OR_COMMA_OR_PLUS);
        if (parserCursor.atEnd()) {
            return new BasicNameValuePair(string, null);
        }
        char c = charArrayBuffer.charAt(parserCursor.getPos());
        parserCursor.updatePos(parserCursor.getPos() + 1);
        if (c == ',') {
            return new BasicNameValuePair(string, null);
        }
        String string2 = this.parseValue(charArrayBuffer, parserCursor, COMMA_OR_PLUS);
        if (!parserCursor.atEnd()) {
            parserCursor.updatePos(parserCursor.getPos() + 1);
        }
        return new BasicNameValuePair(string, string2);
    }

    public List<NameValuePair> parse(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        this.tokenParser.skipWhiteSpace(charArrayBuffer, parserCursor);
        while (!parserCursor.atEnd()) {
            NameValuePair nameValuePair = this.parseParameter(charArrayBuffer, parserCursor);
            arrayList.add(nameValuePair);
        }
        return arrayList;
    }

    public List<NameValuePair> parse(String string) {
        if (string == null) {
            return null;
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        return this.parse(charArrayBuffer, parserCursor);
    }

    static class InternalTokenParser
    extends TokenParser {
        InternalTokenParser() {
        }

        @Override
        public void copyUnquotedContent(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet, StringBuilder stringBuilder) {
            int n = parserCursor.getPos();
            int n2 = parserCursor.getPos();
            int n3 = parserCursor.getUpperBound();
            boolean bl = false;
            int n4 = n2;
            while (n4 < n3) {
                char c = charArrayBuffer.charAt(n4);
                if (bl) {
                    stringBuilder.append(c);
                    bl = false;
                } else {
                    if (bitSet != null && bitSet.get(c) || TokenParser.isWhitespace(c) || c == '\"') break;
                    if (c == '\\') {
                        bl = true;
                    } else {
                        stringBuilder.append(c);
                    }
                }
                ++n4;
                ++n;
            }
            parserCursor.updatePos(n);
        }
    }
}

