/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import org.mozilla.gecko.background.fxa.FxAccountUtils;

public class FxAccountAgeLockoutHelper {
    private static final String LOG_TAG = FxAccountAgeLockoutHelper.class.getSimpleName();
    protected static long ELAPSED_REALTIME_OF_LAST_FAILED_AGE_CHECK = 0L;

    public static synchronized boolean isLockedOut(long l) {
        if (ELAPSED_REALTIME_OF_LAST_FAILED_AGE_CHECK == 0L) {
            return false;
        }
        long l2 = l - ELAPSED_REALTIME_OF_LAST_FAILED_AGE_CHECK;
        boolean bl = l2 < 900000L;
        FxAccountUtils.pii(LOG_TAG, "Checking if locked out: it's been " + l2 + "ms " + "since last lockout, so " + (bl ? "yes." : "no."));
        return bl;
    }

    public static synchronized void lockOut(long l) {
        FxAccountUtils.pii(LOG_TAG, "Locking out at time: " + l);
        ELAPSED_REALTIME_OF_LAST_FAILED_AGE_CHECK = Math.max(l, ELAPSED_REALTIME_OF_LAST_FAILED_AGE_CHECK);
    }

    public static boolean isMagicYear(int n) {
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(1);
        return n2 - n == 13;
    }

    public static boolean passesAgeCheck(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        int n4 = calendar.get(1);
        int n5 = calendar.get(2);
        int n6 = calendar.get(5);
        calendar.clear();
        calendar.set(n4 - 13, n5, n6);
        calendar.add(13, 1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.clear();
        calendar2.set(n3, n2, n);
        boolean bl = calendar2.before(calendar);
        if (FxAccountUtils.LOG_PERSONAL_INFORMATION) {
            StringBuilder stringBuilder = new StringBuilder();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd", Locale.getDefault());
            stringBuilder.append("Age check ");
            stringBuilder.append(bl ? "passes" : "fails");
            stringBuilder.append(": birthday is ");
            stringBuilder.append(simpleDateFormat.format(calendar2.getTime()));
            stringBuilder.append("; latest birthday is ");
            stringBuilder.append(simpleDateFormat.format(calendar.getTime()));
            stringBuilder.append(" (Y/M/D).");
            FxAccountUtils.pii(LOG_TAG, stringBuilder.toString());
        }
        return bl;
    }

    public static boolean passesAgeCheck(int n, int n2, String string2, String[] stringArray) {
        Integer n3;
        if (string2 == null) {
            throw new IllegalArgumentException("yearText must not be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("yearItems must not be null");
        }
        if (!Arrays.asList(stringArray).contains(string2)) {
            FxAccountUtils.pii(LOG_TAG, "Failed age check: year text was not found in item list.");
            return false;
        }
        try {
            n3 = Integer.valueOf(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            FxAccountUtils.pii(LOG_TAG, "Passed age check: year text was found in item list but was not a number.");
            return true;
        }
        return FxAccountAgeLockoutHelper.passesAgeCheck(n, n2, n3);
    }
}

