/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.graphics.drawable.BitmapDrawable;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.Searches;
import org.mozilla.gecko.db.SuggestedSites;
import org.mozilla.gecko.db.TabsAccessor;
import org.mozilla.gecko.db.URLMetadata;
import org.mozilla.gecko.distribution.Distribution;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;

public interface BrowserDB {
    public Searches getSearches();

    public TabsAccessor getTabsAccessor();

    public URLMetadata getURLMetadata();

    public int addDefaultBookmarks(Context var1, ContentResolver var2, int var3);

    public int addDistributionBookmarks(ContentResolver var1, Distribution var2, int var3);

    public void invalidate();

    public int getCount(ContentResolver var1, String var2);

    public Cursor filter(ContentResolver var1, CharSequence var2, int var3, EnumSet<FilterFlags> var4);

    public Cursor getTopSites(ContentResolver var1, int var2);

    public Cursor getTopSites(ContentResolver var1, int var2, int var3);

    public void updateVisitedHistory(ContentResolver var1, String var2);

    public void updateHistoryTitle(ContentResolver var1, String var2, String var3);

    public Cursor getAllVisitedHistory(ContentResolver var1);

    public Cursor getRecentHistory(ContentResolver var1, int var2);

    public void expireHistory(ContentResolver var1, BrowserContract.ExpirePriority var2);

    public void removeHistoryEntry(ContentResolver var1, String var2);

    public void clearHistory(ContentResolver var1);

    public String getUrlForKeyword(ContentResolver var1, String var2);

    public boolean isBookmark(ContentResolver var1, String var2);

    public void addBookmark(ContentResolver var1, String var2, String var3);

    public Cursor getBookmarkForUrl(ContentResolver var1, String var2);

    public void removeBookmarksWithURL(ContentResolver var1, String var2);

    public void registerBookmarkObserver(ContentResolver var1, ContentObserver var2);

    public void updateBookmark(ContentResolver var1, int var2, String var3, String var4, String var5);

    public Cursor getBookmarksInFolder(ContentResolver var1, long var2);

    public Cursor getReadingList(ContentResolver var1);

    public Cursor getReadingListUnfetched(ContentResolver var1);

    public boolean isReadingListItem(ContentResolver var1, String var2);

    public void addReadingListItem(ContentResolver var1, ContentValues var2);

    public void updateReadingListItem(ContentResolver var1, ContentValues var2);

    public void removeReadingListItemWithURL(ContentResolver var1, String var2);

    public LoadFaviconResult getFaviconForUrl(ContentResolver var1, String var2);

    public String getFaviconURLFromPageURL(ContentResolver var1, String var2);

    public void updateFaviconForUrl(ContentResolver var1, String var2, byte[] var3, String var4);

    public byte[] getThumbnailForUrl(ContentResolver var1, String var2);

    public void updateThumbnailForUrl(ContentResolver var1, String var2, BitmapDrawable var3);

    public Cursor getThumbnailsForUrls(ContentResolver var1, List<String> var2);

    public void removeThumbnails(ContentResolver var1);

    public void updateHistoryInBatch(ContentResolver var1, Collection<ContentProviderOperation> var2, String var3, String var4, long var5, int var7);

    public void updateBookmarkInBatch(ContentResolver var1, Collection<ContentProviderOperation> var2, String var3, String var4, String var5, long var6, long var8, long var10, long var12, String var14, int var15);

    public void updateFaviconInBatch(ContentResolver var1, Collection<ContentProviderOperation> var2, String var3, String var4, String var5, byte[] var6);

    public Cursor getPinnedSites(ContentResolver var1, int var2);

    public void pinSite(ContentResolver var1, String var2, String var3, int var4);

    public void unpinSite(ContentResolver var1, int var2);

    public boolean hideSuggestedSite(String var1);

    public void setSuggestedSites(SuggestedSites var1);

    public boolean hasSuggestedImageUrl(String var1);

    public String getSuggestedImageUrlForUrl(String var1);

    public int getSuggestedBackgroundColorForUrl(String var1);

    public int getTrackingIdForUrl(String var1);

    public static enum FilterFlags {
        EXCLUDE_PINNED_SITES;

    }

    public static interface Factory {
        public BrowserDB get(String var1, File var2);
    }
}

