/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.PointF;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.gfx.DisplayPortMetrics;
import org.mozilla.gecko.gfx.Overscroll;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.gfx.PanZoomTarget;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;
import org.mozilla.gecko.util.GeckoEventListener;

class NativePanZoomController
implements PanZoomController,
GeckoEventListener {
    private final PanZoomTarget mTarget;
    private final EventDispatcher mDispatcher;

    NativePanZoomController(PanZoomTarget panZoomTarget, View view, EventDispatcher eventDispatcher) {
        this.mTarget = panZoomTarget;
        this.mDispatcher = eventDispatcher;
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            this.init();
        } else {
            this.mDispatcher.registerGeckoThreadListener(this, "Gecko:Ready");
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if ("Gecko:Ready".equals(string2)) {
            this.mDispatcher.unregisterGeckoThreadListener(this, "Gecko:Ready");
            this.init();
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        GeckoEvent geckoEvent = GeckoEvent.createMotionEvent(motionEvent, true);
        return this.handleTouchEvent(geckoEvent);
    }

    @Override
    public boolean onMotionEvent(MotionEvent motionEvent) {
        return false;
    }

    @Override
    public boolean onKeyEvent(KeyEvent keyEvent) {
        return false;
    }

    @Override
    public PointF getVelocityVector() {
        return new PointF(0.0f, 0.0f);
    }

    @Override
    public void pageRectUpdated() {
    }

    @Override
    public void abortPanning() {
    }

    @Override
    public void notifyDefaultActionPrevented(boolean bl) {
        throw new IllegalStateException("APZCCallbackHandler::NotifyDefaultPrevented should be getting called, not this!");
    }

    @Override
    public native void abortAnimation();

    private native void init();

    private native boolean handleTouchEvent(GeckoEvent var1);

    private native void handleMotionEvent(GeckoEvent var1);

    @Override
    public native void destroy();

    @Override
    public native boolean getRedrawHint();

    @Override
    public native void setOverScrollMode(int var1);

    @Override
    public native int getOverScrollMode();

    @WrapElementForJNI(allowMultithread=true, stubName="RequestContentRepaintWrapper")
    private void requestContentRepaint(float f, float f2, float f3, float f4, float f5) {
        this.mTarget.forceRedraw(new DisplayPortMetrics(f, f2, f + f3, f2 + f4, f5));
    }

    @Override
    public void setOverscrollHandler(Overscroll overscroll) {
    }
}

