/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.StringUtils;

public class ReadingListRow
extends LinearLayout {
    private final Resources resources;
    private final TextView title;
    private final TextView excerpt;
    private final TextView readTime;
    private static final int AVERAGE_READING_SPEED = 250;
    private static final float AVERAGE_WORD_LENGTH = 5.1f;

    public ReadingListRow(Context context) {
        this(context, null);
    }

    public ReadingListRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        LayoutInflater.from((Context)context).inflate(R.layout.reading_list_row_view, (ViewGroup)this);
        this.resources = context.getResources();
        this.title = (TextView)this.findViewById(R.id.title);
        this.excerpt = (TextView)this.findViewById(R.id.excerpt);
        this.readTime = (TextView)this.findViewById(R.id.read_time);
    }

    public void updateFromCursor(Cursor cursor) {
        if (cursor == null) {
            return;
        }
        String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
        String string3 = cursor.getString(cursor.getColumnIndexOrThrow("title"));
        this.title.setText((CharSequence)(TextUtils.isEmpty((CharSequence)string3) ? StringUtils.stripCommonSubdomains((String)StringUtils.stripScheme((String)string2)) : string3));
        String string4 = cursor.getString(cursor.getColumnIndexOrThrow("excerpt"));
        this.excerpt.setText((CharSequence)(TextUtils.isEmpty((CharSequence)string4) ? string2 : string4));
    }

    private static int getEstimatedReadTime(int n) {
        int n2 = (int)Math.ceil((float)n / 5.1f / 250.0f);
        return Math.max(n2, 1);
    }
}

