/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.NewTabletUI;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.lwt.LightweightTheme;
import org.mozilla.gecko.lwt.LightweightThemeDrawable;
import org.mozilla.gecko.tabs.TabsGridLayout;
import org.mozilla.gecko.tabs.TabsListLayout;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.widget.GeckoPopupMenu;
import org.mozilla.gecko.widget.IconTabWidget;

public class TabsPanel
extends LinearLayout
implements GeckoPopupMenu.OnMenuItemClickListener,
LightweightTheme.OnChangeListener,
IconTabWidget.OnTabChangedListener {
    private static final String LOGTAG = "Gecko" + TabsPanel.class.getSimpleName();
    private final Context mContext;
    private final GeckoApp mActivity;
    private final LightweightTheme mTheme;
    private RelativeLayout mHeader;
    private TabsLayoutContainer mTabsContainer;
    private PanelView mPanel;
    private PanelView mPanelNormal;
    private PanelView mPanelPrivate;
    private RelativeLayout mFooter;
    private TabsLayoutChangeListener mLayoutChangeListener;
    private IconTabWidget mTabWidget;
    private static ImageButton mMenuButton;
    private static ImageButton mAddTab;
    private ImageButton mNavBackButton;
    private Panel mCurrentPanel;
    private boolean mIsSideBar;
    private boolean mVisible;
    private boolean mHeaderVisible;
    private final GeckoPopupMenu mPopupMenu;

    public static View createTabsLayout(Context context, AttributeSet attributeSet) {
        if (HardwareUtils.isTablet()) {
            return new TabsGridLayout(context, attributeSet);
        }
        return new TabsListLayout(context, attributeSet);
    }

    public TabsPanel(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mActivity = (GeckoApp)context;
        this.mTheme = ((GeckoApplication)context.getApplicationContext()).getLightweightTheme();
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.setOrientation(1);
        this.mCurrentPanel = Panel.NORMAL_TABS;
        this.mPopupMenu = new GeckoPopupMenu(context);
        this.mPopupMenu.inflate(R.menu.tabs_menu);
        this.mPopupMenu.setOnMenuItemClickListener(this);
        this.inflateLayout(context);
        this.initialize();
    }

    private void inflateLayout(Context context) {
        if (NewTabletUI.isEnabled(context)) {
            LayoutInflater.from((Context)context).inflate(R.layout.tabs_panel_default, (ViewGroup)this);
        } else {
            LayoutInflater.from((Context)context).inflate(R.layout.tabs_panel, (ViewGroup)this);
        }
    }

    private void initialize() {
        this.mHeader = (RelativeLayout)this.findViewById(R.id.tabs_panel_header);
        this.mTabsContainer = (TabsLayoutContainer)this.findViewById(R.id.tabs_container);
        this.mPanelNormal = (PanelView)this.findViewById(R.id.normal_tabs);
        this.mPanelNormal.setTabsPanel(this);
        this.mPanelPrivate = (PanelView)this.findViewById(R.id.private_tabs_panel);
        this.mPanelPrivate.setTabsPanel(this);
        if (AppConstants.Versions.feature11Plus) {
            this.mFooter = (RelativeLayout)this.findViewById(R.id.tabs_panel_footer);
        }
        mAddTab = (ImageButton)this.findViewById(R.id.add_tab);
        mAddTab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TabsPanel.this.addTab();
            }
        });
        this.mTabWidget = (IconTabWidget)this.findViewById(R.id.tab_widget);
        this.mTabWidget.addTab(R.drawable.tabs_normal, R.string.tabs_normal);
        this.mTabWidget.addTab(R.drawable.tabs_private, R.string.tabs_private);
        this.mTabWidget.setTabSelectionListener(this);
        mMenuButton = (ImageButton)this.findViewById(R.id.menu);
        mMenuButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TabsPanel.this.showMenu();
            }
        });
        if (HardwareUtils.isTablet()) {
            ViewStub viewStub = (ViewStub)this.findViewById(R.id.nav_back_stub);
            this.mNavBackButton = (ImageButton)viewStub.inflate();
            this.mNavBackButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    TabsPanel.this.mActivity.onBackPressed();
                }
            });
        }
    }

    public void showMenu() {
        Menu menu2 = this.mPopupMenu.getMenu();
        menu2.findItem(R.id.new_tab).setVisible(this.mCurrentPanel != Panel.NORMAL_TABS);
        menu2.findItem(R.id.new_private_tab).setVisible(this.mCurrentPanel != Panel.PRIVATE_TABS);
        menu2.findItem(R.id.close_all_tabs).setVisible(this.mCurrentPanel == Panel.NORMAL_TABS);
        menu2.findItem(R.id.close_private_tabs).setVisible(this.mCurrentPanel == Panel.PRIVATE_TABS);
        this.mPopupMenu.show();
    }

    private void addTab() {
        if (this.mCurrentPanel == Panel.NORMAL_TABS) {
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.ACTIONBAR, "new_tab");
            this.mActivity.addTab();
        } else {
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.ACTIONBAR, "new_private_tab");
            this.mActivity.addPrivateTab();
        }
        this.mActivity.autoHideTabs();
    }

    @Override
    public void onTabChanged(int n) {
        if (n == 0) {
            this.show(Panel.NORMAL_TABS);
        } else {
            this.show(Panel.PRIVATE_TABS);
        }
    }

    @Override
    public boolean onMenuItemClick(MenuItem menuItem) {
        int n = menuItem.getItemId();
        if (n == R.id.close_all_tabs) {
            if (this.mCurrentPanel == Panel.NORMAL_TABS) {
                String string2 = this.getResources().getResourceEntryName(n);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.MENU, string2);
                mMenuButton.setEnabled(false);
                ((CloseAllPanelView)this.mPanelNormal).closeAll();
            } else {
                Log.e((String)LOGTAG, (String)"Close all tabs menu item should only be visible for normal tabs panel");
            }
            return true;
        }
        if (n == R.id.close_private_tabs) {
            if (this.mCurrentPanel == Panel.PRIVATE_TABS) {
                String string3 = this.getResources().getResourceEntryName(n);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.MENU, string3);
                ((CloseAllPanelView)this.mPanelPrivate).closeAll();
            } else {
                Log.e((String)LOGTAG, (String)"Close private tabs menu item should only be visible for private tabs panel");
            }
            return true;
        }
        if (n == R.id.new_tab || n == R.id.new_private_tab) {
            this.hide();
        }
        return this.mActivity.onOptionsItemSelected(menuItem);
    }

    private static int getTabContainerHeight(TabsLayoutContainer tabsLayoutContainer) {
        Resources resources = tabsLayoutContainer.getContext().getResources();
        int n = resources.getDisplayMetrics().heightPixels;
        int n2 = resources.getDimensionPixelSize(R.dimen.browser_toolbar_height);
        if (HardwareUtils.isTablet()) {
            return n - n2;
        }
        PanelView panelView = tabsLayoutContainer.getCurrentPanelView();
        if (panelView != null && !panelView.shouldExpand()) {
            return resources.getDimensionPixelSize(R.dimen.tabs_layout_horizontal_height);
        }
        Rect rect = new Rect();
        tabsLayoutContainer.getWindowVisibleDisplayFrame(rect);
        int n3 = rect.bottom - rect.top;
        return (int)Math.max((float)n * 0.5f, Math.min((float)n3 - 2.5f * (float)n2, (float)n3 * 0.8f) - (float)n2);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mTheme.addListener(this);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mTheme.removeListener(this);
    }

    @Override
    public void onLightweightThemeChanged() {
        int n = this.getResources().getColor(R.color.background_tabs);
        LightweightThemeDrawable lightweightThemeDrawable = this.mTheme.getColorDrawable((View)this, n, true);
        if (lightweightThemeDrawable == null) {
            return;
        }
        lightweightThemeDrawable.setAlpha(34, 0);
        this.setBackgroundDrawable(lightweightThemeDrawable);
    }

    @Override
    public void onLightweightThemeReset() {
        this.setBackgroundColor(this.getContext().getResources().getColor(R.color.background_tabs));
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.onLightweightThemeChanged();
    }

    public void show(Panel panel) {
        boolean bl = !this.mVisible;
        this.prepareToShow(panel);
        if (this.isSideBar()) {
            if (bl) {
                this.dispatchLayoutChange(this.getWidth(), this.getHeight());
            }
        } else {
            int n = this.getVerticalPanelHeight();
            this.dispatchLayoutChange(this.getWidth(), n);
        }
    }

    public void prepareToDrag() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null && tab.isPrivate()) {
            this.prepareToShow(Panel.PRIVATE_TABS);
        } else {
            this.prepareToShow(Panel.NORMAL_TABS);
        }
        if (this.mIsSideBar) {
            this.prepareSidebarAnimation(this.getWidth());
        }
    }

    public void prepareToShow(Panel panel) {
        if (!this.isShown()) {
            this.setVisibility(0);
        }
        if (this.mPanel != null) {
            this.mPanel.hide();
        }
        this.mVisible = true;
        this.mCurrentPanel = panel;
        int n = panel.ordinal();
        this.mTabWidget.setCurrentTab(n);
        switch (panel) {
            case NORMAL_TABS: {
                this.mPanel = this.mPanelNormal;
                break;
            }
            case PRIVATE_TABS: {
                this.mPanel = this.mPanelPrivate;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown panel type " + (Object)((Object)panel));
            }
        }
        this.mPanel.show();
        if (this.mFooter != null) {
            this.mFooter.setVisibility(0);
        }
        mAddTab.setVisibility(0);
        mAddTab.setImageLevel(n);
        if (!HardwareUtils.hasMenuButton()) {
            mMenuButton.setVisibility(0);
            mMenuButton.setEnabled(true);
            this.mPopupMenu.setAnchor((View)mMenuButton);
        } else {
            this.mPopupMenu.setAnchor((View)mAddTab);
        }
    }

    public void hideImmediately() {
        this.mVisible = false;
        this.setVisibility(4);
    }

    public int getVerticalPanelHeight() {
        int n = this.mContext.getResources().getDimensionPixelSize(R.dimen.browser_toolbar_height);
        int n2 = n + TabsPanel.getTabContainerHeight(this.mTabsContainer);
        return n2;
    }

    public void hide() {
        this.mHeaderVisible = false;
        if (this.mVisible) {
            this.mVisible = false;
            this.mPopupMenu.dismiss();
            this.dispatchLayoutChange(0, 0);
        }
    }

    public void refresh() {
        this.removeAllViews();
        this.inflateLayout(this.mContext);
        this.initialize();
        if (this.mVisible) {
            this.show(this.mCurrentPanel);
        }
    }

    public void autoHidePanel() {
        this.mActivity.autoHideTabs();
    }

    public boolean isShown() {
        return this.mVisible;
    }

    public boolean isSideBar() {
        return this.mIsSideBar;
    }

    public void setIsSideBar(boolean bl) {
        this.mIsSideBar = bl;
    }

    public Panel getCurrentPanel() {
        return this.mCurrentPanel;
    }

    public void setHWLayerEnabled(boolean bl) {
        if (AppConstants.Versions.preHC) {
            return;
        }
        if (bl) {
            this.mHeader.setLayerType(2, null);
            this.mTabsContainer.setLayerType(2, null);
        } else {
            this.mHeader.setLayerType(0, null);
            this.mTabsContainer.setLayerType(0, null);
        }
    }

    public void prepareSidebarAnimation(int n) {
        if (this.mVisible) {
            ViewHelper.setTranslationX((View)this.mHeader, -n);
            ViewHelper.setTranslationX((View)this.mTabsContainer, -n);
            ViewHelper.setTranslationX((View)this.mFooter, -n);
        }
    }

    public void prepareTabsAnimation(PropertyAnimator propertyAnimator) {
        if (AppConstants.Versions.preHC) {
            return;
        }
        if (this.mIsSideBar) {
            int n = this.getWidth();
            this.prepareSidebarAnimation(n);
            int n2 = this.mVisible ? 0 : -n;
            propertyAnimator.attach((View)this.mTabsContainer, PropertyAnimator.Property.TRANSLATION_X, n2);
            propertyAnimator.attach((View)this.mHeader, PropertyAnimator.Property.TRANSLATION_X, n2);
            propertyAnimator.attach((View)this.mFooter, PropertyAnimator.Property.TRANSLATION_X, n2);
        } else if (!this.mHeaderVisible) {
            int n;
            Resources resources = this.getContext().getResources();
            int n3 = resources.getDimensionPixelSize(R.dimen.browser_toolbar_height);
            int n4 = n = this.mVisible ? 0 : -n3;
            if (this.mVisible) {
                ViewHelper.setTranslationY((View)this.mHeader, -n3);
                ViewHelper.setTranslationY((View)this.mTabsContainer, -n3);
                ViewHelper.setAlpha((View)this.mTabsContainer, 0.0f);
            }
            propertyAnimator.attach((View)this.mTabsContainer, PropertyAnimator.Property.ALPHA, this.mVisible ? 1.0f : 0.0f);
            propertyAnimator.attach((View)this.mTabsContainer, PropertyAnimator.Property.TRANSLATION_Y, n);
            propertyAnimator.attach((View)this.mHeader, PropertyAnimator.Property.TRANSLATION_Y, n);
        }
        this.setHWLayerEnabled(true);
    }

    public void translateInRange(float f) {
        Resources resources = this.getContext().getResources();
        if (!this.mIsSideBar) {
            int n = resources.getDimensionPixelSize(R.dimen.browser_toolbar_height);
            int n2 = (int)(-((1.0f - f) * (float)n));
            ViewHelper.setTranslationY((View)this.mHeader, n2);
            ViewHelper.setTranslationY((View)this.mTabsContainer, n2);
            this.mTabsContainer.setAlpha(f);
        } else {
            int n = this.getWidth();
            this.prepareSidebarAnimation(n);
            int n3 = (int)(-((1.0f - f) * (float)n));
            ViewHelper.setTranslationX((View)this.mHeader, n3);
            ViewHelper.setTranslationX((View)this.mTabsContainer, n3);
            ViewHelper.setTranslationX((View)this.mFooter, n3);
        }
    }

    public void finishTabsAnimation() {
        if (AppConstants.Versions.preHC) {
            return;
        }
        this.setHWLayerEnabled(false);
        if (!this.mVisible && this.mPanel != null) {
            this.mPanel.hide();
            this.mPanel = null;
        }
    }

    public void setTabsLayoutChangeListener(TabsLayoutChangeListener tabsLayoutChangeListener) {
        this.mLayoutChangeListener = tabsLayoutChangeListener;
    }

    private void dispatchLayoutChange(int n, int n2) {
        if (this.mLayoutChangeListener != null) {
            this.mLayoutChangeListener.onTabsLayoutChange(n, n2);
        }
    }

    static class TabsPanelToolbar
    extends LinearLayout
    implements LightweightTheme.OnChangeListener {
        private final LightweightTheme mTheme;

        public TabsPanelToolbar(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.mTheme = ((GeckoApplication)context.getApplicationContext()).getLightweightTheme();
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, (int)context.getResources().getDimension(R.dimen.browser_toolbar_height)));
            this.setOrientation(0);
        }

        public void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.mTheme.addListener(this);
        }

        public void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            this.mTheme.removeListener(this);
        }

        @Override
        public void onLightweightThemeChanged() {
            int n = this.getResources().getColor(R.color.background_tabs);
            LightweightThemeDrawable lightweightThemeDrawable = this.mTheme.getColorDrawable((View)this, n);
            if (lightweightThemeDrawable == null) {
                return;
            }
            lightweightThemeDrawable.setAlpha(34, 34);
            this.setBackgroundDrawable(lightweightThemeDrawable);
        }

        @Override
        public void onLightweightThemeReset() {
            this.setBackgroundColor(this.getContext().getResources().getColor(R.color.background_tabs));
        }

        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            super.onLayout(bl, n, n2, n3, n4);
            this.onLightweightThemeChanged();
        }
    }

    static class TabsLayoutContainer
    extends FrameLayout {
        public TabsLayoutContainer(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public PanelView getCurrentPanelView() {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                if (!(view instanceof PanelView) || view.getVisibility() != 0) continue;
                return (PanelView)view;
            }
            return null;
        }

        protected void onMeasure(int n, int n2) {
            if (!GeckoAppShell.getGeckoInterface().hasTabsSideBar()) {
                int n3 = View.MeasureSpec.makeMeasureSpec((int)TabsPanel.getTabContainerHeight(this), (int)0x40000000);
                super.onMeasure(n, n3);
            } else {
                super.onMeasure(n, n2);
            }
        }
    }

    public static interface TabsLayoutChangeListener {
        public void onTabsLayoutChange(int var1, int var2);
    }

    public static interface TabsLayout
    extends CloseAllPanelView {
        public void setEmptyView(View var1);
    }

    public static interface CloseAllPanelView
    extends PanelView {
        public void closeAll();
    }

    public static interface PanelView {
        public void setTabsPanel(TabsPanel var1);

        public void show();

        public void hide();

        public boolean shouldExpand();
    }

    public static enum Panel {
        NORMAL_TABS,
        PRIVATE_TABS;

    }
}

