/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tiles;

import android.util.Log;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.tiles.Tile;

public class TilesRecorder {
    public static final String ACTION_CLICK = "click";
    private static final String LOG_TAG = "GeckoTilesRecorder";
    private static final String EVENT_TILES_CLICK = "Tiles:Click";

    public void recordAction(Tab tab, String string2, int n, List<Tile> list, String string3) {
        Tile tile = list.get(n);
        if (tab == null || tile == null) {
            throw new IllegalArgumentException("Tab and tile cannot be null");
        }
        if (tile.id == -1) {
            return;
        }
        try {
            Tile tile2;
            JSONArray jSONArray = new JSONArray();
            int n2 = -1;
            int n3 = 0;
            for (int i = 0; i < list.size(); ++i) {
                tile2 = list.get(i);
                if (tile2 == null) continue;
                jSONArray.put((Object)this.jsonForTile(tile2, n3, i));
                if (tile == tile2) {
                    n2 = n3;
                }
                ++n3;
            }
            if (n2 == -1) {
                throw new IllegalStateException("Clicked tile index not set");
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(string2, n2);
            jSONObject.put("tiles", (Object)jSONArray);
            jSONObject.put("locale", (Object)string3);
            tile2 = new JSONObject();
            tile2.put("tabId", tab.getId());
            tile2.put("payload", jSONObject.toString());
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent(EVENT_TILES_CLICK, tile2.toString()));
        }
        catch (JSONException jSONException) {
            Log.e((String)LOG_TAG, (String)"JSON error", (Throwable)jSONException);
        }
    }

    private JSONObject jsonForTile(Tile tile, int n, int n2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (tile.id != -1) {
            jSONObject.put("id", tile.id);
        }
        if (tile.pinned) {
            jSONObject.put("pin", true);
        }
        if (n != n2) {
            jSONObject.put("pos", n2);
        }
        return jSONObject;
    }
}

