/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.toolbar.BrowserToolbarTabletBase;

class BrowserToolbarTablet
extends BrowserToolbarTabletBase {
    private static final int FORWARD_ANIMATION_DURATION = 450;
    private final int forwardButtonTranslationWidth = this.getResources().getDimensionPixelOffset(R.dimen.new_tablet_nav_button_width);
    private ForwardButtonState forwardButtonState;
    private boolean backButtonWasEnabledOnStartEditing;

    public BrowserToolbarTablet(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        ViewHelper.setTranslationX((View)this.forwardButton, -this.forwardButtonTranslationWidth);
        BrowserToolbarTablet.setButtonEnabled(this.forwardButton, true);
        this.updateForwardButtonState(ForwardButtonState.HIDDEN);
        this.setRightMargin();
    }

    private void setRightMargin() {
        Resources resources = this.getContext().getResources();
        int n = resources.getDimensionPixelOffset(R.dimen.new_tablet_browser_toolbar_menu_right_margin);
        this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), n, this.getPaddingBottom());
    }

    private void updateForwardButtonState(ForwardButtonState forwardButtonState) {
        this.forwardButtonState = forwardButtonState;
        this.forwardButton.setEnabled(this.forwardButtonState == ForwardButtonState.DISPLAYED);
    }

    @Override
    public boolean isAnimating() {
        return false;
    }

    @Override
    protected void triggerStartEditingTransition(PropertyAnimator propertyAnimator) {
        this.showUrlEditLayout();
    }

    @Override
    protected void triggerStopEditingTransition() {
        this.hideUrlEditLayout();
    }

    @Override
    protected void animateForwardButton(BrowserToolbarTabletBase.ForwardButtonAnimation forwardButtonAnimation) {
        boolean bl;
        boolean bl2 = bl = forwardButtonAnimation == BrowserToolbarTabletBase.ForwardButtonAnimation.SHOW;
        if (this.forwardButtonState != ForwardButtonState.HIDDEN && bl || this.forwardButtonState != ForwardButtonState.DISPLAYED && !bl) {
            return;
        }
        this.updateForwardButtonState(ForwardButtonState.TRANSITIONING);
        PropertyAnimator propertyAnimator = new PropertyAnimator(this.isSwitchingTabs ? 10L : 450L);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
                if (!bl) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarTablet.this.urlDisplayLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarTablet.this.urlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    BrowserToolbarTablet.this.requestLayout();
                }
            }

            @Override
            public void onPropertyAnimationEnd() {
                ForwardButtonState forwardButtonState;
                if (bl) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarTablet.this.urlDisplayLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbarTablet.this.forwardButtonTranslationWidth;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarTablet.this.urlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbarTablet.this.forwardButtonTranslationWidth;
                    forwardButtonState = ForwardButtonState.DISPLAYED;
                } else {
                    forwardButtonState = ForwardButtonState.HIDDEN;
                }
                BrowserToolbarTablet.this.urlDisplayLayout.finishForwardAnimation();
                BrowserToolbarTablet.this.updateForwardButtonState(forwardButtonState);
                BrowserToolbarTablet.this.requestLayout();
            }
        });
        this.prepareForwardAnimation(propertyAnimator, forwardButtonAnimation, this.forwardButtonTranslationWidth);
        propertyAnimator.start();
    }

    private void prepareForwardAnimation(PropertyAnimator propertyAnimator, BrowserToolbarTabletBase.ForwardButtonAnimation forwardButtonAnimation, int n) {
        if (forwardButtonAnimation == BrowserToolbarTabletBase.ForwardButtonAnimation.HIDE) {
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.TRANSLATION_X, -n);
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.ALPHA, 0.0f);
        } else {
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.ALPHA, 1.0f);
        }
        this.urlDisplayLayout.prepareForwardAnimation(propertyAnimator, forwardButtonAnimation, n);
    }

    @Override
    public void triggerTabsPanelTransition(PropertyAnimator propertyAnimator, boolean bl) {
    }

    @Override
    public void setToolBarButtonsAlpha(float f) {
    }

    @Override
    public void startEditing(String string2, PropertyAnimator propertyAnimator) {
        this.backButtonWasEnabledOnStartEditing = this.backButton.isEnabled();
        BrowserToolbarTablet.setButtonEnabled(this.backButton, false);
        BrowserToolbarTablet.setButtonEnabled(this.forwardButton, false);
        super.startEditing(string2, propertyAnimator);
    }

    @Override
    public String commitEdit() {
        this.stopEditingNewTablet();
        return super.commitEdit();
    }

    @Override
    public String cancelEdit() {
        if (this.isEditing()) {
            this.stopEditingNewTablet();
            BrowserToolbarTablet.setButtonEnabled(this.backButton, this.backButtonWasEnabledOnStartEditing);
            this.updateForwardButtonState(this.forwardButtonState);
        }
        return super.cancelEdit();
    }

    private void stopEditingNewTablet() {
        BrowserToolbarTablet.setButtonEnabled(this.forwardButton, true);
    }

    @Override
    protected Drawable getLWTDefaultStateSetDrawable() {
        return BrowserToolbar.getLightweightThemeDrawable((View)this, this.getResources(), this.getTheme(), R.color.background_normal);
    }

    private static enum ForwardButtonState {
        HIDDEN,
        DISPLAYED,
        TRANSITIONING;

    }
}

