/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.entity;

import ch.boye.httpclientandroidlib.annotation.NotThreadSafe;
import ch.boye.httpclientandroidlib.client.entity.DecompressingEntity;
import java.io.IOException;
import java.io.InputStream;

@NotThreadSafe
class LazyDecompressingInputStream
extends InputStream {
    private final InputStream wrappedStream;
    private final DecompressingEntity decompressingEntity;
    private InputStream wrapperStream;

    public LazyDecompressingInputStream(InputStream inputStream, DecompressingEntity decompressingEntity) {
        this.wrappedStream = inputStream;
        this.decompressingEntity = decompressingEntity;
    }

    private void initWrapper() throws IOException {
        if (this.wrapperStream == null) {
            this.wrapperStream = this.decompressingEntity.decorate(this.wrappedStream);
        }
    }

    @Override
    public int read() throws IOException {
        this.initWrapper();
        return this.wrapperStream.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.initWrapper();
        return this.wrapperStream.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.initWrapper();
        return this.wrapperStream.read(byArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        this.initWrapper();
        return this.wrapperStream.skip(l);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        this.initWrapper();
        return this.wrapperStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.wrapperStream != null) {
                this.wrapperStream.close();
            }
        }
        finally {
            this.wrappedStream.close();
        }
    }
}

