/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.util.GeckoEventListener;

class JavaAddonManager
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoJavaAddonManager";
    private static JavaAddonManager sInstance;
    private final EventDispatcher mDispatcher = EventDispatcher.getInstance();
    private final Map<String, Map<String, GeckoEventListener>> mAddonCallbacks = new HashMap<String, Map<String, GeckoEventListener>>();
    private Context mApplicationContext;

    public static JavaAddonManager getInstance() {
        if (sInstance == null) {
            sInstance = new JavaAddonManager();
        }
        return sInstance;
    }

    private JavaAddonManager() {
    }

    void init(Context context) {
        if (this.mApplicationContext != null) {
            return;
        }
        this.mApplicationContext = context;
        this.mDispatcher.registerGeckoThreadListener(this, "Dex:Load", "Dex:Unload");
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        block8: {
            try {
                if (string2.equals("Dex:Load")) {
                    String string3 = jSONObject.getString("zipfile");
                    String string4 = jSONObject.getString("impl");
                    Log.d((String)LOGTAG, (String)("Attempting to load classes.dex file from " + string3 + " and instantiate " + string4));
                    try {
                        File file = this.mApplicationContext.getDir("dex", 0);
                        DexClassLoader dexClassLoader = new DexClassLoader(string3, file.getAbsolutePath(), null, this.mApplicationContext.getClassLoader());
                        Class clazz = dexClassLoader.loadClass(string4);
                        try {
                            Constructor constructor = clazz.getDeclaredConstructor(Map.class);
                            HashMap<String, Handler.Callback> hashMap = new HashMap<String, Handler.Callback>();
                            constructor.newInstance(hashMap);
                            this.registerCallbacks(string3, hashMap);
                            break block8;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            Log.d((String)LOGTAG, (String)"Did not find constructor with parameters Map<String, Handler.Callback>. Falling back to default constructor...");
                            clazz.newInstance();
                        }
                    }
                    catch (Exception exception) {
                        Log.e((String)LOGTAG, (String)"Unable to load dex successfully", (Throwable)exception);
                    }
                    break block8;
                }
                if (string2.equals("Dex:Unload")) {
                    String string5 = jSONObject.getString("zipfile");
                    this.unregisterCallbacks(string5);
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)("Exception handling message [" + string2 + "]:"), (Throwable)jSONException);
            }
        }
    }

    private void registerCallbacks(String string2, Map<String, Handler.Callback> map) {
        Map<String, GeckoEventListener> map2 = this.mAddonCallbacks.get(string2);
        if (map2 != null) {
            Log.w((String)LOGTAG, (String)("Found pre-existing callbacks for zipfile [" + string2 + "]; aborting re-registration!"));
            return;
        }
        map2 = new HashMap<String, GeckoEventListener>();
        for (String string3 : map.keySet()) {
            CallbackWrapper callbackWrapper = new CallbackWrapper(map.get(string3));
            this.mDispatcher.registerGeckoThreadListener(callbackWrapper, string3);
            map2.put(string3, callbackWrapper);
        }
        this.mAddonCallbacks.put(string2, map2);
    }

    private void unregisterCallbacks(String string2) {
        Map<String, GeckoEventListener> map = this.mAddonCallbacks.remove(string2);
        if (map == null) {
            Log.w((String)LOGTAG, (String)("Attempting to unregister callbacks from zipfile [" + string2 + "] which has no callbacks registered."));
            return;
        }
        for (String string3 : map.keySet()) {
            this.mDispatcher.unregisterGeckoThreadListener(map.get(string3), string3);
        }
    }

    private static class CallbackWrapper
    implements GeckoEventListener {
        private final Handler.Callback mDelegate;
        private Bundle mBundle;

        CallbackWrapper(Handler.Callback callback) {
            this.mDelegate = callback;
        }

        private Bundle jsonToBundle(JSONObject jSONObject) {
            Bundle bundle = new Bundle();
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                try {
                    String string2 = (String)iterator.next();
                    Object object = jSONObject.get(string2);
                    if (object instanceof Integer) {
                        bundle.putInt(string2, ((Integer)object).intValue());
                        continue;
                    }
                    if (object instanceof String) {
                        bundle.putString(string2, (String)object);
                        continue;
                    }
                    if (object instanceof Boolean) {
                        bundle.putBoolean(string2, ((Boolean)object).booleanValue());
                        continue;
                    }
                    if (object instanceof Long) {
                        bundle.putLong(string2, ((Long)object).longValue());
                        continue;
                    }
                    if (!(object instanceof Double)) continue;
                    bundle.putDouble(string2, ((Double)object).doubleValue());
                }
                catch (JSONException jSONException) {
                    Log.d((String)JavaAddonManager.LOGTAG, (String)"Error during JSON->bundle conversion", (Throwable)jSONException);
                }
            }
            return bundle;
        }

        public void handleMessage(String string2, JSONObject jSONObject) {
            try {
                if (this.mBundle != null) {
                    Log.w((String)JavaAddonManager.LOGTAG, (String)("Event [" + string2 + "] handler is re-entrant; response messages may be lost"));
                }
                this.mBundle = this.jsonToBundle(jSONObject);
                Message message = new Message();
                message.setData(this.mBundle);
                this.mDelegate.handleMessage(message);
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("response", (Object)this.mBundle.getString("response"));
                EventDispatcher.sendResponse(jSONObject, jSONObject2);
                this.mBundle = null;
            }
            catch (Exception exception) {
                Log.e((String)JavaAddonManager.LOGTAG, (String)"Caught exception thrown from wrapped addon message handler", (Throwable)exception);
            }
        }
    }
}

