/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

public class OuterLayout
extends RelativeLayout {
    private final double AUTO_OPEN_SPEED_LIMIT = 800.0;
    private ViewDragHelper mDragHelper;
    private int mDraggingBorder;
    private int mDragRange;
    private boolean mIsOpen = false;
    private int mDraggingState = 0;
    private DragCallback mDragCallback;

    public OuterLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    private void updateRanges() {
        this.mDragRange = this.mDragCallback.getDragRange() + this.mDragCallback.getLowerLimit();
    }

    private void updateOrientation() {
        this.mDragHelper.setEdgeTrackingEnabled(0);
    }

    protected void onFinishInflate() {
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)new DragHelperCallback());
        this.mIsOpen = false;
        super.onFinishInflate();
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (this.mDragCallback.canDrag(motionEvent) && this.mDragHelper.shouldInterceptTouchEvent(motionEvent)) {
            return true;
        }
        return this.mIsOpen && this.mDragCallback.canInterceptEventWhileOpen(motionEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mDragCallback.canDrag(motionEvent) || this.mDraggingState == 1) {
            this.mDragHelper.processTouchEvent(motionEvent);
        }
        return true;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        if (this.mDragRange == 0) {
            this.mDragRange = n2 / 2;
        }
        super.onSizeChanged(n, n2, n3, n4);
    }

    public void computeScroll() {
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setClosed() {
        this.mIsOpen = false;
        this.mDragHelper.abort();
    }

    public void setOpen() {
        this.mIsOpen = true;
        this.mDragHelper.abort();
    }

    public void setDraggableCallback(DragCallback dragCallback) {
        this.mDragCallback = dragCallback;
        this.updateOrientation();
    }

    public void reset() {
        this.updateOrientation();
        if (this.isMoving()) {
            this.mDragHelper.abort();
            if (this.mDragCallback != null) {
                this.mDragCallback.stopDrag(false);
                this.mDragCallback.onDragProgress(0.0f);
            }
        }
    }

    public void updateDragHelperParameters() {
        this.mDragRange = this.mDragCallback.getDragRange() + this.mDragCallback.getLowerLimit();
        this.updateOrientation();
    }

    public boolean isMoving() {
        return this.mDraggingState == 1 || this.mDraggingState == 2;
    }

    public boolean isOpen() {
        return this.mIsOpen;
    }

    public View findTopChildUnder(MotionEvent motionEvent) {
        return this.mDragHelper.findTopChildUnder((int)motionEvent.getX(), (int)motionEvent.getY());
    }

    public void restoreTargetViewPosition() {
        this.mDragCallback.getViewToDrag().offsetTopAndBottom(this.mDraggingBorder);
    }

    private class DragHelperCallback
    extends ViewDragHelper.Callback {
        private DragHelperCallback() {
        }

        public void onViewDragStateChanged(int n) {
            if (n == OuterLayout.this.mDraggingState) {
                return;
            }
            if ((OuterLayout.this.mDraggingState == 1 || OuterLayout.this.mDraggingState == 2) && n == 0) {
                float f = OuterLayout.this.mDragRange;
                float f2 = OuterLayout.this.mDragCallback.getLowerLimit();
                if ((float)OuterLayout.this.mDraggingBorder == f2) {
                    OuterLayout.this.mIsOpen = false;
                    OuterLayout.this.mDragCallback.onDragProgress(0.0f);
                } else if ((float)OuterLayout.this.mDraggingBorder == f) {
                    OuterLayout.this.mIsOpen = true;
                    OuterLayout.this.mDragCallback.onDragProgress(1.0f);
                }
                OuterLayout.this.mDragCallback.stopDrag(OuterLayout.this.mIsOpen);
            }
            if (n == 1 && !OuterLayout.this.isMoving()) {
                OuterLayout.this.mDragCallback.startDrag(OuterLayout.this.mIsOpen);
                OuterLayout.this.updateRanges();
            }
            OuterLayout.this.mDraggingState = n;
        }

        public void onViewPositionChanged(View view, int n, int n2, int n3, int n4) {
            OuterLayout.this.mDraggingBorder = n2;
            float f = Math.min(1.0f, (float)n2 / (float)OuterLayout.this.mDragRange);
            OuterLayout.this.mDragCallback.onDragProgress(f);
        }

        public int getViewVerticalDragRange(View view) {
            return OuterLayout.this.mDragRange;
        }

        public int getOrderedChildIndex(int n) {
            return OuterLayout.this.mDragCallback.getOrderedChildIndex(n);
        }

        public boolean tryCaptureView(View view, int n) {
            return view.getId() == OuterLayout.this.mDragCallback.getViewToDrag().getId();
        }

        public int clampViewPositionVertical(View view, int n, int n2) {
            return n;
        }

        public void onViewReleased(View view, float f, float f2) {
            int n;
            int n2;
            float f3 = OuterLayout.this.mDragRange;
            float f4 = f2;
            if (OuterLayout.this.mDraggingBorder == OuterLayout.this.mDragCallback.getLowerLimit()) {
                return;
            }
            if ((float)OuterLayout.this.mDraggingBorder == f3) {
                return;
            }
            boolean bl = false;
            if ((double)f4 > 800.0) {
                bl = true;
            } else if ((double)f4 < -800.0) {
                bl = false;
            } else if ((float)OuterLayout.this.mDraggingBorder > f3 / 2.0f) {
                bl = true;
            } else if ((float)OuterLayout.this.mDraggingBorder < f3 / 2.0f) {
                bl = false;
            }
            if (bl) {
                n2 = 0;
                n = OuterLayout.this.mDragRange;
            } else {
                n2 = 0;
                n = OuterLayout.this.mDragCallback.getLowerLimit();
            }
            if (OuterLayout.this.mDragHelper.settleCapturedViewAt(n2, n)) {
                ViewCompat.postInvalidateOnAnimation((View)OuterLayout.this);
            }
        }
    }

    public static interface DragCallback {
        public void startDrag(boolean var1);

        public void stopDrag(boolean var1);

        public int getDragRange();

        public int getOrderedChildIndex(int var1);

        public boolean canDrag(MotionEvent var1);

        public boolean canInterceptEventWhileOpen(MotionEvent var1);

        public void onDragProgress(float var1);

        public View getViewToDrag();

        public int getLowerLimit();
    }
}

