/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.util.Log;
import android.widget.Toast;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.ReadingListAccessor;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public final class ReadingListHelper
implements NativeEventListener {
    private static final String LOGTAG = "GeckoReadingListHelper";
    protected final Context context;
    private final BrowserDB db;
    private final ReadingListAccessor readingListAccessor;
    private final ContentObserver contentObserver;

    public ReadingListHelper(Context context, GeckoProfile geckoProfile) {
        this.context = context;
        this.db = geckoProfile.getDB();
        this.readingListAccessor = this.db.getReadingListAccessor();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Reader:AddToList", "Reader:UpdateList", "Reader:FaviconRequest", "Reader:ListStatusRequest", "Reader:RemoveFromList");
        this.contentObserver = new ContentObserver(null){

            public void onChange(boolean bl) {
                ReadingListHelper.this.fetchContent();
            }
        };
        this.readingListAccessor.registerContentObserver(context, this.contentObserver);
    }

    public void uninit() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Reader:AddToList", "Reader:UpdateList", "Reader:FaviconRequest", "Reader:ListStatusRequest", "Reader:RemoveFromList");
        this.context.getContentResolver().unregisterContentObserver(this.contentObserver);
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        switch (string2) {
            case "Reader:AddToList": {
                this.handleAddToList(eventCallback, nativeJSObject);
                break;
            }
            case "Reader:UpdateList": {
                this.handleUpdateList(nativeJSObject);
                break;
            }
            case "Reader:FaviconRequest": {
                this.handleReaderModeFaviconRequest(eventCallback, nativeJSObject.getString("url"));
                break;
            }
            case "Reader:RemoveFromList": {
                this.handleRemoveFromList(nativeJSObject.getString("url"));
                break;
            }
            case "Reader:ListStatusRequest": {
                this.handleReadingListStatusRequest(eventCallback, nativeJSObject.getString("url"));
            }
        }
    }

    private void handleAddToList(final EventCallback eventCallback, NativeJSObject nativeJSObject) {
        final ContentResolver contentResolver = this.context.getContentResolver();
        final String string2 = nativeJSObject.getString("url");
        final ContentValues contentValues = this.getContentValues(nativeJSObject);
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ReadingListHelper.this.readingListAccessor.isReadingListItem(contentResolver, string2)) {
                    ReadingListHelper.this.showToast(R.string.reading_list_duplicate, 0);
                    eventCallback.sendError((Object)("URL already in reading list: " + string2));
                } else {
                    ReadingListHelper.this.readingListAccessor.addReadingListItem(contentResolver, contentValues);
                    ReadingListHelper.this.showToast(R.string.reading_list_added, 0);
                    eventCallback.sendSuccess((Object)string2);
                }
            }
        });
    }

    private void handleUpdateList(NativeJSObject nativeJSObject) {
        final ContentResolver contentResolver = this.context.getContentResolver();
        final ContentValues contentValues = this.getContentValues(nativeJSObject);
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ReadingListHelper.this.readingListAccessor.updateReadingListItem(contentResolver, contentValues);
            }
        });
    }

    private ContentValues getContentValues(NativeJSObject nativeJSObject) {
        ContentValues contentValues = new ContentValues();
        if (nativeJSObject.has("id")) {
            contentValues.put("_id", Integer.valueOf(nativeJSObject.getInt("id")));
        }
        if (nativeJSObject.has("url")) {
            contentValues.put("url", nativeJSObject.getString("url"));
        }
        if (nativeJSObject.has("title")) {
            contentValues.put("title", nativeJSObject.getString("title"));
        }
        if (nativeJSObject.has("length")) {
            contentValues.put("length", Integer.valueOf(nativeJSObject.getInt("length")));
        }
        if (nativeJSObject.has("excerpt")) {
            contentValues.put("excerpt", nativeJSObject.getString("excerpt"));
        }
        if (nativeJSObject.has("status")) {
            contentValues.put("content_status", Integer.valueOf(nativeJSObject.getInt("status")));
        }
        return contentValues;
    }

    private void handleReaderModeFaviconRequest(final EventCallback eventCallback, final String string2) {
        new UIAsyncTask.WithoutParams<String>(ThreadUtils.getBackgroundHandler()){

            public String doInBackground() {
                return Favicons.getFaviconURLForPageURL(ReadingListHelper.this.db, ReadingListHelper.this.context.getContentResolver(), string2);
            }

            public void onPostExecute(String string22) {
                JSONObject jSONObject = new JSONObject();
                if (string22 != null) {
                    try {
                        jSONObject.put("url", (Object)string2);
                        jSONObject.put("faviconUrl", (Object)string22);
                    }
                    catch (JSONException jSONException) {
                        Log.w((String)ReadingListHelper.LOGTAG, (String)"Error building JSON favicon arguments.", (Throwable)jSONException);
                    }
                }
                eventCallback.sendSuccess((Object)jSONObject.toString());
            }
        }.execute();
    }

    private void handleRemoveFromList(final String string2) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ReadingListHelper.this.readingListAccessor.removeReadingListItemWithURL(ReadingListHelper.this.context.getContentResolver(), string2);
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Reader:Removed", string2));
                ReadingListHelper.this.showToast(R.string.page_removed, 0);
            }
        });
    }

    private void handleReadingListStatusRequest(final EventCallback eventCallback, final String string2) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                int n = ReadingListHelper.this.readingListAccessor.isReadingListItem(ReadingListHelper.this.context.getContentResolver(), string2) ? 1 : 0;
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("url", (Object)string2);
                    jSONObject.put("inReadingList", n);
                }
                catch (JSONException jSONException) {
                    Log.e((String)ReadingListHelper.LOGTAG, (String)"JSON error - failed to return inReadingList status", (Throwable)jSONException);
                }
                eventCallback.sendSuccess((Object)jSONObject.toString());
            }
        });
    }

    private void showToast(final int n, final int n2) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)ReadingListHelper.this.context, (int)n, (int)n2).show();
            }
        });
    }

    private void fetchContent() {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block7: {
                    Cursor cursor = ReadingListHelper.this.readingListAccessor.getReadingListUnfetched(ReadingListHelper.this.context.getContentResolver());
                    block5: while (true) {
                        while (cursor.moveToNext()) {
                            JSONObject jSONObject = new JSONObject();
                            try {
                                jSONObject.put("id", cursor.getInt(cursor.getColumnIndexOrThrow("_id")));
                                jSONObject.put("url", (Object)cursor.getString(cursor.getColumnIndexOrThrow("url")));
                                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Reader:FetchContent", jSONObject.toString()));
                                continue block5;
                            }
                            catch (JSONException jSONException) {
                                Log.e((String)ReadingListHelper.LOGTAG, (String)"Failed to fetch reading list content for item");
                            }
                        }
                        break block7;
                        {
                            continue block5;
                            break;
                        }
                        break;
                    }
                    finally {
                        cursor.close();
                    }
                }
            }
        });
    }
}

