/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport;

import android.content.ContentValues;
import android.content.Context;
import android.content.ContextWrapper;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.SparseArray;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.json.JSONObject;
import org.mozilla.gecko.background.common.DateUtils;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.Environment;
import org.mozilla.gecko.background.healthreport.EnvironmentV1;
import org.mozilla.gecko.background.healthreport.HealthReportStorage;

public class HealthReportDatabaseStorage
implements HealthReportStorage {
    private static final String WHERE_DATE_AND_ENV_AND_FIELD = "date = ? AND env = ? AND field = ?";
    public static final String[] COLUMNS_HASH = new String[]{"hash"};
    public static final String[] COLUMNS_DATE_ENV_FIELD_VALUE = new String[]{"date", "env", "field", "value"};
    public static final String[] COLUMNS_DATE_ENVSTR_M_MV_F_VALUE = new String[]{"date", "environment", "measurement_name", "measurement_version", "field_name", "field_flags", "value"};
    private static final String[] COLUMNS_ENVIRONMENT_DETAILS = new String[]{"id", "version", "hash", "profileCreation", "cpuCount", "memoryMB", "isBlocklistEnabled", "isTelemetryEnabled", "extensionCount", "pluginCount", "themeCount", "architecture", "sysName", "sysVersion", "vendor", "appName", "appID", "appVersion", "appBuildID", "platformVersion", "platformBuildID", "os", "xpcomabi", "updateChannel", "distribution", "osLocale", "appLocale", "acceptLangSet", "addonsBody", "hasHardwareKeyboard", "uiMode", "uiType", "screenLayout", "screenXInMM", "screenYInMM"};
    public static final String[] COLUMNS_MEASUREMENT_DETAILS = new String[]{"id", "name", "version"};
    public static final String[] COLUMNS_MEASUREMENT_AND_FIELD_DETAILS = new String[]{"measurement_name", "measurement_id", "measurement_version", "field_name", "field_id", "field_flags"};
    private static final String[] COLUMNS_VALUE = new String[]{"value"};
    private static final String[] COLUMNS_ID = new String[]{"id"};
    private static final String EVENTS_TEXTUAL = "events_textual";
    private static final String EVENTS_INTEGER = "events_integer";
    protected static final String DB_NAME = "health.db";
    private static final String LOG_TAG = "HealthReportStorage";
    private final Executor executor = Executors.newSingleThreadExecutor();
    protected final HealthReportSQLiteOpenHelper helper;
    protected final ConcurrentHashMap<String, Integer> envs = new ConcurrentHashMap();
    private final HashMap<String, HealthReportStorage.Field> fields = new HashMap();
    private boolean fieldsCacheUpdated = false;
    private final HashMap<String, Integer> measurementVersions = new HashMap();

    @Override
    public void enqueueOperation(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public HealthReportDatabaseStorage(Context context, File file) {
        this.helper = new HealthReportSQLiteOpenHelper(context, file, DB_NAME);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Logger.setThreadLogTag("GeckoHealth");
                Logger.debug(HealthReportDatabaseStorage.LOG_TAG, "Creating HealthReportDatabaseStorage.");
            }
        });
    }

    @Override
    public void close() {
        this.helper.close();
        this.fields.clear();
        this.envs.clear();
        this.measurementVersions.clear();
    }

    @Override
    public DatabaseEnvironment getEnvironment() {
        return new DatabaseEnvironment(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseArray<Environment> getEnvironmentRecordsByID() {
        SQLiteDatabase sQLiteDatabase = this.helper.getReadableDatabase();
        try (Cursor cursor = sQLiteDatabase.query("environments_with_addons", COLUMNS_ENVIRONMENT_DETAILS, null, null, null, null, null);){
            SparseArray sparseArray = new SparseArray();
            if (!cursor.moveToFirst()) {
                SparseArray sparseArray2 = sparseArray;
                return sparseArray2;
            }
            DatabaseEnvironment databaseEnvironment = this.getEnvironment();
            while (databaseEnvironment.init(cursor)) {
                sparseArray.put(databaseEnvironment.id, (Object)databaseEnvironment);
                databaseEnvironment = this.getEnvironment();
            }
            sparseArray.put(databaseEnvironment.id, (Object)databaseEnvironment);
            SparseArray sparseArray3 = sparseArray;
            return sparseArray3;
        }
    }

    @Override
    public Cursor getEnvironmentRecordForID(int n) {
        SQLiteDatabase sQLiteDatabase = this.helper.getReadableDatabase();
        return sQLiteDatabase.query("environments_with_addons", COLUMNS_ENVIRONMENT_DETAILS, "id = " + n, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseArray<String> getEnvironmentHashesByID() {
        SQLiteDatabase sQLiteDatabase = this.helper.getReadableDatabase();
        try (Cursor cursor = sQLiteDatabase.query("environments", new String[]{"id", "hash"}, null, null, null, null, null);){
            SparseArray sparseArray = new SparseArray();
            if (!cursor.moveToFirst()) {
                SparseArray sparseArray2 = sparseArray;
                return sparseArray2;
            }
            while (!cursor.isAfterLast()) {
                sparseArray.put(cursor.getInt(0), (Object)cursor.getString(1));
                cursor.moveToNext();
            }
            SparseArray sparseArray3 = sparseArray;
            return sparseArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateFieldsCache() {
        HashMap<String, HealthReportStorage.Field> hashMap = this.fields;
        synchronized (hashMap) {
            this.fieldsCacheUpdated = false;
        }
    }

    private String getFieldKey(String string2, int n, String string3) {
        return n + "." + string2 + "/" + string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HealthReportStorage.Field getField(String string2, int n, String string3) {
        String string4 = this.getFieldKey(string2, n, string3);
        HashMap<String, HealthReportStorage.Field> hashMap = this.fields;
        synchronized (hashMap) {
            if (this.fields.containsKey(string4)) {
                return this.fields.get(string4);
            }
            DatabaseField databaseField = new DatabaseField(string2, n, string3);
            this.fields.put(string4, databaseField);
            return databaseField;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateFieldCache() {
        HashMap<String, HealthReportStorage.Field> hashMap = this.fields;
        synchronized (hashMap) {
            if (this.fieldsCacheUpdated) {
                return;
            }
            this.fields.clear();
            try (Cursor cursor = this.getFieldVersions();){
                if (!cursor.moveToFirst()) {
                    return;
                }
                do {
                    String string2 = cursor.getString(0);
                    int n = cursor.getInt(2);
                    String string3 = cursor.getString(3);
                    int n2 = cursor.getInt(4);
                    int n3 = cursor.getInt(5);
                    String string4 = this.getFieldKey(string2, n, string3);
                    DatabaseField databaseField = new DatabaseField(string2, n, string3, n2, n3);
                    this.fields.put(string4, databaseField);
                } while (cursor.moveToNext());
                this.fieldsCacheUpdated = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseArray<HealthReportStorage.Field> getFieldsByID() {
        SparseArray sparseArray = new SparseArray();
        HashMap<String, HealthReportStorage.Field> hashMap = this.fields;
        synchronized (hashMap) {
            this.populateFieldCache();
            Collection<HealthReportStorage.Field> collection = this.fields.values();
            for (HealthReportStorage.Field field : collection) {
                sparseArray.put(field.getID(), (Object)field);
            }
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateMeasurementVersionsCache(SQLiteDatabase sQLiteDatabase) {
        HashMap<String, Integer> hashMap = HealthReportDatabaseStorage.getIntegers(sQLiteDatabase, "current_measurements", "name", "version");
        if (hashMap == null) {
            this.measurementVersions.clear();
            return;
        }
        HashMap<String, Integer> hashMap2 = this.measurementVersions;
        synchronized (hashMap2) {
            this.measurementVersions.clear();
            this.measurementVersions.putAll(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMeasurementVersion(String string2) {
        HashMap<String, Integer> hashMap = this.measurementVersions;
        synchronized (hashMap) {
            if (this.measurementVersions.containsKey(string2)) {
                return this.measurementVersions.get(string2);
            }
            int n = this.integerQuery("measurements", "version", "name = ?", new String[]{string2}, 0);
            this.measurementVersions.put(string2, n);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMeasurementVersionUpdated(String string2, int n) {
        Logger.info(LOG_TAG, "Measurement " + string2 + " now at " + n);
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put("name", string2);
        contentValues.put("version", Integer.valueOf(n));
        HashMap<String, Integer> hashMap = this.measurementVersions;
        synchronized (hashMap) {
            this.measurementVersions.put(string2, n);
        }
        sQLiteDatabase.insertWithOnConflict("measurements", null, contentValues, 4);
    }

    @Override
    public void ensureMeasurementInitialized(String string2, int n, HealthReportStorage.MeasurementFields measurementFields) {
        int n2 = this.getMeasurementVersion(string2);
        Logger.info(LOG_TAG, "Initializing measurement " + string2 + " to " + n + " (current " + n2 + ")");
        if (n2 == n) {
            Logger.info(LOG_TAG, "Measurement " + string2 + " already at v" + n);
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        if (!sQLiteDatabase.inTransaction()) {
            Logger.warn(LOG_TAG, "ensureMeasurementInitialized should be called within a transaction.");
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("name", string2);
        contentValues.put("version", Integer.valueOf(n));
        int n3 = (int)sQLiteDatabase.insert("measurements", null, contentValues);
        ContentValues contentValues2 = new ContentValues();
        contentValues2.put("measurement", Integer.valueOf(n3));
        for (HealthReportStorage.MeasurementFields.FieldSpec fieldSpec : measurementFields.getFields()) {
            contentValues2.put("name", fieldSpec.name);
            contentValues2.put("flags", Integer.valueOf(fieldSpec.type));
            Logger.debug(LOG_TAG, "M: " + n3 + " F: " + fieldSpec.name + " (" + fieldSpec.type + ")");
            sQLiteDatabase.insert("fields", null, contentValues2);
        }
        this.notifyMeasurementVersionUpdated(string2, n);
        this.invalidateFieldsCache();
    }

    @Override
    public Cursor getFieldVersions() {
        SQLiteDatabase sQLiteDatabase = this.helper.getReadableDatabase();
        return sQLiteDatabase.query("named_fields", COLUMNS_MEASUREMENT_AND_FIELD_DETAILS, null, null, null, null, "measurement_name, measurement_version, field_name");
    }

    @Override
    public Cursor getFieldVersions(String string2, int n) {
        SQLiteDatabase sQLiteDatabase = this.helper.getReadableDatabase();
        return sQLiteDatabase.query("named_fields", COLUMNS_MEASUREMENT_AND_FIELD_DETAILS, "measurement_name = ? AND measurement_version = ?", new String[]{string2, Integer.toString(n)}, null, null, "field_name");
    }

    @Override
    public Cursor getMeasurementVersions() {
        SQLiteDatabase sQLiteDatabase = this.helper.getReadableDatabase();
        return sQLiteDatabase.query("measurements", COLUMNS_MEASUREMENT_DETAILS, null, null, null, null, "name, version");
    }

    public void beginInitialization() {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        this.populateMeasurementVersionsCache(sQLiteDatabase);
    }

    public void finishInitialization() {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.setTransactionSuccessful();
        sQLiteDatabase.endTransaction();
    }

    public void abortInitialization() {
        this.helper.getWritableDatabase().endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getIntFromQuery(String string2, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.helper.getReadableDatabase();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, stringArray);){
            if (!cursor.moveToFirst()) {
                throw new IllegalStateException("Cursor is empty.");
            }
            int n = cursor.getInt(0);
            return n;
        }
    }

    @Override
    public int getDay(long l) {
        return DateUtils.getDay(l);
    }

    @Override
    public int getDay() {
        return this.getDay(System.currentTimeMillis());
    }

    private void recordDailyLast(int n, int n2, int n3, Object object, String string2) {
        if (n == -1) {
            Logger.warn(LOG_TAG, "Refusing to record with environment = -1.");
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        String string3 = Integer.toString(n);
        String string4 = Integer.toString(n3, 10);
        String string5 = Integer.toString(n2, 10);
        ContentValues contentValues = new ContentValues();
        HealthReportDatabaseStorage.putValue(contentValues, object);
        int n4 = sQLiteDatabase.update(string2, contentValues, WHERE_DATE_AND_ENV_AND_FIELD, new String[]{string5, string3, string4});
        if (0 == n4) {
            contentValues.put("env", Integer.valueOf(n));
            contentValues.put("field", Integer.valueOf(n3));
            contentValues.put("date", Integer.valueOf(n2));
            try {
                sQLiteDatabase.insertOrThrow(string2, null, contentValues);
            }
            catch (SQLiteConstraintException sQLiteConstraintException) {
                throw new IllegalStateException("Event did not reference existing an environment or field.", sQLiteConstraintException);
            }
        }
    }

    @Override
    public void recordDailyLast(int n, int n2, int n3, JSONObject jSONObject) {
        this.recordDailyLast(n, n2, n3, jSONObject == null ? "null" : jSONObject.toString(), EVENTS_TEXTUAL);
    }

    @Override
    public void recordDailyLast(int n, int n2, int n3, String string2) {
        this.recordDailyLast(n, n2, n3, string2, EVENTS_TEXTUAL);
    }

    @Override
    public void recordDailyLast(int n, int n2, int n3, int n4) {
        this.recordDailyLast(n, n2, n3, n4, EVENTS_INTEGER);
    }

    private void recordDailyDiscrete(int n, int n2, int n3, Object object, String string2) {
        if (n == -1) {
            Logger.warn(LOG_TAG, "Refusing to record with environment = -1.");
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("env", Integer.valueOf(n));
        contentValues.put("field", Integer.valueOf(n3));
        contentValues.put("date", Integer.valueOf(n2));
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        HealthReportDatabaseStorage.putValue(contentValues, object);
        long l = sQLiteDatabase.insert(string2, null, contentValues);
        if (l == -1L) {
            Logger.error(LOG_TAG, "Unable to record daily discrete event. Ignoring.");
        }
    }

    @Override
    public void recordDailyDiscrete(int n, int n2, int n3, JSONObject jSONObject) {
        this.recordDailyDiscrete(n, n2, n3, jSONObject == null ? "null" : jSONObject.toString(), EVENTS_TEXTUAL);
    }

    @Override
    public void recordDailyDiscrete(int n, int n2, int n3, String string2) {
        this.recordDailyDiscrete(n, n2, n3, string2, EVENTS_TEXTUAL);
    }

    @Override
    public void recordDailyDiscrete(int n, int n2, int n3, int n4) {
        this.recordDailyDiscrete(n, n2, n3, n4, EVENTS_INTEGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDailyCount(int n, int n2, int n3, int n4) {
        if (n == -1) {
            Logger.warn(LOG_TAG, "Refusing to record with environment = -1.");
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        String string2 = Integer.toString(n);
        String string3 = Integer.toString(n3, 10);
        String string4 = Integer.toString(n2, 10);
        Object[] objectArray = new String[]{string4, string2, string3};
        boolean bl = false;
        try (Cursor cursor = sQLiteDatabase.query(EVENTS_INTEGER, COLUMNS_VALUE, WHERE_DATE_AND_ENV_AND_FIELD, (String[])objectArray, null, null, null, "1");){
            bl = cursor.moveToFirst();
        }
        if (bl) {
            sQLiteDatabase.execSQL("UPDATE events_integer SET value = value + " + n4 + " WHERE " + WHERE_DATE_AND_ENV_AND_FIELD, objectArray);
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("env", Integer.valueOf(n));
            contentValues.put("value", Integer.valueOf(n4));
            contentValues.put("field", Integer.valueOf(n3));
            contentValues.put("date", Integer.valueOf(n2));
            try {
                sQLiteDatabase.insertOrThrow(EVENTS_INTEGER, null, contentValues);
            }
            catch (SQLiteConstraintException sQLiteConstraintException) {
                throw new IllegalStateException("Event did not reference existing an environment or field.", sQLiteConstraintException);
            }
        }
    }

    @Override
    public void incrementDailyCount(int n, int n2, int n3) {
        this.incrementDailyCount(n, n2, n3, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEventSince(long l) {
        String string2;
        int n = this.getDay(l);
        SQLiteDatabase sQLiteDatabase = this.helper.getReadableDatabase();
        Cursor cursor = sQLiteDatabase.query("events", COLUMNS_DATE_ENV_FIELD_VALUE, "date >= ?", new String[]{string2 = Integer.toString(n, 10)}, null, null, null, "1");
        if (cursor == null) {
            return true;
        }
        try {
            boolean bl = cursor.getCount() > 0;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public Cursor getRawEventsSince(long l) {
        int n = this.getDay(l);
        SQLiteDatabase sQLiteDatabase = this.helper.getReadableDatabase();
        String string2 = Integer.toString(n, 10);
        return sQLiteDatabase.query("events", COLUMNS_DATE_ENV_FIELD_VALUE, "date >= ?", new String[]{string2}, null, null, "date, env, field");
    }

    @Override
    public Cursor getEventsSince(long l) {
        int n = this.getDay(l);
        SQLiteDatabase sQLiteDatabase = this.helper.getReadableDatabase();
        String string2 = Integer.toString(n, 10);
        return sQLiteDatabase.query("named_events", COLUMNS_DATE_ENVSTR_M_MV_F_VALUE, "date >= ?", new String[]{string2}, null, null, "date, environment, measurement_name, measurement_version, field_name");
    }

    @Override
    public int getEventCount() {
        return this.getRowCount("events");
    }

    @Override
    public int getEnvironmentCount() {
        return this.getRowCount("environments");
    }

    private int getRowCount(String string2) {
        return this.getIntFromQuery("SELECT COUNT(*) from " + string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteDataBefore(long l, int n) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        int n2 = 0;
        try {
            n2 += this.deleteEnvAndEventsBefore(sQLiteDatabase, l, n);
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return n2 += this.deleteOrphanedAddons(sQLiteDatabase);
    }

    protected int deleteEnvAndEventsBefore(long l, int n) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        return this.deleteEnvAndEventsBefore(sQLiteDatabase, l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deleteEnvAndEventsBefore(SQLiteDatabase sQLiteDatabase, long l, int n) {
        String string2 = "(SELECT COUNT(*) FROM events WHERE date >= ?     AND events.env = environments.id) = 0 AND id IN (SELECT DISTINCT env FROM events WHERE date < ?)";
        int n2 = this.getDay(l);
        String string3 = Integer.toString(n2, 10);
        String[] stringArray = new String[]{string3, string3};
        int n3 = 0;
        sQLiteDatabase.beginTransaction();
        try {
            n3 += sQLiteDatabase.delete("environments", string2, stringArray);
            this.deleteEventsBefore(sQLiteDatabase, string3);
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return n3 += this.deleteOrphanedEnv(sQLiteDatabase, n);
    }

    protected int deleteOrphanedEnv(int n) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        return this.deleteOrphanedEnv(sQLiteDatabase, n);
    }

    protected int deleteOrphanedEnv(SQLiteDatabase sQLiteDatabase, int n) {
        String[] stringArray = new String[]{Integer.toString(n)};
        return sQLiteDatabase.delete("environments", "id != ? AND id NOT IN (SELECT env FROM events)", stringArray);
    }

    protected int deleteEventsBefore(String string2) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        return this.deleteEventsBefore(sQLiteDatabase, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deleteEventsBefore(SQLiteDatabase sQLiteDatabase, String string2) {
        String[] stringArray = new String[]{string2};
        int n = 0;
        sQLiteDatabase.beginTransaction();
        try {
            n += sQLiteDatabase.delete(EVENTS_INTEGER, "date < ?", stringArray);
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return n += sQLiteDatabase.delete(EVENTS_TEXTUAL, "date < ?", stringArray);
    }

    protected int deleteOrphanedAddons() {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        return this.deleteOrphanedAddons(sQLiteDatabase);
    }

    protected int deleteOrphanedAddons(SQLiteDatabase sQLiteDatabase) {
        return sQLiteDatabase.delete("addons", "id NOT IN (SELECT addonsID FROM environments)", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, Integer> getIntegers(SQLiteDatabase sQLiteDatabase, String string2, String string3, String string4) {
        try (Cursor cursor = sQLiteDatabase.query(string2, new String[]{string3, string4}, null, null, null, null, null);){
            if (!cursor.moveToFirst()) {
                HashMap<String, Integer> hashMap = null;
                return hashMap;
            }
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            while (!cursor.isAfterLast()) {
                hashMap.put(cursor.getString(0), cursor.getInt(1));
                cursor.moveToNext();
            }
            HashMap<String, Integer> hashMap2 = hashMap;
            return hashMap2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int integerQuery(String string2, String string3, String string4, String[] stringArray, int n) {
        SQLiteDatabase sQLiteDatabase = this.helper.getReadableDatabase();
        try (Cursor cursor = sQLiteDatabase.query(string2, new String[]{string3}, string4, stringArray, null, null, string3 + " DESC", "1");){
            if (!cursor.moveToFirst()) {
                int n2 = n;
                return n2;
            }
            int n3 = cursor.getInt(0);
            return n3;
        }
    }

    private static final void putValue(ContentValues contentValues, Object object) {
        if (object instanceof String) {
            contentValues.put("value", (String)object);
        } else {
            contentValues.put("value", (Integer)object);
        }
    }

    @Override
    public void deleteEverything() {
        this.helper.deleteEverything();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEnvironments() {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            sQLiteDatabase.delete("environments", null, null);
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMeasurements() {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            sQLiteDatabase.delete("measurements", null, null);
            this.invalidateFieldsCache();
            this.populateMeasurementVersionsCache(sQLiteDatabase);
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pruneEnvironments(int n) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            sQLiteDatabase.delete("environments", "id in (SELECT env        FROM events        GROUP BY env        ORDER BY MAX(date), env        LIMIT " + n + ")", null);
            sQLiteDatabase.setTransactionSuccessful();
            this.envs.clear();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pruneEvents(int n) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        long l = -1L;
        try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT MAX(date) FROM (SELECT date       FROM events       ORDER BY date       LIMIT " + n + ")", null);){
            if (!cursor.moveToFirst()) {
                Logger.debug(LOG_TAG, "No max date found in events: table is likely empty. Not pruning events.");
                return;
            }
            l = cursor.getLong(0);
        }
        String string2 = "date < " + l;
        sQLiteDatabase.beginTransaction();
        try {
            sQLiteDatabase.delete(EVENTS_INTEGER, string2, null);
            sQLiteDatabase.delete(EVENTS_TEXTUAL, string2, null);
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    public void vacuum() {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.execSQL("vacuum");
    }

    public void disableAutoVacuuming() {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.execSQL("PRAGMA auto_vacuum=0");
    }

    public static class DatabaseEnvironment
    extends Environment {
        protected final HealthReportDatabaseStorage storage;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public int register() {
            String string2 = this.getHash();
            if (this.storage.envs.containsKey(string2)) {
                this.id = this.storage.envs.get(string2);
                return this.id;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("version", Integer.valueOf(this.version));
            contentValues.put("hash", string2);
            contentValues.put("profileCreation", Integer.valueOf(this.profileCreation));
            contentValues.put("cpuCount", Integer.valueOf(this.cpuCount));
            contentValues.put("memoryMB", Integer.valueOf(this.memoryMB));
            contentValues.put("isBlocklistEnabled", Integer.valueOf(this.isBlocklistEnabled));
            contentValues.put("isTelemetryEnabled", Integer.valueOf(this.isTelemetryEnabled));
            contentValues.put("extensionCount", Integer.valueOf(this.extensionCount));
            contentValues.put("pluginCount", Integer.valueOf(this.pluginCount));
            contentValues.put("themeCount", Integer.valueOf(this.themeCount));
            contentValues.put("architecture", this.architecture);
            contentValues.put("sysName", this.sysName);
            contentValues.put("sysVersion", this.sysVersion);
            contentValues.put("vendor", this.vendor);
            contentValues.put("appName", this.appName);
            contentValues.put("appID", this.appID);
            contentValues.put("appVersion", this.appVersion);
            contentValues.put("appBuildID", this.appBuildID);
            contentValues.put("platformVersion", this.platformVersion);
            contentValues.put("platformBuildID", this.platformBuildID);
            contentValues.put("os", this.os);
            contentValues.put("xpcomabi", this.xpcomabi);
            contentValues.put("updateChannel", this.updateChannel);
            contentValues.put("distribution", this.distribution);
            contentValues.put("osLocale", this.osLocale);
            contentValues.put("appLocale", this.appLocale);
            contentValues.put("acceptLangSet", Integer.valueOf(this.acceptLangSet));
            contentValues.put("hasHardwareKeyboard", Integer.valueOf(this.hasHardwareKeyboard ? 1 : 0));
            contentValues.put("uiMode", Integer.valueOf(this.uiMode));
            contentValues.put("uiType", this.uiType.toString());
            contentValues.put("screenLayout", Integer.valueOf(this.screenLayout));
            contentValues.put("screenXInMM", Integer.valueOf(this.screenXInMM));
            contentValues.put("screenYInMM", Integer.valueOf(this.screenYInMM));
            SQLiteDatabase sQLiteDatabase = this.storage.helper.getWritableDatabase();
            boolean bl = !sQLiteDatabase.inTransaction();
            String string3 = this.getNormalizedAddonsJSON();
            if (bl) {
                sQLiteDatabase.beginTransaction();
            }
            try {
                int n = DatabaseEnvironment.ensureAddons(sQLiteDatabase, string3);
                contentValues.put("addonsID", Integer.valueOf(n));
                try {
                    int n2 = (int)sQLiteDatabase.insertOrThrow("environments", null, contentValues);
                    Logger.debug(HealthReportDatabaseStorage.LOG_TAG, "Inserted ID: " + n2 + " for hash " + string2);
                    if (n2 == -1) {
                        throw new SQLException("Insert returned -1!");
                    }
                    this.id = n2;
                    this.storage.envs.put(string2, this.id);
                    if (bl) {
                        sQLiteDatabase.setTransactionSuccessful();
                    }
                    int n3 = n2;
                    return n3;
                }
                catch (SQLException sQLException) {
                    int n4;
                    Cursor cursor;
                    block16: {
                        cursor = sQLiteDatabase.query("environments", COLUMNS_ID, "hash = ?", new String[]{string2}, null, null, null);
                        if (!cursor.moveToFirst()) {
                            throw sQLException;
                        }
                        this.id = (int)cursor.getLong(0);
                        Logger.debug(HealthReportDatabaseStorage.LOG_TAG, "Found " + this.id + " for hash " + string2);
                        this.storage.envs.put(string2, this.id);
                        if (bl) {
                            sQLiteDatabase.setTransactionSuccessful();
                        }
                        n4 = this.id;
                        cursor.close();
                        if (!bl) break block16;
                        sQLiteDatabase.endTransaction();
                    }
                    return n4;
                    {
                        catch (Throwable throwable) {
                            cursor.close();
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                if (bl) {
                    sQLiteDatabase.endTransaction();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static int ensureAddons(SQLiteDatabase sQLiteDatabase, String string2) {
            try (Cursor cursor = sQLiteDatabase.query("addons", COLUMNS_ID, "body = ?", new String[]{string2 == null ? "null" : string2}, null, null, null);){
                if (cursor.moveToFirst()) {
                    int n = cursor.getInt(0);
                    return n;
                }
                ContentValues contentValues = new ContentValues();
                contentValues.put("body", string2);
                int n = (int)sQLiteDatabase.insert("addons", null, contentValues);
                return n;
            }
        }

        public void init(ContentValues contentValues) {
            this.version = contentValues.containsKey("version") ? contentValues.getAsInteger("version") : 3;
            Logger.debug(HealthReportDatabaseStorage.LOG_TAG, "Initializing environment with version " + this.version);
            this.profileCreation = contentValues.getAsInteger("profileCreation");
            this.cpuCount = contentValues.getAsInteger("cpuCount");
            this.memoryMB = contentValues.getAsInteger("memoryMB");
            this.isBlocklistEnabled = contentValues.getAsInteger("isBlocklistEnabled");
            this.isTelemetryEnabled = contentValues.getAsInteger("isTelemetryEnabled");
            this.extensionCount = contentValues.getAsInteger("extensionCount");
            this.pluginCount = contentValues.getAsInteger("pluginCount");
            this.themeCount = contentValues.getAsInteger("themeCount");
            this.architecture = contentValues.getAsString("architecture");
            this.sysName = contentValues.getAsString("sysName");
            this.sysVersion = contentValues.getAsString("sysVersion");
            this.vendor = contentValues.getAsString("vendor");
            this.appName = contentValues.getAsString("appName");
            this.appID = contentValues.getAsString("appID");
            this.appVersion = contentValues.getAsString("appVersion");
            this.appBuildID = contentValues.getAsString("appBuildID");
            this.platformVersion = contentValues.getAsString("platformVersion");
            this.platformBuildID = contentValues.getAsString("platformBuildID");
            this.os = contentValues.getAsString("os");
            this.xpcomabi = contentValues.getAsString("xpcomabi");
            this.updateChannel = contentValues.getAsString("updateChannel");
            this.distribution = contentValues.getAsString("distribution");
            this.osLocale = contentValues.getAsString("osLocale");
            this.appLocale = contentValues.getAsString("appLocale");
            this.acceptLangSet = contentValues.getAsInteger("acceptLangSet");
            try {
                this.setJSONForAddons(contentValues.getAsString("addonsBody"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.version >= 3) {
                this.hasHardwareKeyboard = contentValues.getAsInteger("hasHardwareKeyboard") != 0;
                this.uiMode = contentValues.getAsInteger("uiMode");
                this.uiType = Environment.UIType.fromLabel(contentValues.getAsString("uiType"));
                this.screenLayout = contentValues.getAsInteger("screenLayout");
                this.screenXInMM = contentValues.getAsInteger("screenXInMM");
                this.screenYInMM = contentValues.getAsInteger("screenYInMM");
            }
            this.hash = null;
            this.id = -1;
        }

        public boolean init(Cursor cursor) {
            int n = 0;
            this.id = cursor.getInt(n++);
            this.version = cursor.getInt(n++);
            this.hash = cursor.getString(n++);
            this.profileCreation = cursor.getInt(n++);
            this.cpuCount = cursor.getInt(n++);
            this.memoryMB = cursor.getInt(n++);
            this.isBlocklistEnabled = cursor.getInt(n++);
            this.isTelemetryEnabled = cursor.getInt(n++);
            this.extensionCount = cursor.getInt(n++);
            this.pluginCount = cursor.getInt(n++);
            this.themeCount = cursor.getInt(n++);
            this.architecture = cursor.getString(n++);
            this.sysName = cursor.getString(n++);
            this.sysVersion = cursor.getString(n++);
            this.vendor = cursor.getString(n++);
            this.appName = cursor.getString(n++);
            this.appID = cursor.getString(n++);
            this.appVersion = cursor.getString(n++);
            this.appBuildID = cursor.getString(n++);
            this.platformVersion = cursor.getString(n++);
            this.platformBuildID = cursor.getString(n++);
            this.os = cursor.getString(n++);
            this.xpcomabi = cursor.getString(n++);
            this.updateChannel = cursor.getString(n++);
            this.distribution = cursor.getString(n++);
            this.osLocale = cursor.getString(n++);
            this.appLocale = cursor.getString(n++);
            this.acceptLangSet = cursor.getInt(n++);
            try {
                this.setJSONForAddons(cursor.getBlob(n++));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.version >= 3) {
                this.hasHardwareKeyboard = cursor.getInt(n++) != 0;
                this.uiMode = cursor.getInt(n++);
                this.uiType = Environment.UIType.fromLabel(cursor.getString(n++));
                this.screenLayout = cursor.getInt(n++);
                this.screenXInMM = cursor.getInt(n++);
                this.screenYInMM = cursor.getInt(n++);
            }
            return cursor.moveToNext();
        }

        public DatabaseEnvironment(HealthReportDatabaseStorage healthReportDatabaseStorage, Class<? extends EnvironmentV1.EnvironmentAppender> clazz) {
            super(clazz);
            this.storage = healthReportDatabaseStorage;
        }

        public DatabaseEnvironment(HealthReportDatabaseStorage healthReportDatabaseStorage) {
            this.storage = healthReportDatabaseStorage;
        }
    }

    public class DatabaseField
    extends HealthReportStorage.Field {
        public DatabaseField(String string2, int n, String string3) {
            this(string2, n, string3, -1, -1);
        }

        public DatabaseField(String string2, int n, String string3, int n2) {
            this(string2, n, string3, -1, n2);
        }

        public DatabaseField(String string2, int n, String string3, int n2, int n3) {
            super(string2, n, string3, n3);
            this.fieldID = n2;
        }

        private void loadFlags() {
            if (this.flags == -1) {
                if (this.fieldID == -1) {
                    this.getID();
                }
                this.flags = HealthReportDatabaseStorage.this.integerQuery("fields", "flags", "id = ?", new String[]{Integer.toString(this.fieldID, 10)}, -1);
            }
        }

        @Override
        public synchronized boolean isIntegerField() {
            this.loadFlags();
            return super.isIntegerField();
        }

        @Override
        public synchronized boolean isStringField() {
            this.loadFlags();
            return super.isStringField();
        }

        @Override
        public synchronized boolean isDiscreteField() {
            this.loadFlags();
            return super.isDiscreteField();
        }

        @Override
        public synchronized int getID() throws IllegalStateException {
            if (this.fieldID == -1) {
                this.fieldID = HealthReportDatabaseStorage.this.integerQuery("named_fields", "field_id", "measurement_name = ? AND measurement_version = ? AND field_name = ?", new String[]{this.measurementName, this.measurementVersion, this.fieldName}, -1);
                if (this.fieldID == -1) {
                    throw new IllegalStateException("No field with name " + this.fieldName + " (" + this.measurementName + ", " + this.measurementVersion + ")");
                }
            }
            return this.fieldID;
        }
    }

    public static class HealthReportSQLiteOpenHelper
    extends SQLiteOpenHelper {
        public static final int CURRENT_VERSION = 7;
        public static final String LOG_TAG = "HealthReportSQL";

        public static String getAbsolutePath(File file, String string2) {
            return file.getAbsolutePath() + File.separator + string2;
        }

        public HealthReportSQLiteOpenHelper(Context context, File file, String string2) {
            this(context, file, string2, 7);
        }

        public HealthReportSQLiteOpenHelper(Context context, File file, String string2, int n) {
            super(context, HealthReportSQLiteOpenHelper.getAbsolutePath(file, string2), null, n);
            Logger.pii(LOG_TAG, "Opening: " + HealthReportSQLiteOpenHelper.getAbsolutePath(file, string2));
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE addons (id INTEGER PRIMARY KEY AUTOINCREMENT,                      body TEXT,                      UNIQUE (body) )");
            sQLiteDatabase.execSQL("CREATE TABLE environments (id INTEGER PRIMARY KEY AUTOINCREMENT,                            version INTEGER,                            hash TEXT,                            profileCreation INTEGER,                            cpuCount        INTEGER,                            memoryMB        INTEGER,                            isBlocklistEnabled INTEGER,                            isTelemetryEnabled INTEGER,                            extensionCount     INTEGER,                            pluginCount        INTEGER,                            themeCount         INTEGER,                            architecture    TEXT,                            sysName         TEXT,                            sysVersion      TEXT,                            vendor          TEXT,                            appName         TEXT,                            appID           TEXT,                            appVersion      TEXT,                            appBuildID      TEXT,                            platformVersion TEXT,                            platformBuildID TEXT,                            os              TEXT,                            xpcomabi        TEXT,                            updateChannel   TEXT,                            distribution    TEXT,                            osLocale        TEXT,                            appLocale       TEXT,                            acceptLangSet   INTEGER,                            addonsID        INTEGER,                            hasHardwareKeyboard INTEGER,                            uiMode          INTEGER,                            uiType          TEXT,                            screenLayout    INTEGER,                            screenXInMM     INTEGER,                            screenYInMM     INTEGER,                            FOREIGN KEY (addonsID) REFERENCES addons(id) ON DELETE RESTRICT,                            UNIQUE (hash) )");
            sQLiteDatabase.execSQL("CREATE TABLE measurements (id INTEGER PRIMARY KEY AUTOINCREMENT,                            name TEXT,                            version INTEGER,                            UNIQUE (name, version) )");
            sQLiteDatabase.execSQL("CREATE TABLE fields (id INTEGER PRIMARY KEY AUTOINCREMENT,                      measurement INTEGER,                      name TEXT,                      flags INTEGER,                      FOREIGN KEY (measurement) REFERENCES measurements(id) ON DELETE CASCADE,                      UNIQUE (measurement, name))");
            sQLiteDatabase.execSQL("CREATE TABLE events_integer(                 date  INTEGER,                  env   INTEGER,                  field INTEGER,                  value INTEGER,                  FOREIGN KEY (field) REFERENCES fields(id) ON DELETE CASCADE,                  FOREIGN KEY (env) REFERENCES environments(id) ON DELETE CASCADE)");
            sQLiteDatabase.execSQL("CREATE TABLE events_textual(                 date  INTEGER,                  env   INTEGER,                  field INTEGER,                  value TEXT,                  FOREIGN KEY (field) REFERENCES fields(id) ON DELETE CASCADE,                  FOREIGN KEY (env) REFERENCES environments(id) ON DELETE CASCADE)");
            sQLiteDatabase.execSQL("CREATE INDEX idx_events_integer_date_env_field ON events_integer (date, env, field)");
            sQLiteDatabase.execSQL("CREATE INDEX idx_events_textual_date_env_field ON events_textual (date, env, field)");
            sQLiteDatabase.execSQL("CREATE VIEW events AS SELECT date, env, field, value FROM events_integer UNION ALL SELECT date, env, field, value FROM events_textual");
            sQLiteDatabase.execSQL("CREATE VIEW named_events AS SELECT date,        environments.hash AS environment,        measurements.name AS measurement_name,        measurements.version AS measurement_version,        fields.name AS field_name,        fields.flags AS field_flags,        value FROM events JOIN environments ON events.env = environments.id        JOIN fields ON events.field = fields.id        JOIN measurements ON fields.measurement = measurements.id");
            sQLiteDatabase.execSQL("CREATE VIEW named_fields AS SELECT measurements.name AS measurement_name,        measurements.id AS measurement_id,        measurements.version AS measurement_version,        fields.name AS field_name,        fields.id AS field_id,        fields.flags AS field_flags FROM fields JOIN measurements ON fields.measurement = measurements.id");
            sQLiteDatabase.execSQL("CREATE VIEW current_measurements AS SELECT name, MAX(version) AS version FROM measurements GROUP BY name");
            this.createAddonsEnvironmentsView(sQLiteDatabase);
        }

        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (!sQLiteDatabase.isReadOnly()) {
                sQLiteDatabase.execSQL("PRAGMA foreign_keys=ON;");
            }
        }

        private void createAddonsEnvironmentsView(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE VIEW environments_with_addons AS SELECT e.id AS id,        e.version AS version,        e.hash AS hash,        e.profileCreation AS profileCreation,        e.cpuCount AS cpuCount,        e.memoryMB AS memoryMB,        e.isBlocklistEnabled AS isBlocklistEnabled,        e.isTelemetryEnabled AS isTelemetryEnabled,        e.extensionCount AS extensionCount,        e.pluginCount AS pluginCount,        e.themeCount AS themeCount,        e.architecture AS architecture,        e.sysName AS sysName,        e.sysVersion AS sysVersion,        e.vendor AS vendor,        e.appName AS appName,        e.appID AS appID,        e.appVersion AS appVersion,        e.appBuildID AS appBuildID,        e.platformVersion AS platformVersion,        e.platformBuildID AS platformBuildID,        e.os AS os,        e.xpcomabi AS xpcomabi,        e.updateChannel AS updateChannel,        e.distribution AS distribution,        e.osLocale AS osLocale,        e.appLocale AS appLocale,        e.acceptLangSet AS acceptLangSet,        addons.body AS addonsBody,        e.hasHardwareKeyboard AS hasHardwareKeyboard,        e.uiMode AS uiMode,        e.uiType AS uiType,        e.screenLayout AS screenLayout,        e.screenXInMM AS screenXInMM,        e.screenYInMM AS screenYInMM FROM environments AS e, addons WHERE e.addonsID = addons.id");
        }

        private void upgradeDatabaseFrom2To3(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE addons (id INTEGER PRIMARY KEY AUTOINCREMENT,                      body TEXT,                      UNIQUE (body) )");
            sQLiteDatabase.execSQL("ALTER TABLE environments ADD COLUMN addonsID INTEGER REFERENCES addons(id) ON DELETE RESTRICT");
        }

        private void upgradeDatabaseFrom3To4(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("UPDATE OR IGNORE fields SET flags = 16642 WHERE measurement IN (SELECT id FROM measurements WHERE name = 'org.mozilla.searches.counts')");
        }

        private void upgradeDatabaseFrom4to5(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.delete("addons", "body IS NULL", null);
            sQLiteDatabase.delete("fields", "measurement NOT IN (SELECT id FROM measurements)", null);
            sQLiteDatabase.delete("environments", "addonsID NOT IN (SELECT id from addons)", null);
            sQLiteDatabase.delete(HealthReportDatabaseStorage.EVENTS_INTEGER, "env NOT IN (SELECT id FROM environments)", null);
            sQLiteDatabase.delete(HealthReportDatabaseStorage.EVENTS_TEXTUAL, "env NOT IN (SELECT id FROM environments)", null);
            sQLiteDatabase.delete(HealthReportDatabaseStorage.EVENTS_INTEGER, "field NOT IN (SELECT id FROM fields)", null);
            sQLiteDatabase.delete(HealthReportDatabaseStorage.EVENTS_TEXTUAL, "field NOT IN (SELECT id FROM fields)", null);
        }

        private void upgradeDatabaseFrom5to6(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS environments_with_addons");
            sQLiteDatabase.execSQL("ALTER TABLE environments ADD COLUMN version INTEGER DEFAULT 1");
            sQLiteDatabase.execSQL("ALTER TABLE environments ADD COLUMN distribution TEXT DEFAULT ''");
            sQLiteDatabase.execSQL("ALTER TABLE environments ADD COLUMN osLocale TEXT DEFAULT ''");
            sQLiteDatabase.execSQL("ALTER TABLE environments ADD COLUMN appLocale TEXT DEFAULT ''");
            sQLiteDatabase.execSQL("ALTER TABLE environments ADD COLUMN acceptLangSet INTEGER DEFAULT 0");
        }

        private void upgradeDatabaseFrom6to7(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("DROP VIEW IF EXISTS environments_with_addons");
            sQLiteDatabase.execSQL("ALTER TABLE environments ADD COLUMN hasHardwareKeyboard INTEGER DEFAULT 0");
            sQLiteDatabase.execSQL("ALTER TABLE environments ADD COLUMN uiMode INTEGER DEFAULT 0");
            sQLiteDatabase.execSQL("ALTER TABLE environments ADD COLUMN uiType TEXT DEFAULT ''");
            sQLiteDatabase.execSQL("ALTER TABLE environments ADD COLUMN screenLayout INTEGER DEFAULT 0");
            sQLiteDatabase.execSQL("ALTER TABLE environments ADD COLUMN screenXInMM INTEGER DEFAULT 0");
            sQLiteDatabase.execSQL("ALTER TABLE environments ADD COLUMN screenYInMM INTEGER DEFAULT 0");
            this.createAddonsEnvironmentsView(sQLiteDatabase);
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            if (n >= n2) {
                return;
            }
            Logger.info(LOG_TAG, "onUpgrade: from " + n + " to " + n2 + ".");
            try {
                switch (n) {
                    case 2: {
                        this.upgradeDatabaseFrom2To3(sQLiteDatabase);
                    }
                    case 3: {
                        this.upgradeDatabaseFrom3To4(sQLiteDatabase);
                    }
                    case 4: {
                        this.upgradeDatabaseFrom4to5(sQLiteDatabase);
                    }
                    case 5: {
                        this.upgradeDatabaseFrom5to6(sQLiteDatabase);
                    }
                    case 6: {
                        this.upgradeDatabaseFrom6to7(sQLiteDatabase);
                    }
                }
            }
            catch (Exception exception) {
                Logger.error(LOG_TAG, "Failure in onUpgrade.", exception);
                throw new RuntimeException(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteEverything() {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            Logger.info(LOG_TAG, "Deleting everything.");
            sQLiteDatabase.beginTransaction();
            try {
                sQLiteDatabase.delete("measurements", null, null);
                sQLiteDatabase.delete("environments", null, null);
                sQLiteDatabase.delete("addons", null, null);
                sQLiteDatabase.setTransactionSuccessful();
                Logger.info(LOG_TAG, "Deletion successful.");
            }
            finally {
                sQLiteDatabase.endTransaction();
            }
        }

        public static class AbsolutePathContext
        extends ContextWrapper {
            private final File parent;

            public AbsolutePathContext(Context context, File file) {
                super(context);
                this.parent = file;
            }

            public File getDatabasePath(String string2) {
                return new File(HealthReportSQLiteOpenHelper.getAbsolutePath(this.parent, string2));
            }

            public SQLiteDatabase openOrCreateDatabase(String string2, int n, SQLiteDatabase.CursorFactory cursorFactory) {
                File file = this.getDatabasePath(string2);
                Logger.pii(HealthReportSQLiteOpenHelper.LOG_TAG, "Opening database through absolute path " + file.getAbsolutePath());
                return SQLiteDatabase.openOrCreateDatabase((File)file, null);
            }
        }
    }
}

