/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport.upload;

import android.content.SharedPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;

public class ObsoleteDocumentTracker {
    public static final String LOG_TAG = ObsoleteDocumentTracker.class.getSimpleName();
    protected final SharedPreferences sharedPrefs;

    public ObsoleteDocumentTracker(SharedPreferences sharedPreferences) {
        this.sharedPrefs = sharedPreferences;
    }

    protected ExtendedJSONObject getObsoleteIds() {
        String string2 = this.sharedPrefs.getString("healthreport_obsolete_document_ids_to_deletions_remaining", null);
        if (string2 == null) {
            String string3 = this.sharedPrefs.getString("healthreport_last_upload_document_id", null);
            if (string3 == null) {
                return new ExtendedJSONObject();
            }
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
            extendedJSONObject.put(string3, 21L);
            this.setObsoleteIds(extendedJSONObject);
            return extendedJSONObject;
        }
        try {
            return ExtendedJSONObject.parseJSONObject(string2);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception getting obsolete ids.", exception);
            return new ExtendedJSONObject();
        }
    }

    protected void setObsoleteIds(ExtendedJSONObject extendedJSONObject) {
        this.sharedPrefs.edit().putString("healthreport_obsolete_document_ids_to_deletions_remaining", extendedJSONObject.toString()).commit();
    }

    public void removeObsoleteId(String string2) {
        ExtendedJSONObject extendedJSONObject = this.getObsoleteIds();
        extendedJSONObject.remove(string2);
        this.setObsoleteIds(extendedJSONObject);
    }

    protected void decrementObsoleteId(ExtendedJSONObject extendedJSONObject, String string2) {
        if (!extendedJSONObject.containsKey(string2)) {
            return;
        }
        try {
            Long l = extendedJSONObject.getLong(string2);
            if (l == null || (l = Long.valueOf(l - 1L)) < 1L) {
                extendedJSONObject.remove(string2);
            } else {
                extendedJSONObject.put(string2, l);
            }
        }
        catch (ClassCastException classCastException) {
            extendedJSONObject.remove(string2);
            Logger.info(LOG_TAG, "Got exception decrementing obsolete ids counter.", classCastException);
        }
    }

    public void decrementObsoleteIdAttempts(String string2) {
        ExtendedJSONObject extendedJSONObject = this.getObsoleteIds();
        this.decrementObsoleteId(extendedJSONObject, string2);
        this.setObsoleteIds(extendedJSONObject);
    }

    public void purgeObsoleteIds(Collection<String> collection) {
        ExtendedJSONObject extendedJSONObject = this.getObsoleteIds();
        for (String string2 : collection) {
            extendedJSONObject.remove(string2);
        }
        this.setObsoleteIds(extendedJSONObject);
    }

    public void decrementObsoleteIdAttempts(Collection<String> collection) {
        ExtendedJSONObject extendedJSONObject = this.getObsoleteIds();
        for (String string2 : collection) {
            this.decrementObsoleteId(extendedJSONObject, string2);
        }
        this.setObsoleteIds(extendedJSONObject);
    }

    public Collection<String> getBatchOfObsoleteIds() {
        ExtendedJSONObject extendedJSONObject = this.getObsoleteIds();
        ArrayList<Map.Entry<String, Object>> arrayList = new ArrayList<Map.Entry<String, Object>>(extendedJSONObject.entrySet());
        Collections.sort(arrayList, new PairComparator());
        ArrayList<String> arrayList2 = new ArrayList<String>(6);
        int n = 0;
        while (arrayList2.size() < 6 && n < arrayList.size()) {
            arrayList2.add((String)((Map.Entry)arrayList.get(n++)).getKey());
        }
        return arrayList2;
    }

    public void addObsoleteId(String string2) {
        ExtendedJSONObject extendedJSONObject = this.getObsoleteIds();
        if ((long)extendedJSONObject.size() >= 90L) {
            extendedJSONObject.remove(Collections.max(extendedJSONObject.entrySet(), new PairComparator()).getKey());
        }
        extendedJSONObject.put(string2, 21L);
        this.setObsoleteIds(extendedJSONObject);
    }

    public void markIdAsUploaded(String string2) {
        ExtendedJSONObject extendedJSONObject = this.getObsoleteIds();
        extendedJSONObject.put(string2, 126L);
        this.setObsoleteIds(extendedJSONObject);
    }

    public boolean hasObsoleteIds() {
        return this.getObsoleteIds().size() > 0;
    }

    public int numberOfObsoleteIds() {
        return this.getObsoleteIds().size();
    }

    public String getNextObsoleteId() {
        ExtendedJSONObject extendedJSONObject = this.getObsoleteIds();
        if (extendedJSONObject.size() < 1) {
            return null;
        }
        try {
            return Collections.min(extendedJSONObject.entrySet(), new PairComparator()).getKey();
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception picking obsolete id to delete.", exception);
            return null;
        }
    }

    public void limitObsoleteIds() {
        ExtendedJSONObject extendedJSONObject = this.getObsoleteIds();
        HashSet<String> hashSet = new HashSet<String>(extendedJSONObject.keySet());
        for (String string2 : hashSet) {
            Object object = extendedJSONObject.get(string2);
            if (!(object instanceof Long) || (Long)object <= 21L) continue;
            extendedJSONObject.put(string2, 21L);
        }
        this.setObsoleteIds(extendedJSONObject);
    }

    public static class PairComparator
    implements Comparator<Map.Entry<String, Object>> {
        @Override
        public int compare(Map.Entry<String, Object> entry, Map.Entry<String, Object> entry2) {
            Object object = entry.getValue();
            Object object2 = entry2.getValue();
            if (!(object instanceof Long)) {
                if (!(object2 instanceof Long)) {
                    return 0;
                }
                return -1;
            }
            if (!(object2 instanceof Long)) {
                return 1;
            }
            return ((Long)object2).compareTo((Long)object);
        }
    }
}

