/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import java.util.ArrayList;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserProvider;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.Table;

final class BrowserDatabaseHelper
extends SQLiteOpenHelper {
    private static final String LOGTAG = "GeckoBrowserDBHelper";
    public static final int DATABASE_VERSION = 22;
    public static final String DATABASE_NAME = "browser.db";
    protected final Context mContext;
    static final String TABLE_BOOKMARKS = "bookmarks";
    static final String TABLE_HISTORY = "history";
    static final String TABLE_FAVICONS = "favicons";
    static final String TABLE_THUMBNAILS = "thumbnails";
    static final String TABLE_READING_LIST = "reading_list";
    static final String VIEW_COMBINED = "combined";
    static final String VIEW_BOOKMARKS_WITH_FAVICONS = "bookmarks_with_favicons";
    static final String VIEW_HISTORY_WITH_FAVICONS = "history_with_favicons";
    static final String VIEW_COMBINED_WITH_FAVICONS = "combined_with_favicons";
    static final String TABLE_BOOKMARKS_JOIN_FAVICONS = "bookmarks LEFT OUTER JOIN favicons ON " + DBUtils.qualifyColumn("bookmarks", "favicon_id") + " = " + DBUtils.qualifyColumn("favicons", "_id");
    static final String TABLE_HISTORY_JOIN_FAVICONS = "history LEFT OUTER JOIN favicons ON " + DBUtils.qualifyColumn("history", "favicon_id") + " = " + DBUtils.qualifyColumn("favicons", "_id");
    static final String TABLE_BOOKMARKS_TMP = "bookmarks_tmp";
    static final String TABLE_HISTORY_TMP = "history_tmp";
    private static final String[] mobileIdColumns = new String[]{"_id"};
    private static final String[] mobileIdSelectionArgs = new String[]{"mobile"};
    private static final boolean logDebug = Log.isLoggable((String)"GeckoBrowserDBHelper", (int)3);
    private static final boolean logVerbose = Log.isLoggable((String)"GeckoBrowserDBHelper", (int)2);

    public BrowserDatabaseHelper(Context context, String string2) {
        super(context, string2, null, 22);
        this.mContext = context;
    }

    private void createBookmarksTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating bookmarks table");
        sQLiteDatabase.execSQL("CREATE TABLE bookmarks(_id INTEGER PRIMARY KEY AUTOINCREMENT,title TEXT,url TEXT,type INTEGER NOT NULL DEFAULT 1,parent INTEGER,position INTEGER NOT NULL,keyword TEXT,description TEXT,tags TEXT,favicon_id INTEGER,created INTEGER,modified INTEGER,guid TEXT NOT NULL,deleted INTEGER NOT NULL DEFAULT 0, FOREIGN KEY (parent) REFERENCES bookmarks(_id));");
        sQLiteDatabase.execSQL("CREATE INDEX bookmarks_url_index ON bookmarks(url)");
        sQLiteDatabase.execSQL("CREATE INDEX bookmarks_type_deleted_index ON bookmarks(type, deleted)");
        sQLiteDatabase.execSQL("CREATE UNIQUE INDEX bookmarks_guid_index ON bookmarks(guid)");
        sQLiteDatabase.execSQL("CREATE INDEX bookmarks_modified_index ON bookmarks(modified)");
    }

    private void createHistoryTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating history table");
        sQLiteDatabase.execSQL("CREATE TABLE history(_id INTEGER PRIMARY KEY AUTOINCREMENT,title TEXT,url TEXT NOT NULL,visits INTEGER NOT NULL DEFAULT 0,favicon_id INTEGER,date INTEGER,created INTEGER,modified INTEGER,guid TEXT NOT NULL,deleted INTEGER NOT NULL DEFAULT 0);");
        sQLiteDatabase.execSQL("CREATE INDEX history_url_index ON history(url)");
        sQLiteDatabase.execSQL("CREATE UNIQUE INDEX history_guid_index ON history(guid)");
        sQLiteDatabase.execSQL("CREATE INDEX history_modified_index ON history(modified)");
        sQLiteDatabase.execSQL("CREATE INDEX history_visited_index ON history(date)");
    }

    private void createFaviconsTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating favicons table");
        sQLiteDatabase.execSQL("CREATE TABLE favicons (_id INTEGER PRIMARY KEY AUTOINCREMENT,url TEXT UNIQUE,data BLOB,created INTEGER,modified INTEGER);");
        sQLiteDatabase.execSQL("CREATE INDEX favicons_url_index ON favicons(url)");
        sQLiteDatabase.execSQL("CREATE INDEX favicons_modified_index ON favicons(modified)");
    }

    private void createThumbnailsTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating thumbnails table");
        sQLiteDatabase.execSQL("CREATE TABLE thumbnails (_id INTEGER PRIMARY KEY AUTOINCREMENT,url TEXT UNIQUE,data BLOB);");
        sQLiteDatabase.execSQL("CREATE INDEX thumbnails_url_index ON thumbnails(url)");
    }

    private void createBookmarksWithFaviconsView(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating bookmarks_with_favicons view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS bookmarks_with_favicons AS SELECT " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "*") + ", " + DBUtils.qualifyColumn(TABLE_FAVICONS, "data") + " AS " + "favicon" + ", " + DBUtils.qualifyColumn(TABLE_FAVICONS, "url") + " AS " + "favicon_url" + " FROM " + TABLE_BOOKMARKS_JOIN_FAVICONS);
    }

    private void createHistoryWithFaviconsView(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating history_with_favicons view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS history_with_favicons AS SELECT " + DBUtils.qualifyColumn(TABLE_HISTORY, "*") + ", " + DBUtils.qualifyColumn(TABLE_FAVICONS, "data") + " AS " + "favicon" + ", " + DBUtils.qualifyColumn(TABLE_FAVICONS, "url") + " AS " + "favicon_url" + " FROM " + TABLE_HISTORY_JOIN_FAVICONS);
    }

    private void createCombinedViewOn19(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined AS SELECT " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + "," + "-1 AS " + "history_id" + "," + "0 AS " + "_id" + "," + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + "," + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "favicon_id") + " AS " + "favicon_id" + " FROM " + TABLE_BOOKMARKS + " WHERE " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "parent") + " <> " + -3 + " AND " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " = 0 AND " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + "CASE " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN " + "CASE " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "parent") + " WHEN " + -3 + " THEN " + "NULL " + "ELSE " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "_id") + " END " + "ELSE " + "NULL " + "END AS " + "bookmark_id" + "," + DBUtils.qualifyColumn(TABLE_HISTORY, "_id") + " AS " + "history_id" + "," + "0 AS " + "_id" + "," + DBUtils.qualifyColumn(TABLE_HISTORY, "url") + " AS " + "url" + "," + "COALESCE(" + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "title") + ", " + DBUtils.qualifyColumn(TABLE_HISTORY, "title") + ") AS " + "title" + "," + DBUtils.qualifyColumn(TABLE_HISTORY, "visits") + " AS " + "visits" + "," + DBUtils.qualifyColumn(TABLE_HISTORY, "date") + " AS " + "date" + "," + DBUtils.qualifyColumn(TABLE_HISTORY, "favicon_id") + " AS " + "favicon_id" + " FROM " + TABLE_HISTORY + " LEFT OUTER JOIN " + TABLE_BOOKMARKS + " ON " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "url") + " = " + DBUtils.qualifyColumn(TABLE_HISTORY, "url") + " WHERE " + DBUtils.qualifyColumn(TABLE_HISTORY, "deleted") + " = 0 AND " + "(" + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "type") + " IS NULL OR " + DBUtils.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + ")");
        BrowserDatabaseHelper.debug("Creating combined_with_favicons view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_favicons AS SELECT " + DBUtils.qualifyColumn(VIEW_COMBINED, "*") + ", " + DBUtils.qualifyColumn(TABLE_FAVICONS, "url") + " AS " + "favicon_url" + ", " + DBUtils.qualifyColumn(TABLE_FAVICONS, "data") + " AS " + "favicon" + " FROM " + VIEW_COMBINED + " LEFT OUTER JOIN " + TABLE_FAVICONS + " ON " + "favicon_id" + " = " + DBUtils.qualifyColumn(TABLE_FAVICONS, "_id"));
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating browser.db: " + sQLiteDatabase.getPath());
        for (Table table : BrowserProvider.sTables) {
            table.onCreate(sQLiteDatabase);
        }
        this.createBookmarksTable(sQLiteDatabase);
        this.createHistoryTable(sQLiteDatabase);
        this.createFaviconsTable(sQLiteDatabase);
        this.createThumbnailsTable(sQLiteDatabase);
        this.createBookmarksWithFaviconsView(sQLiteDatabase);
        this.createHistoryWithFaviconsView(sQLiteDatabase);
        this.createCombinedViewOn19(sQLiteDatabase);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "places", R.string.bookmarks_folder_places, 0);
        this.createOrUpdateAllSpecialFolders(sQLiteDatabase);
        this.createReadingListTable(sQLiteDatabase);
        this.createSearchHistoryTable(sQLiteDatabase);
    }

    private void createSearchHistoryTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating searchhistory table");
        sQLiteDatabase.execSQL("CREATE TABLE searchhistory(_id INTEGER PRIMARY KEY AUTOINCREMENT, query TEXT UNIQUE NOT NULL, date INTEGER, visits INTEGER ) ");
        sQLiteDatabase.execSQL("CREATE INDEX idx_search_history_last_visited ON searchhistory(date)");
    }

    private void createReadingListTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating reading_list table");
        sQLiteDatabase.execSQL("CREATE TABLE reading_list(_id INTEGER PRIMARY KEY AUTOINCREMENT, url TEXT NOT NULL, title TEXT, excerpt TEXT, read TINYINT DEFAULT 0, deleted TINYINT DEFAULT 0, guid TEXT UNIQUE NOT NULL, modified INTEGER NOT NULL, created INTEGER NOT NULL, length INTEGER DEFAULT 0, content_status TINYINT DEFAULT 0); ");
        sQLiteDatabase.execSQL("CREATE INDEX reading_list_url ON reading_list(url)");
        sQLiteDatabase.execSQL("CREATE UNIQUE INDEX reading_list_guid ON reading_list(guid)");
        sQLiteDatabase.execSQL("CREATE INDEX reading_list_content_status ON reading_list(content_status)");
    }

    private void createOrUpdateAllSpecialFolders(SQLiteDatabase sQLiteDatabase) {
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "mobile", R.string.bookmarks_folder_mobile, 0);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "toolbar", R.string.bookmarks_folder_toolbar, 1);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "menu", R.string.bookmarks_folder_menu, 2);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "tags", R.string.bookmarks_folder_tags, 3);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "unfiled", R.string.bookmarks_folder_unfiled, 4);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "pinned", R.string.bookmarks_folder_pinned, 5);
    }

    private void createOrUpdateSpecialFolder(SQLiteDatabase sQLiteDatabase, String string2, int n, int n2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("guid", string2);
        contentValues.put("type", Integer.valueOf(0));
        contentValues.put("position", Integer.valueOf(n2));
        if (string2.equals("places")) {
            contentValues.put("_id", Integer.valueOf(0));
        } else if (string2.equals("pinned")) {
            contentValues.put("_id", Integer.valueOf(-3));
        }
        contentValues.put("parent", Integer.valueOf(0));
        String string3 = this.mContext.getResources().getString(n);
        contentValues.put("title", string3);
        long l = System.currentTimeMillis();
        contentValues.put("created", Long.valueOf(l));
        contentValues.put("modified", Long.valueOf(l));
        int n3 = sQLiteDatabase.update(TABLE_BOOKMARKS, contentValues, "guid = ?", new String[]{string2});
        if (n3 == 0) {
            sQLiteDatabase.insert(TABLE_BOOKMARKS, "guid", contentValues);
            BrowserDatabaseHelper.debug("Inserted special folder: " + string2);
        } else {
            BrowserDatabaseHelper.debug("Updated special folder: " + string2);
        }
    }

    private boolean isSpecialFolder(ContentValues contentValues) {
        String string2 = contentValues.getAsString("guid");
        if (string2 == null) {
            return false;
        }
        return string2.equals("mobile") || string2.equals("menu") || string2.equals("toolbar") || string2.equals("unfiled") || string2.equals("tags");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateBookmarkFolder(SQLiteDatabase sQLiteDatabase, int n, BookmarkMigrator bookmarkMigrator) {
        boolean bl;
        Cursor cursor = null;
        BrowserDatabaseHelper.debug("Migrating bookmark folder with id = " + n);
        String string2 = "parent = " + n;
        String[] stringArray = null;
        boolean bl2 = bl = n == 0;
        if (bl) {
            string2 = "guid != ? AND (" + string2 + " OR " + "parent" + " = NULL)";
            stringArray = new String[]{"places"};
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<ContentValues> arrayList2 = new ArrayList<ContentValues>();
        try {
            cursor = sQLiteDatabase.query(TABLE_BOOKMARKS_TMP, null, string2, stringArray, null, null, null);
            while (cursor.moveToNext()) {
                ContentValues contentValues = new ContentValues();
                DatabaseUtils.cursorRowToContentValues((Cursor)cursor, (ContentValues)contentValues);
                boolean bl3 = this.isSpecialFolder(contentValues);
                if (contentValues.getAsLong("parent") == null && bl3) {
                    contentValues.put("parent", Integer.valueOf(0));
                }
                if (bl && !bl3) {
                    arrayList2.add(contentValues);
                    continue;
                }
                if (bookmarkMigrator != null) {
                    bookmarkMigrator.updateForNewTable(contentValues);
                }
                BrowserDatabaseHelper.debug("Migrating bookmark: " + contentValues.getAsString("title"));
                sQLiteDatabase.insert(TABLE_BOOKMARKS, "url", contentValues);
                Integer n2 = contentValues.getAsInteger("type");
                if (n2 == null || n2 != 0) continue;
                arrayList.add(contentValues.getAsInteger("_id"));
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        int n3 = arrayList2.size();
        if (n3 > 0) {
            Integer n4 = this.getMobileFolderId(sQLiteDatabase);
            if (n4 == null) {
                Log.e((String)LOGTAG, (String)"Error migrating invalid special folder entries: mobile folder id is null");
                return;
            }
            BrowserDatabaseHelper.debug("Found " + n3 + " invalid special folder entries");
            for (int i = 0; i < n3; ++i) {
                ContentValues contentValues = (ContentValues)arrayList2.get(i);
                contentValues.put("parent", n4);
                sQLiteDatabase.insert(TABLE_BOOKMARKS, "url", contentValues);
            }
        }
        int n5 = arrayList.size();
        for (int i = 0; i < n5; ++i) {
            int n6 = (Integer)arrayList.get(i);
            this.migrateBookmarkFolder(sQLiteDatabase, n6, bookmarkMigrator);
        }
    }

    private void migrateBookmarksTable(SQLiteDatabase sQLiteDatabase) {
        this.migrateBookmarksTable(sQLiteDatabase, null);
    }

    private void migrateBookmarksTable(SQLiteDatabase sQLiteDatabase, BookmarkMigrator bookmarkMigrator) {
        BrowserDatabaseHelper.debug("Renaming bookmarks table to bookmarks_tmp");
        sQLiteDatabase.execSQL("ALTER TABLE bookmarks RENAME TO bookmarks_tmp");
        BrowserDatabaseHelper.debug("Dropping views and indexes related to bookmarks");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS bookmarks_url_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS bookmarks_type_deleted_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS bookmarks_guid_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS bookmarks_modified_index");
        this.createBookmarksTable(sQLiteDatabase);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "places", R.string.bookmarks_folder_places, 0);
        this.migrateBookmarkFolder(sQLiteDatabase, 0, bookmarkMigrator);
        this.createOrUpdateAllSpecialFolders(sQLiteDatabase);
        BrowserDatabaseHelper.debug("Dropping bookmarks temporary table");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS bookmarks_tmp");
    }

    private void migrateHistoryTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Renaming history table to history_tmp");
        sQLiteDatabase.execSQL("ALTER TABLE history RENAME TO history_tmp");
        BrowserDatabaseHelper.debug("Dropping views and indexes related to history");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS history_url_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS history_guid_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS history_modified_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS history_visited_index");
        this.createHistoryTable(sQLiteDatabase);
        sQLiteDatabase.execSQL("INSERT INTO history SELECT * FROM history_tmp");
        BrowserDatabaseHelper.debug("Dropping history temporary table");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS history_tmp");
    }

    private void upgradeDatabaseFrom3to4(SQLiteDatabase sQLiteDatabase) {
        this.migrateBookmarksTable(sQLiteDatabase, new BookmarkMigrator3to4());
    }

    private void upgradeDatabaseFrom6to7(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Removing history visits with NULL GUIDs");
        sQLiteDatabase.execSQL("DELETE FROM history WHERE guid IS NULL");
        this.migrateBookmarksTable(sQLiteDatabase);
        this.migrateHistoryTable(sQLiteDatabase);
    }

    private void upgradeDatabaseFrom7to8(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Combining history entries with the same URL");
        sQLiteDatabase.execSQL("CREATE TEMP TABLE duped_urls AS SELECT url, SUM(visits) AS total, MAX(modified) AS latest, MAX(_id) AS winner FROM history GROUP BY url HAVING count(url) > 1");
        sQLiteDatabase.execSQL("CREATE UNIQUE INDEX duped_urls_url_index ON duped_urls (url)");
        String string2 = " FROM duped_urls WHERE " + DBUtils.qualifyColumn("duped_urls", "url") + " = " + DBUtils.qualifyColumn(TABLE_HISTORY, "url");
        sQLiteDatabase.execSQL("UPDATE history SET visits = (SELECT total" + string2 + "), " + "modified" + " = (SELECT " + "latest" + string2 + "), " + "deleted" + " = " + "(" + "_id" + " <> (SELECT " + "winner" + string2 + "))" + " WHERE " + "url" + " IN (SELECT " + "url" + " FROM " + "duped_urls" + ")");
        sQLiteDatabase.execSQL("DROP TABLE duped_urls");
    }

    private void upgradeDatabaseFrom10to11(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("CREATE INDEX bookmarks_type_deleted_index ON bookmarks(type, deleted)");
    }

    private void upgradeDatabaseFrom12to13(SQLiteDatabase sQLiteDatabase) {
        this.createFaviconsTable(sQLiteDatabase);
        try {
            sQLiteDatabase.execSQL("ALTER TABLE history ADD COLUMN favicon_id INTEGER");
            sQLiteDatabase.execSQL("ALTER TABLE bookmarks ADD COLUMN favicon_id INTEGER");
        }
        catch (SQLException sQLException) {
            BrowserDatabaseHelper.debug("Exception adding favicon_id column. We're probably fine." + (Object)((Object)sQLException));
        }
        this.createThumbnailsTable(sQLiteDatabase);
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS bookmarks_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS history_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
        this.createBookmarksWithFaviconsView(sQLiteDatabase);
        this.createHistoryWithFaviconsView(sQLiteDatabase);
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS images");
    }

    private void upgradeDatabaseFrom13to14(SQLiteDatabase sQLiteDatabase) {
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "pinned", R.string.bookmarks_folder_pinned, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeDatabaseFrom14to15(SQLiteDatabase sQLiteDatabase) {
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query(TABLE_BOOKMARKS, new String[]{"_id", "url"}, "parent = ?", new String[]{Integer.toString(-3)}, null, null, null);
            while (cursor.moveToNext()) {
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                if (Uri.parse((String)string2).getScheme() != null) continue;
                ContentValues contentValues = new ContentValues(1);
                String string3 = Uri.fromParts((String)"user-entered", (String)string2, null).toString();
                contentValues.put("url", string3);
                sQLiteDatabase.update(TABLE_BOOKMARKS, contentValues, "_id = ?", new String[]{Integer.toString(cursor.getInt(cursor.getColumnIndexOrThrow("_id")))});
            }
        }
    }

    private void upgradeDatabaseFrom15to16(SQLiteDatabase sQLiteDatabase) {
        this.createV19CombinedView(sQLiteDatabase);
    }

    private void upgradeDatabaseFrom16to17(SQLiteDatabase sQLiteDatabase) {
        try {
            sQLiteDatabase.execSQL("DELETE FROM favicons WHERE length(data) = 0");
            sQLiteDatabase.execSQL("DELETE FROM thumbnails WHERE length(data) = 0");
        }
        catch (SQLException sQLException) {
            Log.e((String)LOGTAG, (String)"Error purging invalid favicons or thumbnails", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeDatabaseFrom17to18(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Moving reading list items from 'bookmarks' table to 'reading_list' table");
        String[] stringArray = new String[]{String.valueOf(-2), "0"};
        String[] stringArray2 = new String[]{"_id", "guid", "url", "modified", "created", "title"};
        Cursor cursor = null;
        try {
            sQLiteDatabase.beginTransaction();
            this.createReadingListTable(sQLiteDatabase);
            cursor = sQLiteDatabase.query(TABLE_BOOKMARKS, stringArray2, "parent = ? AND deleted = ? ", stringArray, null, null, null);
            while (cursor.moveToNext()) {
                BrowserDatabaseHelper.debug(DatabaseUtils.dumpCurrentRowToString((Cursor)cursor));
                ContentValues contentValues = new ContentValues();
                DatabaseUtils.cursorStringToContentValues((Cursor)cursor, (String)"url", (ContentValues)contentValues, (String)"url");
                DatabaseUtils.cursorStringToContentValues((Cursor)cursor, (String)"guid", (ContentValues)contentValues, (String)"guid");
                DatabaseUtils.cursorStringToContentValues((Cursor)cursor, (String)"title", (ContentValues)contentValues, (String)"title");
                DatabaseUtils.cursorLongToContentValues((Cursor)cursor, (String)"created", (ContentValues)contentValues, (String)"created");
                DatabaseUtils.cursorLongToContentValues((Cursor)cursor, (String)"modified", (ContentValues)contentValues, (String)"modified");
                sQLiteDatabase.insertOrThrow(TABLE_READING_LIST, null, contentValues);
            }
            sQLiteDatabase.delete(TABLE_BOOKMARKS, "parent = ? ", new String[]{String.valueOf(-2)});
            sQLiteDatabase.delete(TABLE_BOOKMARKS, "_id = ? ", new String[]{String.valueOf(-2)});
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLException sQLException) {
            Log.e((String)LOGTAG, (String)"Error migrating reading list items", (Throwable)sQLException);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            sQLiteDatabase.endTransaction();
        }
    }

    private void upgradeDatabaseFrom18to19(SQLiteDatabase sQLiteDatabase) {
        this.createV19CombinedView(sQLiteDatabase);
        sQLiteDatabase.execSQL("DELETE FROM history WHERE url IS NULL");
        sQLiteDatabase.execSQL("UPDATE bookmarks SET type = 1 WHERE type IS NULL");
    }

    private void upgradeDatabaseFrom19to20(SQLiteDatabase sQLiteDatabase) {
        this.createSearchHistoryTable(sQLiteDatabase);
    }

    private void upgradeDatabaseFrom21to22(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Adding CONTENT_STATUS column to reading list table.");
        try {
            sQLiteDatabase.execSQL("ALTER TABLE reading_list ADD COLUMN content_status TINYINT DEFAULT 0");
            sQLiteDatabase.execSQL("CREATE INDEX reading_list_content_status ON reading_list(content_status)");
        }
        catch (SQLiteException sQLiteException) {
            Log.e((String)LOGTAG, (String)"Error upgrading database from 21 to 22", (Throwable)sQLiteException);
        }
    }

    private void createV19CombinedView(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_favicons");
        this.createCombinedViewOn19(sQLiteDatabase);
    }

    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        BrowserDatabaseHelper.debug("Upgrading browser.db: " + sQLiteDatabase.getPath() + " from " + n + " to " + n2);
        block15: for (int i = n + 1; i <= n2; ++i) {
            switch (i) {
                case 4: {
                    this.upgradeDatabaseFrom3to4(sQLiteDatabase);
                    continue block15;
                }
                case 7: {
                    this.upgradeDatabaseFrom6to7(sQLiteDatabase);
                    continue block15;
                }
                case 8: {
                    this.upgradeDatabaseFrom7to8(sQLiteDatabase);
                    continue block15;
                }
                case 11: {
                    this.upgradeDatabaseFrom10to11(sQLiteDatabase);
                    continue block15;
                }
                case 13: {
                    this.upgradeDatabaseFrom12to13(sQLiteDatabase);
                    continue block15;
                }
                case 14: {
                    this.upgradeDatabaseFrom13to14(sQLiteDatabase);
                    continue block15;
                }
                case 15: {
                    this.upgradeDatabaseFrom14to15(sQLiteDatabase);
                    continue block15;
                }
                case 16: {
                    this.upgradeDatabaseFrom15to16(sQLiteDatabase);
                    continue block15;
                }
                case 17: {
                    this.upgradeDatabaseFrom16to17(sQLiteDatabase);
                    continue block15;
                }
                case 18: {
                    this.upgradeDatabaseFrom17to18(sQLiteDatabase);
                    continue block15;
                }
                case 19: {
                    this.upgradeDatabaseFrom18to19(sQLiteDatabase);
                    continue block15;
                }
                case 20: {
                    this.upgradeDatabaseFrom19to20(sQLiteDatabase);
                    continue block15;
                }
                case 22: {
                    if (n <= 17) continue block15;
                    this.upgradeDatabaseFrom21to22(sQLiteDatabase);
                }
            }
        }
        for (Table table : BrowserProvider.sTables) {
            table.onUpgrade(sQLiteDatabase, n, n2);
        }
        if (n < 13 && n2 >= 13 && this.mContext.getDatabasePath("favicon_urls.db").exists()) {
            this.mContext.deleteDatabase("favicon_urls.db");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Opening browser.db: " + sQLiteDatabase.getPath());
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("PRAGMA foreign_keys=ON", null);
        }
        cursor = null;
        try {
            cursor = sQLiteDatabase.rawQuery("PRAGMA synchronous=NORMAL", null);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (Build.VERSION.SDK_INT >= 11) {
            if (Build.VERSION.SDK_INT < 16) {
                sQLiteDatabase.enableWriteAheadLogging();
                sQLiteDatabase.setLockingEnabled(false);
            }
        } else {
            cursor = null;
            try {
                cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=PERSIST", null);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    protected static void trace(String string2) {
        if (logVerbose) {
            Log.v((String)LOGTAG, (String)string2);
        }
    }

    protected static void debug(String string2) {
        if (logDebug) {
            Log.d((String)LOGTAG, (String)string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getMobileFolderId(SQLiteDatabase sQLiteDatabase) {
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query(TABLE_BOOKMARKS, mobileIdColumns, "guid = ?", mobileIdSelectionArgs, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                Integer n = null;
                return n;
            }
            Integer n = cursor.getInt(cursor.getColumnIndex("_id"));
            return n;
        }
    }

    private class BookmarkMigrator3to4
    implements BookmarkMigrator {
        private BookmarkMigrator3to4() {
        }

        @Override
        public void updateForNewTable(ContentValues contentValues) {
            Integer n = contentValues.getAsInteger("folder");
            if (n == null || n != 1) {
                contentValues.put("type", Integer.valueOf(1));
            } else {
                contentValues.put("type", Integer.valueOf(0));
            }
            contentValues.remove("folder");
        }
    }

    private static interface BookmarkMigrator {
        public void updateForNewTable(ContentValues var1);
    }
}

