/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.ReadingListAccessor;

public class LocalReadingListAccessor
implements ReadingListAccessor {
    private static final String LOG_TAG = "GeckoReadingListAcc";
    private final Uri mReadingListUriWithProfile;

    public LocalReadingListAccessor(String string2) {
        this.mReadingListUriWithProfile = DBUtils.appendProfile(string2, BrowserContract.ReadingListItems.CONTENT_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount(ContentResolver contentResolver) {
        String[] stringArray = new String[]{"_id"};
        int n = 0;
        try (Cursor cursor = contentResolver.query(this.mReadingListUriWithProfile, stringArray, null, null, null);){
            n = cursor.getCount();
        }
        Log.d((String)LOG_TAG, (String)("Got count " + n + " for reading list."));
        return n;
    }

    @Override
    public Cursor getReadingList(ContentResolver contentResolver) {
        return contentResolver.query(this.mReadingListUriWithProfile, BrowserContract.ReadingListItems.DEFAULT_PROJECTION, null, null, null);
    }

    @Override
    public Cursor getReadingListUnfetched(ContentResolver contentResolver) {
        return contentResolver.query(this.mReadingListUriWithProfile, new String[]{"_id", "url"}, "content_status = 0", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadingListItem(ContentResolver contentResolver, String string2) {
        Cursor cursor = contentResolver.query(this.mReadingListUriWithProfile, new String[]{"_id"}, "url = ? ", new String[]{string2}, null);
        if (cursor == null) {
            Log.e((String)LOG_TAG, (String)"Null cursor in isReadingListItem");
            return false;
        }
        try {
            boolean bl = cursor.getCount() > 0;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public void addReadingListItem(ContentResolver contentResolver, ContentValues contentValues) {
        for (String string2 : BrowserContract.ReadingListItems.REQUIRED_FIELDS) {
            if (contentValues.containsKey(string2)) continue;
            throw new IllegalArgumentException("Missing required field for reading list item: " + string2);
        }
        contentValues.put("deleted", Integer.valueOf(0));
        Uri uri = this.mReadingListUriWithProfile.buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        int n = contentResolver.update(uri, contentValues, "url = ? ", new String[]{contentValues.getAsString("url")});
        Log.d((String)LOG_TAG, (String)("Updated " + n + " rows to new modified time."));
    }

    @Override
    public void updateReadingListItem(ContentResolver contentResolver, ContentValues contentValues) {
        if (!contentValues.containsKey("_id")) {
            throw new IllegalArgumentException("Cannot update reading list item without an ID");
        }
        int n = contentResolver.update(this.mReadingListUriWithProfile, contentValues, "_id = ? ", new String[]{contentValues.getAsString("_id")});
        Log.d((String)LOG_TAG, (String)("Updated " + n + " reading list rows."));
    }

    @Override
    public void removeReadingListItemWithURL(ContentResolver contentResolver, String string2) {
        contentResolver.delete(this.mReadingListUriWithProfile, "url = ? ", new String[]{string2});
    }

    @Override
    public void registerContentObserver(Context context, ContentObserver contentObserver) {
        context.getContentResolver().registerContentObserver(this.mReadingListUriWithProfile, false, contentObserver);
    }
}

