/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.content.SyncResult;
import java.util.concurrent.CountDownLatch;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.Married;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.tokenserver.TokenServerException;

public class FxAccountSyncDelegate {
    protected final CountDownLatch latch;
    protected final SyncResult syncResult;
    protected final AndroidFxAccount fxAccount;

    public FxAccountSyncDelegate(CountDownLatch countDownLatch, SyncResult syncResult, AndroidFxAccount androidFxAccount) {
        if (countDownLatch == null) {
            throw new IllegalArgumentException("latch must not be null");
        }
        if (syncResult == null) {
            throw new IllegalArgumentException("syncResult must not be null");
        }
        if (androidFxAccount == null) {
            throw new IllegalArgumentException("fxAccount must not be null");
        }
        this.latch = countDownLatch;
        this.syncResult = syncResult;
        this.fxAccount = androidFxAccount;
    }

    protected void setSyncResultSuccess() {
        ++this.syncResult.stats.numUpdates;
    }

    protected void setSyncResultSoftError() {
        ++this.syncResult.stats.numUpdates;
        ++this.syncResult.stats.numIoExceptions;
    }

    protected void setSyncResultHardError() {
        ++this.syncResult.stats.numAuthExceptions;
    }

    public void handleSuccess() {
        this.setSyncResultSuccess();
        this.latch.countDown();
    }

    public void handleError(Exception exception) {
        State state;
        this.setSyncResultSoftError();
        if (exception instanceof TokenServerException && (state = this.fxAccount.getState()).getStateLabel() == State.StateLabel.Married) {
            Married married = (Married)state;
            this.fxAccount.setState(married.makeCohabitingState());
        }
        this.latch.countDown();
    }

    public void handleCannotSync(State state) {
        this.setSyncResultSoftError();
        this.latch.countDown();
    }

    public void postponeSync(long l) {
        if (l > 0L) {
            // empty if block
        }
        this.setSyncResultSoftError();
        this.latch.countDown();
    }

    public void rejectSync() {
        this.latch.countDown();
    }
}

