/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.os.SystemClock;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.gfx.SubdocumentScrollHelper;
import org.mozilla.gecko.util.FloatUtils;

abstract class Axis {
    private static final String LOGTAG = "GeckoAxis";
    private static final String PREF_SCROLLING_FRICTION_SLOW = "ui.scrolling.friction_slow";
    private static final String PREF_SCROLLING_FRICTION_FAST = "ui.scrolling.friction_fast";
    private static final String PREF_SCROLLING_MAX_EVENT_ACCELERATION = "ui.scrolling.max_event_acceleration";
    private static final String PREF_SCROLLING_OVERSCROLL_DECEL_RATE = "ui.scrolling.overscroll_decel_rate";
    private static final String PREF_SCROLLING_OVERSCROLL_SNAP_LIMIT = "ui.scrolling.overscroll_snap_limit";
    private static final String PREF_SCROLLING_MIN_SCROLLABLE_DISTANCE = "ui.scrolling.min_scrollable_distance";
    private static final String PREF_FLING_ACCEL_INTERVAL = "ui.scrolling.fling_accel_interval";
    private static final String PREF_FLING_ACCEL_BASE_MULTIPLIER = "ui.scrolling.fling_accel_base_multiplier";
    private static final String PREF_FLING_ACCEL_SUPPLEMENTAL_MULTIPLIER = "ui.scrolling.fling_accel_supplemental_multiplier";
    private static final String PREF_FLING_CURVE_FUNCTION_X1 = "ui.scrolling.fling_curve_function_x1";
    private static final String PREF_FLING_CURVE_FUNCTION_Y1 = "ui.scrolling.fling_curve_function_y1";
    private static final String PREF_FLING_CURVE_FUNCTION_X2 = "ui.scrolling.fling_curve_function_x2";
    private static final String PREF_FLING_CURVE_FUNCTION_Y2 = "ui.scrolling.fling_curve_function_y2";
    private static final String PREF_FLING_CURVE_THRESHOLD_VELOCITY = "ui.scrolling.fling_curve_threshold_velocity";
    private static final String PREF_FLING_CURVE_MAXIMUM_VELOCITY = "ui.scrolling.fling_curve_max_velocity";
    private static final String PREF_FLING_CURVE_NEWTON_ITERATIONS = "ui.scrolling.fling_curve_newton_iterations";
    private static float FRICTION_SLOW;
    private static float FRICTION_FAST;
    private static float VELOCITY_THRESHOLD;
    private static float MAX_EVENT_ACCELERATION;
    private static float OVERSCROLL_DECEL_RATE;
    private static float SNAP_LIMIT;
    private static float MIN_SCROLLABLE_DISTANCE;
    private static long FLING_ACCEL_INTERVAL;
    private static float FLING_ACCEL_BASE_MULTIPLIER;
    private static float FLING_ACCEL_SUPPLEMENTAL_MULTIPLIER;
    private static float FLING_CURVE_FUNCTION_X1;
    private static float FLING_CURVE_FUNCTION_Y1;
    private static float FLING_CURVE_FUNCTION_X2;
    private static float FLING_CURVE_FUNCTION_Y2;
    private static float FLING_CURVE_THRESHOLD_VELOCITY;
    private static float FLING_CURVE_MAXIMUM_VELOCITY;
    private static int FLING_CURVE_NEWTON_ITERATIONS;
    static final float MS_PER_FRAME = 16.666666f;
    static final long NS_PER_FRAME;
    private static final float FRAMERATE_MULTIPLIER = 1.0f;
    private static final int FLING_VELOCITY_POINTS = 8;
    private final SubdocumentScrollHelper mSubscroller;
    private int mOverscrollMode;
    private float mFirstTouchPos;
    private float mTouchPos;
    private float mLastTouchPos;
    private float mVelocity;
    private final float[] mRecentVelocities;
    private int mRecentVelocityCount;
    private boolean mScrollingDisabled;
    private boolean mDisableSnap;
    private float mDisplacement;
    private long mLastFlingTime;
    private float mLastFlingVelocity;
    private FlingStates mFlingState = FlingStates.STOPPED;

    private static float getFloatPref(Map<String, Integer> map, String string2, int n) {
        Integer n2 = map == null ? null : map.get(string2);
        return (float)(n2 == null || n2 < 0 ? n : n2) / 1000.0f;
    }

    private static int getIntPref(Map<String, Integer> map, String string2, int n) {
        Integer n2 = map == null ? null : map.get(string2);
        return n2 == null || n2 < 0 ? n : n2;
    }

    static void initPrefs() {
        String[] stringArray = new String[]{PREF_SCROLLING_FRICTION_FAST, PREF_SCROLLING_FRICTION_SLOW, PREF_SCROLLING_MAX_EVENT_ACCELERATION, PREF_SCROLLING_OVERSCROLL_DECEL_RATE, PREF_SCROLLING_OVERSCROLL_SNAP_LIMIT, PREF_SCROLLING_MIN_SCROLLABLE_DISTANCE, PREF_FLING_ACCEL_INTERVAL, PREF_FLING_ACCEL_BASE_MULTIPLIER, PREF_FLING_ACCEL_SUPPLEMENTAL_MULTIPLIER, PREF_FLING_CURVE_FUNCTION_X1, PREF_FLING_CURVE_FUNCTION_Y1, PREF_FLING_CURVE_FUNCTION_X2, PREF_FLING_CURVE_FUNCTION_Y2, PREF_FLING_CURVE_THRESHOLD_VELOCITY, PREF_FLING_CURVE_MAXIMUM_VELOCITY, PREF_FLING_CURVE_NEWTON_ITERATIONS};
        PrefsHelper.getPrefs(stringArray, (PrefsHelper.PrefHandler)new PrefsHelper.PrefHandlerBase(){
            Map<String, Integer> mPrefs = new HashMap<String, Integer>();

            @Override
            public void prefValue(String string2, int n) {
                this.mPrefs.put(string2, n);
            }

            @Override
            public void finish() {
                Axis.setPrefs(this.mPrefs);
            }
        });
    }

    static float getFrameAdjustedFriction(float f, long l) {
        float f2 = (float)l / (float)NS_PER_FRAME;
        return (float)Math.pow(Math.E, Math.log(f) / (double)f2);
    }

    static void setPrefs(Map<String, Integer> map) {
        FRICTION_SLOW = Axis.getFloatPref(map, PREF_SCROLLING_FRICTION_SLOW, 850);
        FRICTION_FAST = Axis.getFloatPref(map, PREF_SCROLLING_FRICTION_FAST, 970);
        VELOCITY_THRESHOLD = 10.0f;
        MAX_EVENT_ACCELERATION = Axis.getFloatPref(map, PREF_SCROLLING_MAX_EVENT_ACCELERATION, GeckoAppShell.getDpi() > 300 ? 100 : 40);
        OVERSCROLL_DECEL_RATE = Axis.getFloatPref(map, PREF_SCROLLING_OVERSCROLL_DECEL_RATE, 40);
        SNAP_LIMIT = Axis.getFloatPref(map, PREF_SCROLLING_OVERSCROLL_SNAP_LIMIT, 300);
        MIN_SCROLLABLE_DISTANCE = Axis.getFloatPref(map, PREF_SCROLLING_MIN_SCROLLABLE_DISTANCE, 500);
        FLING_ACCEL_INTERVAL = Axis.getIntPref(map, PREF_FLING_ACCEL_INTERVAL, 500);
        FLING_ACCEL_BASE_MULTIPLIER = Axis.getFloatPref(map, PREF_FLING_ACCEL_BASE_MULTIPLIER, 1000);
        FLING_ACCEL_SUPPLEMENTAL_MULTIPLIER = Axis.getFloatPref(map, PREF_FLING_ACCEL_SUPPLEMENTAL_MULTIPLIER, 1000);
        FLING_CURVE_FUNCTION_X1 = Axis.getFloatPref(map, PREF_FLING_CURVE_FUNCTION_X1, 410);
        FLING_CURVE_FUNCTION_Y1 = Axis.getFloatPref(map, PREF_FLING_CURVE_FUNCTION_Y1, 0);
        FLING_CURVE_FUNCTION_X2 = Axis.getFloatPref(map, PREF_FLING_CURVE_FUNCTION_X2, 800);
        FLING_CURVE_FUNCTION_Y2 = Axis.getFloatPref(map, PREF_FLING_CURVE_FUNCTION_Y2, 1000);
        FLING_CURVE_THRESHOLD_VELOCITY = Axis.getFloatPref(map, PREF_FLING_CURVE_THRESHOLD_VELOCITY, 30);
        FLING_CURVE_MAXIMUM_VELOCITY = Axis.getFloatPref(map, PREF_FLING_CURVE_MAXIMUM_VELOCITY, 70);
        FLING_CURVE_NEWTON_ITERATIONS = Axis.getIntPref(map, PREF_FLING_CURVE_NEWTON_ITERATIONS, 5);
        Log.i((String)LOGTAG, (String)("Prefs: " + FRICTION_SLOW + "," + FRICTION_FAST + "," + VELOCITY_THRESHOLD + "," + MAX_EVENT_ACCELERATION + "," + OVERSCROLL_DECEL_RATE + "," + SNAP_LIMIT + "," + MIN_SCROLLABLE_DISTANCE));
    }

    protected abstract float getOrigin();

    protected abstract float getViewportLength();

    protected abstract float getPageStart();

    protected abstract float getPageLength();

    protected abstract float getMarginStart();

    protected abstract float getMarginEnd();

    protected abstract boolean marginsHidden();

    Axis(SubdocumentScrollHelper subdocumentScrollHelper) {
        this.mSubscroller = subdocumentScrollHelper;
        this.mOverscrollMode = 1;
        this.mRecentVelocities = new float[8];
    }

    protected void overscrollFling(float f) {
    }

    protected void overscrollPan(float f) {
    }

    public void setOverScrollMode(int n) {
        this.mOverscrollMode = n;
    }

    public int getOverScrollMode() {
        return this.mOverscrollMode;
    }

    private float getViewportEnd() {
        return this.getOrigin() + this.getViewportLength();
    }

    private float getPageEnd() {
        return this.getPageStart() + this.getPageLength();
    }

    void startTouch(float f) {
        this.mVelocity = 0.0f;
        this.mScrollingDisabled = false;
        this.mTouchPos = this.mLastTouchPos = f;
        this.mFirstTouchPos = this.mLastTouchPos;
        this.mRecentVelocityCount = 0;
    }

    float panDistance(float f) {
        return f - this.mFirstTouchPos;
    }

    void setScrollingDisabled(boolean bl) {
        this.mScrollingDisabled = bl;
    }

    void saveTouchPos() {
        this.mLastTouchPos = this.mTouchPos;
    }

    float getSlope(float f) {
        float f2 = FLING_CURVE_FUNCTION_Y1;
        float f3 = FLING_CURVE_FUNCTION_Y2;
        return 3.0f * f2 + f * (6.0f * f3 - 12.0f * f2) + f * f * (9.0f * f2 - 9.0f * f3 + 3.0f);
    }

    float cubicBezier(float f, float f2, float f3) {
        return 3.0f * f3 * (1.0f - f3) * (1.0f - f3) * f + 3.0f * f3 * f3 * (1.0f - f3) * f2 + f3 * f3 * f3;
    }

    float flingCurve(float f) {
        int n = FLING_CURVE_NEWTON_ITERATIONS;
        float[] fArray = new float[n];
        float f2 = FLING_CURVE_FUNCTION_Y1;
        float f3 = FLING_CURVE_FUNCTION_Y2;
        fArray[0] = f;
        for (int i = 1; i < n; ++i) {
            fArray[i] = fArray[i - 1] - (this.cubicBezier(f2, f3, fArray[i - 1]) - f) / this.getSlope(fArray[i - 1]);
        }
        float f4 = fArray[4];
        float f5 = FLING_CURVE_FUNCTION_X1;
        float f6 = FLING_CURVE_FUNCTION_X2;
        return this.cubicBezier(f5, f6, f4);
    }

    void updateWithTouchAt(float f, float f2) {
        boolean bl;
        float f3;
        float f4 = FLING_CURVE_THRESHOLD_VELOCITY * (float)GeckoAppShell.getDpi() * 16.666666f;
        float f5 = FLING_CURVE_MAXIMUM_VELOCITY * (float)GeckoAppShell.getDpi() * 16.666666f;
        float f6 = (this.mTouchPos - f) / f2 * 16.666666f;
        if (Math.abs(f6) > f4 && Math.abs(f6) < f5) {
            float f7 = Math.signum(f6);
            float f8 = f5 - f4;
            f3 = ((f6 *= f7) - f4) / f8;
            float f9 = this.flingCurve(f3);
            f6 = f9 * f8 + f4;
            f6 *= f7;
        }
        this.mRecentVelocities[this.mRecentVelocityCount % 8] = f6;
        ++this.mRecentVelocityCount;
        boolean bl2 = Math.abs(this.mVelocity) < 1.0f;
        boolean bl3 = bl = this.mVelocity > 0.0f != f6 > 0.0f;
        if (bl2 || bl && !FloatUtils.fuzzyEquals((float)f6, (float)0.0f)) {
            this.mVelocity = f6;
        } else {
            f3 = Math.abs(this.mVelocity * f2 * MAX_EVENT_ACCELERATION);
            this.mVelocity = Math.min(this.mVelocity + f3, Math.max(this.mVelocity - f3, f6));
        }
        this.mTouchPos = f;
    }

    boolean overscrolled() {
        return this.getOverscroll() != Overscroll.NONE;
    }

    private Overscroll getOverscroll() {
        boolean bl;
        boolean bl2 = this.getOrigin() < this.getPageStart();
        boolean bl3 = bl = this.getViewportEnd() > this.getPageEnd();
        if (bl2 && bl) {
            return Overscroll.BOTH;
        }
        if (bl2) {
            return Overscroll.MINUS;
        }
        if (bl) {
            return Overscroll.PLUS;
        }
        return Overscroll.NONE;
    }

    private float getExcess() {
        switch (this.getOverscroll()) {
            case MINUS: {
                return this.getPageStart() - this.getOrigin();
            }
            case PLUS: {
                return this.getViewportEnd() - this.getPageEnd();
            }
            case BOTH: {
                return this.getViewportEnd() - this.getPageEnd() + (this.getPageStart() - this.getOrigin());
            }
        }
        return 0.0f;
    }

    boolean scrollable() {
        if (this.mSubscroller.scrolling()) {
            return !this.mScrollingDisabled;
        }
        if (this.mScrollingDisabled) {
            return false;
        }
        if (this.marginsHidden()) {
            return true;
        }
        return this.getViewportLength() <= this.getPageLength() - MIN_SCROLLABLE_DISTANCE || this.getOverScrollMode() == 0;
    }

    float getEdgeResistance(boolean bl) {
        float f = this.getExcess();
        if (f > 0.0f && (this.getOverscroll() == Overscroll.BOTH || !bl)) {
            return Math.max(0.0f, SNAP_LIMIT - f / this.getViewportLength());
        }
        return 1.0f;
    }

    float getRealVelocity() {
        return this.scrollable() ? this.mVelocity : 0.0f;
    }

    void startPan() {
        this.mFlingState = FlingStates.PANNING;
    }

    private float calculateFlingVelocity() {
        int n = Math.min(this.mRecentVelocityCount, 8);
        if (n <= 1) {
            return this.mVelocity;
        }
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += this.mRecentVelocities[i];
        }
        return f / (float)n;
    }

    float accelerate(float f, float f2) {
        return FLING_ACCEL_BASE_MULTIPLIER * f + FLING_ACCEL_SUPPLEMENTAL_MULTIPLIER * f2;
    }

    void startFling(boolean bl) {
        this.mDisableSnap = this.mSubscroller.scrolling();
        if (bl) {
            this.mFlingState = FlingStates.STOPPED;
        } else {
            long l = SystemClock.uptimeMillis();
            this.mVelocity = this.calculateFlingVelocity();
            if (l - this.mLastFlingTime < FLING_ACCEL_INTERVAL && Math.signum(this.mVelocity) == Math.signum(this.mLastFlingVelocity)) {
                this.mVelocity = this.accelerate(this.mVelocity, this.mLastFlingVelocity);
            }
            this.mFlingState = FlingStates.FLINGING;
            this.mLastFlingVelocity = this.mVelocity;
            this.mLastFlingTime = l;
        }
    }

    boolean advanceFling(long l) {
        if (this.mFlingState != FlingStates.FLINGING) {
            return false;
        }
        if (this.mSubscroller.scrolling() && !this.mSubscroller.lastScrollSucceeded()) {
            return false;
        }
        float f = this.getExcess();
        Overscroll overscroll = this.getOverscroll();
        boolean bl = false;
        if (overscroll == Overscroll.MINUS && this.mVelocity > 0.0f || overscroll == Overscroll.PLUS && this.mVelocity < 0.0f) {
            bl = true;
        }
        if (this.mDisableSnap || FloatUtils.fuzzyEquals((float)f, (float)0.0f) || bl) {
            if (Math.abs(this.mVelocity) >= VELOCITY_THRESHOLD) {
                this.mVelocity *= Axis.getFrameAdjustedFriction(FRICTION_FAST, l);
            } else {
                float f2 = this.mVelocity / VELOCITY_THRESHOLD;
                this.mVelocity *= FloatUtils.interpolate((float)Axis.getFrameAdjustedFriction(FRICTION_SLOW, l), (float)Axis.getFrameAdjustedFriction(FRICTION_FAST, l), (float)f2);
            }
        } else {
            float f3 = 1.0f - f / (this.getViewportLength() * SNAP_LIMIT);
            float f4 = Axis.getFrameAdjustedFriction(OVERSCROLL_DECEL_RATE, l);
            this.mVelocity = overscroll == Overscroll.MINUS ? Math.min((this.mVelocity + f4) * f3, 0.0f) : Math.max((this.mVelocity - f4) * f3, 0.0f);
        }
        return true;
    }

    void stopFling() {
        this.mVelocity = 0.0f;
        this.mFlingState = FlingStates.STOPPED;
    }

    void displace() {
        if (!this.scrollable()) {
            return;
        }
        this.mDisplacement = this.mFlingState == FlingStates.PANNING ? (this.mDisplacement += (this.mLastTouchPos - this.mTouchPos) * this.getEdgeResistance(false)) : (this.mDisplacement += this.mVelocity * this.getEdgeResistance(false));
        if (this.getOverScrollMode() == 2 && !this.mSubscroller.scrolling()) {
            float f = this.mDisplacement;
            if (this.mDisplacement + this.getOrigin() < this.getPageStart() - this.getMarginStart()) {
                this.mDisplacement = this.getPageStart() - this.getMarginStart() - this.getOrigin();
            } else if (this.mDisplacement + this.getViewportEnd() > this.getPageEnd() + this.getMarginEnd()) {
                this.mDisplacement = this.getPageEnd() - this.getMarginEnd() - this.getViewportEnd();
            }
            if (f != this.mDisplacement) {
                if (this.mFlingState == FlingStates.FLINGING) {
                    this.overscrollFling(this.mVelocity / 16.666666f * 1000.0f);
                    this.stopFling();
                } else if (this.mFlingState == FlingStates.PANNING) {
                    this.overscrollPan(f - this.mDisplacement);
                }
            }
        }
    }

    float resetDisplacement() {
        float f = this.mDisplacement;
        this.mDisplacement = 0.0f;
        return f;
    }

    void setAutoscrollVelocity(float f) {
        if (this.mFlingState != FlingStates.STOPPED) {
            Log.e((String)LOGTAG, (String)"Setting autoscroll velocity while in a fling is not allowed!");
            return;
        }
        this.mVelocity = f;
    }

    static {
        NS_PER_FRAME = Math.round(1.6666667E7f);
        Axis.setPrefs(null);
    }

    private static enum Overscroll {
        NONE,
        MINUS,
        PLUS,
        BOTH;

    }

    private static enum FlingStates {
        STOPPED,
        PANNING,
        FLINGING;

    }
}

