/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.health;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.SystemClock;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.background.healthreport.AndroidConfigurationProvider;
import org.mozilla.gecko.background.healthreport.EnvironmentBuilder;
import org.mozilla.gecko.background.healthreport.HealthReportDatabaseStorage;
import org.mozilla.gecko.background.healthreport.HealthReportStorage;
import org.mozilla.gecko.background.healthreport.ProfileInformationCache;
import org.mozilla.gecko.distribution.Distribution;
import org.mozilla.gecko.health.HealthRecorder;
import org.mozilla.gecko.health.SessionInformation;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class BrowserHealthRecorder
implements HealthRecorder,
GeckoEventListener {
    private static final String LOG_TAG = "GeckoHealthRec";
    private static final String PREF_ACCEPT_LANG = "intl.accept_languages";
    private static final String PREF_BLOCKLIST_ENABLED = "extensions.blocklist.enabled";
    private static final String EVENT_SNAPSHOT = "HealthReport:Snapshot";
    private static final String EVENT_ADDONS_CHANGE = "Addons:Change";
    private static final String EVENT_ADDONS_UNINSTALLING = "Addons:Uninstalling";
    private static final String EVENT_PREF_CHANGE = "Pref:Change";
    public static final String EVENT_KEYWORD_SEARCH = "Search:Keyword";
    public static final String EVENT_SEARCH = "Search:Event";
    protected volatile State state = State.NOT_INITIALIZED;
    private final AtomicBoolean orphanChecked = new AtomicBoolean(false);
    private volatile int env = -1;
    final EventDispatcher dispatcher;
    final ProfileInformationCache profileCache;
    private ContentProviderClient client;
    private volatile HealthReportDatabaseStorage storage;
    private final EnvironmentBuilder.ConfigurationProvider configProvider;
    private final SharedPreferences prefs;
    private final SessionInformation previousSession;
    private volatile SessionInformation session;
    public static final String MEASUREMENT_NAME_SEARCH_COUNTS = "org.mozilla.searches.counts";
    public static final int MEASUREMENT_VERSION_SEARCH_COUNTS = 6;
    public static final Set<String> SEARCH_LOCATIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("barkeyword", "barsuggest", "bartext", "activity")));
    public static final String MEASUREMENT_NAME_SESSIONS = "org.mozilla.appSessions";
    public static final int MEASUREMENT_VERSION_SESSIONS = 4;
    private static final ConcurrentLinkedQueue<Search> delayedSearches = new ConcurrentLinkedQueue();

    @Override
    public void setCurrentSession(SessionInformation sessionInformation) {
        this.session = sessionInformation;
    }

    @Override
    public void recordGeckoStartupTime(long l) {
        if (this.session == null) {
            return;
        }
        this.session.setTimedGeckoStartup(l);
    }

    @Override
    public void recordJavaStartupTime(long l) {
        if (this.session == null) {
            return;
        }
        this.session.setTimedJavaStartup(l);
    }

    public BrowserHealthRecorder(Context context, SharedPreferences sharedPreferences, String string2, EventDispatcher eventDispatcher, String string3, String string4, SessionInformation sessionInformation) {
        Log.d((String)LOG_TAG, (String)("Initializing. Dispatcher is " + eventDispatcher));
        this.dispatcher = eventDispatcher;
        this.previousSession = sessionInformation;
        this.client = EnvironmentBuilder.getContentProviderClient(context);
        if (this.client == null) {
            throw new IllegalStateException("Could not fetch Health Report content provider.");
        }
        this.storage = EnvironmentBuilder.getStorage(this.client, string2);
        if (this.storage == null) {
            this.client.release();
            this.client = null;
        }
        this.profileCache = new ProfileInformationCache(string2);
        try {
            this.initialize(context, string2, string3, string4);
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Exception initializing.", (Throwable)exception);
        }
        this.configProvider = new AndroidConfigurationProvider(context);
        this.prefs = sharedPreferences;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public synchronized void close() {
        switch (this.state) {
            case CLOSED: {
                Log.w((String)LOG_TAG, (String)"Ignoring attempt to double-close closed BrowserHealthRecorder.");
                return;
            }
            case INITIALIZED: {
                Log.i((String)LOG_TAG, (String)"Closing Health Report client.");
                break;
            }
            default: {
                Log.i((String)LOG_TAG, (String)"Closing incompletely initialized BrowserHealthRecorder.");
            }
        }
        this.state = State.CLOSED;
        this.unregisterEventListeners();
        this.storage = null;
        if (this.client != null) {
            this.client.release();
            this.client = null;
        }
    }

    private void unregisterEventListeners() {
        if (this.state != State.INITIALIZED) {
            return;
        }
        this.dispatcher.unregisterGeckoThreadListener(this, EVENT_SNAPSHOT, EVENT_ADDONS_CHANGE, EVENT_ADDONS_UNINSTALLING, EVENT_PREF_CHANGE, EVENT_KEYWORD_SEARCH, EVENT_SEARCH);
    }

    @Override
    public void onAppLocaleChanged(String string2) {
        Log.d((String)LOG_TAG, (String)("Setting health recorder app locale to " + string2));
        this.profileCache.beginInitialization();
        this.profileCache.setAppLocale(string2);
    }

    @Override
    public void onAddonChanged(String string2, JSONObject jSONObject) {
        this.profileCache.beginInitialization();
        try {
            this.profileCache.updateJSONForAddon(string2, jSONObject);
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)LOG_TAG, (String)"Attempted to update add-on cache prior to full init.", (Throwable)illegalStateException);
        }
    }

    @Override
    public void onAddonUninstalling(String string2) {
        this.profileCache.beginInitialization();
        try {
            this.profileCache.removeAddon(string2);
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)LOG_TAG, (String)"Attempted to update add-on cache prior to full init.", (Throwable)illegalStateException);
        }
    }

    @Override
    public synchronized void onEnvironmentChanged() {
        this.onEnvironmentChanged(true, "E");
    }

    @Override
    public synchronized void onEnvironmentChanged(final boolean bl, final String string2) {
        final int n = this.env;
        this.env = -1;
        try {
            this.profileCache.completeInitialization();
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)"Error completing profile cache initialization.", (Throwable)iOException);
            this.state = State.INITIALIZATION_FAILED;
            return;
        }
        final int n2 = this.ensureEnvironment();
        if (n2 == -1 || n2 == n) {
            Log.v((String)LOG_TAG, (String)"Environment didn't change.");
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    BrowserHealthRecorder.this.onEnvironmentTransition(n, n2, bl, string2);
                }
                catch (Exception exception) {
                    Log.w((String)BrowserHealthRecorder.LOG_TAG, (String)"Could not record environment transition.", (Throwable)exception);
                }
            }
        });
    }

    protected synchronized int ensureEnvironment() {
        if (this.state != State.INITIALIZING && this.state != State.INITIALIZED) {
            throw new IllegalStateException("Not initialized.");
        }
        if (this.env != -1) {
            return this.env;
        }
        if (this.storage == null) {
            return -1;
        }
        this.env = EnvironmentBuilder.registerCurrentEnvironment(this.storage, this.profileCache, this.configProvider);
        return this.env;
    }

    private static final String getTimesPath(String string2) {
        return string2 + File.separator + "times.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long getProfileInitTimeFromFile(String string2) {
        File file = new File(BrowserHealthRecorder.getTimesPath(string2));
        Log.d((String)LOG_TAG, (String)("Looking for " + file.getAbsolutePath()));
        if (!file.exists()) {
            return -1L;
        }
        Log.d((String)LOG_TAG, (String)"Using times.json for profile creation time.");
        try (Scanner scanner = null;){
            scanner = new Scanner(file, "UTF-8");
            String string3 = scanner.useDelimiter("\\A").next();
            long l = new JSONObject(string3).getLong("created");
            return l;
        }
        return -1L;
    }

    protected static long getPackageInstallTime(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)"org.mozilla.fennec", (int)0).firstInstallTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)LOG_TAG, (String)"Unable to fetch our own package info. This should never occur.", (Throwable)nameNotFoundException);
            return -1L;
        }
    }

    private static long getProfileInitTimeHeuristic(Context context, String string2) {
        long l = BrowserHealthRecorder.getPackageInstallTime(context);
        if (l != -1L) {
            return l;
        }
        Log.d((String)LOG_TAG, (String)"Using profile directory modified time as proxy for profile creation time.");
        return new File(string2).lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getAndPersistProfileInitTime(Context context, String string2) {
        long l = BrowserHealthRecorder.getProfileInitTimeFromFile(string2);
        if (l > 0L) {
            Log.d((String)LOG_TAG, (String)("Incorporating environment: times.json profile creation = " + l));
            return l;
        }
        l = BrowserHealthRecorder.getProfileInitTimeHeuristic(context, string2);
        if (l > 0L) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(BrowserHealthRecorder.getTimesPath(string2));
                try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));){
                    outputStreamWriter.append("{\"created\": " + l + "}\n");
                }
            }
            catch (Exception exception) {
                Log.w((String)LOG_TAG, (String)"Couldn't write times.json.", (Throwable)exception);
            }
        }
        Log.d((String)LOG_TAG, (String)("Incorporating environment: profile creation = " + l));
        return l;
    }

    private void onPrefMessage(String string2, JSONObject jSONObject) {
        Log.d((String)LOG_TAG, (String)("Incorporating environment: " + string2));
        if (PREF_ACCEPT_LANG.equals(string2)) {
            try {
                this.profileCache.beginInitialization();
                this.profileCache.setAcceptLangUserSet(jSONObject.getBoolean("isUserSet"));
            }
            catch (JSONException jSONException) {
                Log.w((String)LOG_TAG, (String)("Unexpected JSONException fetching isUserSet for " + string2));
            }
            return;
        }
        try {
            boolean bl = jSONObject.getBoolean("value");
            if ("toolkit.telemetry.enabled".equals(string2)) {
                this.profileCache.beginInitialization();
                this.profileCache.setTelemetryEnabled(bl);
                return;
            }
            if (PREF_BLOCKLIST_ENABLED.equals(string2)) {
                this.profileCache.beginInitialization();
                this.profileCache.setBlocklistEnabled(bl);
                return;
            }
        }
        catch (JSONException jSONException) {
            Log.w((String)LOG_TAG, (String)("Unexpected JSONException fetching boolean value for " + string2));
            return;
        }
        Log.w((String)LOG_TAG, (String)("Unexpected pref: " + string2));
    }

    private void initializeStorage() {
        Log.d((String)LOG_TAG, (String)"Done initializing profile cache. Beginning storage init.");
        final BrowserHealthRecorder browserHealthRecorder = this;
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BrowserHealthRecorder browserHealthRecorder2 = browserHealthRecorder;
                synchronized (browserHealthRecorder2) {
                    if (BrowserHealthRecorder.this.state != State.INITIALIZING) {
                        Log.w((String)BrowserHealthRecorder.LOG_TAG, (String)("Unexpected state during init: " + (Object)((Object)BrowserHealthRecorder.this.state)));
                        return;
                    }
                    if (BrowserHealthRecorder.this.storage == null) {
                        Log.w((String)BrowserHealthRecorder.LOG_TAG, (String)"Storage is null during init; shutting down?");
                        if (BrowserHealthRecorder.this.state == State.INITIALIZING) {
                            BrowserHealthRecorder.this.state = State.INITIALIZATION_FAILED;
                        }
                        return;
                    }
                    try {
                        BrowserHealthRecorder.this.storage.beginInitialization();
                    }
                    catch (Exception exception) {
                        Log.e((String)BrowserHealthRecorder.LOG_TAG, (String)"Failed to init storage.", (Throwable)exception);
                        BrowserHealthRecorder.this.state = State.INITIALIZATION_FAILED;
                        return;
                    }
                    try {
                        BrowserHealthRecorder.this.dispatcher.registerGeckoThreadListener(browserHealthRecorder, BrowserHealthRecorder.EVENT_ADDONS_UNINSTALLING, BrowserHealthRecorder.EVENT_ADDONS_CHANGE, BrowserHealthRecorder.EVENT_PREF_CHANGE);
                        BrowserHealthRecorder.this.initializeSessionsProvider();
                        BrowserHealthRecorder.this.initializeSearchProvider();
                        Log.d((String)BrowserHealthRecorder.LOG_TAG, (String)"Ensuring environment.");
                        BrowserHealthRecorder.this.ensureEnvironment();
                        Log.d((String)BrowserHealthRecorder.LOG_TAG, (String)"Finishing init.");
                        BrowserHealthRecorder.this.storage.finishInitialization();
                        BrowserHealthRecorder.this.state = State.INITIALIZED;
                    }
                    catch (Exception exception) {
                        BrowserHealthRecorder.this.state = State.INITIALIZATION_FAILED;
                        BrowserHealthRecorder.this.storage.abortInitialization();
                        Log.e((String)BrowserHealthRecorder.LOG_TAG, (String)"Initialization failed.", (Throwable)exception);
                        return;
                    }
                    BrowserHealthRecorder.this.checkForOrphanSessions();
                }
            }
        });
    }

    private synchronized void initialize(Context context, String string2, String string3, String string4) throws IOException {
        Log.d((String)LOG_TAG, (String)"Initializing profile cache.");
        this.state = State.INITIALIZING;
        if (this.profileCache.restoreUnlessInitialized()) {
            this.profileCache.updateLocales(string3, string4);
            this.profileCache.completeInitialization();
            Log.d((String)LOG_TAG, (String)"Successfully restored state. Initializing storage.");
            this.initializeStorage();
            return;
        }
        this.profileCache.beginInitialization();
        this.profileCache.setProfileCreationTime(BrowserHealthRecorder.getAndPersistProfileInitTime(context, string2));
        this.profileCache.setOSLocale(string3);
        this.profileCache.setAppLocale(string4);
        Distribution distribution = Distribution.getInstance(context);
        distribution.addOnDistributionReadyCallback(new Distribution.ReadyCallback(){

            private void requestGeckoFields() {
                Log.d((String)BrowserHealthRecorder.LOG_TAG, (String)"Requesting all add-ons and FHR prefs from Gecko.");
                BrowserHealthRecorder.this.dispatcher.registerGeckoThreadListener(BrowserHealthRecorder.this, BrowserHealthRecorder.EVENT_SNAPSHOT);
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("HealthReport:RequestSnapshot", null));
            }

            @Override
            public void distributionNotFound() {
                this.requestGeckoFields();
            }

            @Override
            public void distributionFound(Distribution distribution) {
                Log.d((String)BrowserHealthRecorder.LOG_TAG, (String)"Running post-distribution task: health recorder.");
                Distribution.DistributionDescriptor distributionDescriptor = distribution.getDescriptor();
                if (distributionDescriptor != null && distributionDescriptor.valid) {
                    BrowserHealthRecorder.this.profileCache.setDistributionString(distributionDescriptor.id, distributionDescriptor.version);
                }
                this.requestGeckoFields();
            }

            @Override
            public void distributionArrivedLate(Distribution distribution) {
                BrowserHealthRecorder.this.profileCache.beginInitialization();
                Distribution.DistributionDescriptor distributionDescriptor = distribution.getDescriptor();
                if (distributionDescriptor != null && distributionDescriptor.valid) {
                    BrowserHealthRecorder.this.profileCache.setDistributionString(distributionDescriptor.id, distributionDescriptor.version);
                }
                try {
                    BrowserHealthRecorder.this.profileCache.completeInitialization();
                    if (BrowserHealthRecorder.this.state == State.INITIALIZING) {
                        BrowserHealthRecorder.this.initializeStorage();
                    } else {
                        BrowserHealthRecorder.this.onEnvironmentChanged();
                    }
                }
                catch (Exception exception) {
                    Log.e((String)BrowserHealthRecorder.LOG_TAG, (String)"Couldn't complete profile cache init.", (Throwable)exception);
                }
            }
        });
    }

    protected void onEnvironmentTransition(int n, int n2, boolean bl, String string2) {
        if (this.state != State.INITIALIZED) {
            Log.d((String)LOG_TAG, (String)("Not initialized: not recording env transition (" + n + " => " + n2 + ")."));
            return;
        }
        SharedPreferences.Editor editor = this.prefs.edit();
        this.recordSessionEnd(string2, editor, n);
        if (!bl) {
            editor.commit();
            return;
        }
        SessionInformation sessionInformation = SessionInformation.forRuntimeTransition();
        this.setCurrentSession(sessionInformation);
        sessionInformation.recordBegin(editor);
        editor.commit();
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (EVENT_SNAPSHOT.equals(string2)) {
                Log.d((String)LOG_TAG, (String)"Got all add-ons and prefs.");
                try {
                    JSONObject jSONObject2 = jSONObject.getJSONObject("json");
                    JSONObject jSONObject3 = jSONObject2.getJSONObject("addons");
                    Log.i((String)LOG_TAG, (String)("Persisting " + jSONObject3.length() + " add-ons."));
                    this.profileCache.setJSONForAddons(jSONObject3);
                    JSONObject jSONObject4 = jSONObject2.getJSONObject("prefs");
                    Log.i((String)LOG_TAG, (String)"Persisting prefs.");
                    Iterator iterator = jSONObject4.keys();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        this.onPrefMessage(string3, jSONObject4.getJSONObject(string3));
                    }
                    this.profileCache.completeInitialization();
                }
                catch (IOException iOException) {
                    Log.e((String)LOG_TAG, (String)"Error completing profile cache initialization.", (Throwable)iOException);
                    this.state = State.INITIALIZATION_FAILED;
                    return;
                }
                if (this.state == State.INITIALIZING) {
                    this.initializeStorage();
                } else {
                    this.onEnvironmentChanged();
                }
                return;
            }
            if (EVENT_ADDONS_UNINSTALLING.equals(string2)) {
                this.onAddonUninstalling(jSONObject.getString("id"));
                this.onEnvironmentChanged();
                return;
            }
            if (EVENT_ADDONS_CHANGE.equals(string2)) {
                this.onAddonChanged(jSONObject.getString("id"), jSONObject.getJSONObject("json"));
                this.onEnvironmentChanged();
                return;
            }
            if (EVENT_PREF_CHANGE.equals(string2)) {
                String string4 = jSONObject.getString("pref");
                Log.d((String)LOG_TAG, (String)("Pref changed: " + string4));
                this.onPrefMessage(string4, jSONObject);
                this.onEnvironmentChanged();
                return;
            }
            if (EVENT_KEYWORD_SEARCH.equals(string2)) {
                this.recordSearch(jSONObject.getString("identifier"), "bartext");
                return;
            }
            if (EVENT_SEARCH.equals(string2)) {
                if (!jSONObject.has("location")) {
                    Log.d((String)LOG_TAG, (String)"Ignoring search without location.");
                    return;
                }
                this.recordSearch(jSONObject.optString("identifier", null), jSONObject.getString("location"));
                return;
            }
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    void initializeSearchProvider() {
        this.storage.ensureMeasurementInitialized(MEASUREMENT_NAME_SEARCH_COUNTS, 6, new HealthReportStorage.MeasurementFields(){

            @Override
            public Iterable<HealthReportStorage.MeasurementFields.FieldSpec> getFields() {
                ArrayList<HealthReportStorage.MeasurementFields.FieldSpec> arrayList = new ArrayList<HealthReportStorage.MeasurementFields.FieldSpec>(SEARCH_LOCATIONS.size());
                for (String string2 : SEARCH_LOCATIONS) {
                    arrayList.add(new HealthReportStorage.MeasurementFields.FieldSpec(string2, 16642));
                }
                return arrayList;
            }
        });
        this.dispatcher.registerGeckoThreadListener(this, EVENT_KEYWORD_SEARCH, EVENT_SEARCH);
    }

    @Override
    public void recordSearch(String string2, final String string3) {
        if (this.state != State.INITIALIZED) {
            Log.d((String)LOG_TAG, (String)("Not initialized: not recording search. (" + (Object)((Object)this.state) + ")"));
            return;
        }
        final int n = this.env;
        if (n == -1) {
            Log.d((String)LOG_TAG, (String)"No environment: not recording search.");
            return;
        }
        if (string3 == null) {
            throw new IllegalArgumentException("location must be provided for search.");
        }
        if (!SEARCH_LOCATIONS.contains(string3)) {
            throw new IllegalArgumentException("Unexpected location: " + string3);
        }
        final int n2 = this.storage.getDay();
        final String string4 = string2 == null ? "other" : string2;
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                HealthReportDatabaseStorage healthReportDatabaseStorage = BrowserHealthRecorder.this.storage;
                if (healthReportDatabaseStorage == null) {
                    Log.d((String)BrowserHealthRecorder.LOG_TAG, (String)"No storage: not recording search. Shutting down?");
                    return;
                }
                Log.d((String)BrowserHealthRecorder.LOG_TAG, (String)("Recording search: " + string4 + ", " + string3 + " (" + n2 + ", " + n + ")."));
                int n3 = healthReportDatabaseStorage.getField(BrowserHealthRecorder.MEASUREMENT_NAME_SEARCH_COUNTS, 6, string3).getID();
                healthReportDatabaseStorage.recordDailyDiscrete(n, n2, n3, string4);
            }
        });
    }

    void initializeSessionsProvider() {
        this.storage.ensureMeasurementInitialized(MEASUREMENT_NAME_SESSIONS, 4, new HealthReportStorage.MeasurementFields(){

            @Override
            public Iterable<HealthReportStorage.MeasurementFields.FieldSpec> getFields() {
                List<HealthReportStorage.MeasurementFields.FieldSpec> list = Arrays.asList(new HealthReportStorage.MeasurementFields.FieldSpec("normal", 260), new HealthReportStorage.MeasurementFields.FieldSpec("abnormal", 260));
                return list;
            }
        });
    }

    private void recordSessionEntry(String string2, SessionInformation sessionInformation, int n, JSONObject jSONObject) {
        HealthReportDatabaseStorage healthReportDatabaseStorage = this.storage;
        if (healthReportDatabaseStorage == null) {
            Log.d((String)LOG_TAG, (String)"No storage: not recording session entry. Shutting down?");
            return;
        }
        try {
            int n2 = healthReportDatabaseStorage.getField(MEASUREMENT_NAME_SESSIONS, 4, string2).getID();
            int n3 = healthReportDatabaseStorage.getDay(sessionInformation.wallStartTime);
            healthReportDatabaseStorage.recordDailyDiscrete(n, n3, n2, jSONObject);
            Log.v((String)LOG_TAG, (String)("Recorded session entry for env " + n + ", current is " + this.env));
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)"Unable to record session completion.", (Throwable)exception);
        }
    }

    @Override
    public void checkForOrphanSessions() {
        if (!this.orphanChecked.compareAndSet(false, true)) {
            Log.w((String)LOG_TAG, (String)"Attempting to check for orphan sessions more than once.");
            return;
        }
        Log.d((String)LOG_TAG, (String)"Checking for orphan session.");
        if (this.previousSession == null) {
            return;
        }
        if (this.previousSession.wallStartTime == 0L) {
            return;
        }
        if (this.state != State.INITIALIZED) {
            Log.e((String)LOG_TAG, (String)"Attempted to record bad session end without initialized recorder.");
            return;
        }
        try {
            this.recordSessionEntry("abnormal", this.previousSession, this.env, this.previousSession.getCrashedJSON());
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)"Unable to generate session JSON.", (Throwable)exception);
        }
    }

    @Override
    public void recordSessionEnd(String string2, SharedPreferences.Editor editor) {
        this.recordSessionEnd(string2, editor, this.env);
    }

    @Override
    public void recordSessionEnd(String string2, SharedPreferences.Editor editor, int n) {
        Log.d((String)LOG_TAG, (String)("Recording session end: " + string2));
        if (this.state != State.INITIALIZED) {
            Log.e((String)LOG_TAG, (String)"Attempted to record session end without initialized recorder.");
            return;
        }
        SessionInformation sessionInformation = this.session;
        this.session = null;
        if (sessionInformation == null) {
            Log.w((String)LOG_TAG, (String)"Unable to record session end: no session. Already ended?");
            return;
        }
        if (sessionInformation.wallStartTime <= 0L) {
            Log.e((String)LOG_TAG, (String)("Session start " + sessionInformation.wallStartTime + " isn't valid! Can't record end."));
            return;
        }
        long l = SystemClock.elapsedRealtime();
        try {
            JSONObject jSONObject = sessionInformation.getCompletionJSON(string2, l);
            this.recordSessionEntry("normal", sessionInformation, n, jSONObject);
        }
        catch (JSONException jSONException) {
            Log.w((String)LOG_TAG, (String)"Unable to generate session JSON.", (Throwable)jSONException);
        }
        sessionInformation.recordCompletion(editor);
    }

    public static void recordSearchDelayed(String string2, String string3) {
        Search search = new Search(string2, string3);
        delayedSearches.add(search);
    }

    @Override
    public void processDelayed() {
        Search search;
        if (delayedSearches.isEmpty()) {
            return;
        }
        if (this.state != State.INITIALIZED) {
            Log.d((String)LOG_TAG, (String)("Not initialized: not processing delayed items. (" + (Object)((Object)this.state) + ")"));
            return;
        }
        while ((search = delayedSearches.poll()) != null) {
            this.recordSearch(search.engineID, search.location);
        }
    }

    private static class Search {
        public final String location;
        public final String engineID;

        public Search(String string2, String string3) {
            if (!SEARCH_LOCATIONS.contains(string2)) {
                throw new IllegalArgumentException("Unknown search location: " + string2);
            }
            this.location = string2;
            this.engineID = string3;
        }
    }

    public static enum State {
        NOT_INITIALIZED,
        INITIALIZING,
        INITIALIZED,
        INITIALIZATION_FAILED,
        CLOSED;

    }
}

