/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.synchronizer;

import android.content.Context;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.SynchronizerConfiguration;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.RepositorySessionBundle;
import org.mozilla.gecko.sync.synchronizer.SynchronizerDelegate;
import org.mozilla.gecko.sync.synchronizer.SynchronizerSession;
import org.mozilla.gecko.sync.synchronizer.SynchronizerSessionDelegate;

public class Synchronizer
implements SynchronizerSessionDelegate {
    public static final String LOG_TAG = "SyncDelSDelegate";
    protected String configSyncID;
    protected SynchronizerDelegate synchronizerDelegate;
    protected SynchronizerSession session = null;
    public Repository repositoryA;
    public Repository repositoryB;
    public RepositorySessionBundle bundleA;
    public RepositorySessionBundle bundleB;

    public SynchronizerSession getSynchronizerSession() {
        return this.session;
    }

    @Override
    public void onInitialized(SynchronizerSession synchronizerSession) {
        synchronizerSession.synchronize();
    }

    @Override
    public void onSynchronized(SynchronizerSession synchronizerSession) {
        Logger.debug(LOG_TAG, "Got onSynchronized.");
        Logger.debug(LOG_TAG, "Notifying SynchronizerDelegate.");
        this.synchronizerDelegate.onSynchronized(synchronizerSession.getSynchronizer());
    }

    @Override
    public void onSynchronizeSkipped(SynchronizerSession synchronizerSession) {
        Logger.debug(LOG_TAG, "Got onSynchronizeSkipped.");
        Logger.debug(LOG_TAG, "Notifying SynchronizerDelegate as if on success.");
        this.synchronizerDelegate.onSynchronized(synchronizerSession.getSynchronizer());
    }

    @Override
    public void onSynchronizeFailed(SynchronizerSession synchronizerSession, Exception exception, String string2) {
        this.synchronizerDelegate.onSynchronizeFailed(synchronizerSession.getSynchronizer(), exception, string2);
    }

    protected SynchronizerSession newSynchronizerSession() {
        return new SynchronizerSession(this, this);
    }

    public void synchronize(Context context, SynchronizerDelegate synchronizerDelegate) {
        this.synchronizerDelegate = synchronizerDelegate;
        this.session = this.newSynchronizerSession();
        this.session.init(context, this.bundleA, this.bundleB);
    }

    public SynchronizerConfiguration save() {
        return new SynchronizerConfiguration(this.configSyncID, this.bundleA, this.bundleB);
    }

    public void load(SynchronizerConfiguration synchronizerConfiguration) {
        this.bundleA = synchronizerConfiguration.remoteBundle;
        this.bundleB = synchronizerConfiguration.localBundle;
        this.configSyncID = synchronizerConfiguration.syncID;
    }
}

