/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import java.util.Arrays;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.widget.ThemedImageView;

abstract class BrowserToolbarPhoneBase
extends BrowserToolbar {
    protected final ImageView urlBarTranslatingEdge;
    protected final ThemedImageView editCancel;
    private final Path roundCornerShape;
    private final Paint roundCornerPaint;
    private final Interpolator buttonsInterpolator = new AccelerateInterpolator();

    public BrowserToolbarPhoneBase(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Resources resources = context.getResources();
        this.urlBarTranslatingEdge = (ImageView)this.findViewById(R.id.url_bar_translating_edge);
        this.urlBarTranslatingEdge.getDrawable().setLevel(6000);
        this.editCancel = (ThemedImageView)this.findViewById(R.id.edit_cancel);
        this.focusOrder.add(this);
        this.focusOrder.addAll(this.urlDisplayLayout.getFocusOrder());
        this.focusOrder.addAll(Arrays.asList(this.tabsButton, this.menuButton));
        this.roundCornerShape = new Path();
        this.roundCornerShape.moveTo(0.0f, 0.0f);
        this.roundCornerShape.lineTo(30.0f, 0.0f);
        this.roundCornerShape.cubicTo(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 30.0f);
        this.roundCornerShape.lineTo(0.0f, 0.0f);
        this.roundCornerPaint = new Paint();
        this.roundCornerPaint.setAntiAlias(true);
        this.roundCornerPaint.setColor(resources.getColor(R.color.background_tabs));
        this.roundCornerPaint.setStrokeWidth(0.0f);
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.editCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!BrowserToolbarPhoneBase.this.isAnimating()) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.ACTIONBAR, BrowserToolbarPhoneBase.this.getResources().getResourceEntryName(BrowserToolbarPhoneBase.this.editCancel.getId()));
                    BrowserToolbarPhoneBase.this.cancelEdit();
                }
            }
        });
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.editCancel.setPrivateMode(bl);
    }

    @Override
    protected boolean isTabsButtonOffscreen() {
        return this.isEditing();
    }

    @Override
    public boolean addActionItem(View view) {
        return false;
    }

    @Override
    public void removeActionItem(View view) {
    }

    @Override
    protected void updateNavigationButtons(Tab tab) {
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.uiMode == BrowserToolbar.UIMode.DISPLAY) {
            canvas.drawPath(this.roundCornerShape, this.roundCornerPaint);
        }
    }

    @Override
    public void triggerTabsPanelTransition(PropertyAnimator propertyAnimator, boolean bl) {
        if (bl) {
            ViewHelper.setAlpha((View)this.tabsCounter, 0.0f);
            if (this.hasSoftMenuButton) {
                ViewHelper.setAlpha((View)this.menuIcon, 0.0f);
            }
            return;
        }
        PropertyAnimator propertyAnimator2 = new PropertyAnimator(propertyAnimator.getDuration(), this.buttonsInterpolator);
        propertyAnimator2.attach((View)this.tabsCounter, PropertyAnimator.Property.ALPHA, 1.0f);
        if (this.hasSoftMenuButton) {
            propertyAnimator2.attach((View)this.menuIcon, PropertyAnimator.Property.ALPHA, 1.0f);
        }
        propertyAnimator2.start();
    }

    protected int getUrlBarEntryTranslation() {
        return this.editCancel.getLeft() - this.urlBarEntry.getRight();
    }

    protected int getUrlBarCurveTranslation() {
        return this.getWidth() - this.tabsButton.getLeft();
    }

    protected void updateTabCountAndAnimate(int n) {
        if (!this.isVisible()) {
            this.updateTabCount(n);
            return;
        }
        if (!this.isTabsButtonOffscreen()) {
            this.tabsCounter.setCount(n);
            this.tabsButton.setContentDescription(n > 1 ? this.activity.getString(R.string.num_tabs, new Object[]{n}) : this.activity.getString(R.string.one_tab));
        }
    }

    @Override
    protected void setUrlEditLayoutVisibility(final boolean bl, PropertyAnimator propertyAnimator) {
        super.setUrlEditLayoutVisibility(bl, propertyAnimator);
        if (propertyAnimator == null) {
            this.editCancel.setVisibility(bl ? 0 : 4);
            return;
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
                if (!bl) {
                    BrowserToolbarPhoneBase.this.editCancel.setVisibility(4);
                }
            }

            @Override
            public void onPropertyAnimationEnd() {
                if (bl) {
                    BrowserToolbarPhoneBase.this.editCancel.setVisibility(0);
                }
            }
        });
    }

    @Override
    public void onLightweightThemeChanged() {
        super.onLightweightThemeChanged();
        this.editCancel.onLightweightThemeChanged();
    }

    @Override
    public void onLightweightThemeReset() {
        super.onLightweightThemeReset();
        this.editCancel.onLightweightThemeReset();
    }
}

