/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Layout;
import android.util.AttributeSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.widget.ThemedTextView;

public abstract class FadedTextView
extends ThemedTextView {
    protected final int fadeWidth;

    public FadedTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setSingleLine(true);
        this.setEllipsize(null);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.FadedTextView);
        this.fadeWidth = typedArray.getDimensionPixelSize(R.styleable.FadedTextView_fadeWidth, 0);
        typedArray.recycle();
    }

    protected int getAvailableWidth() {
        return this.getWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
    }

    protected boolean needsEllipsis() {
        int n = this.getAvailableWidth();
        if (n <= 0) {
            return false;
        }
        Layout layout2 = this.getLayout();
        return layout2 != null && layout2.getLineWidth(0) > (float)n;
    }
}

