/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.TypedValue;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.Toast;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.activities.FxAccountGetStartedActivity;
import org.mozilla.gecko.fxa.activities.FxAccountStatusFragment;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.sync.Utils;

public class FxAccountStatusActivity
extends Locales.LocaleAwareFragmentActivity {
    private static final String LOG_TAG = FxAccountStatusActivity.class.getSimpleName();
    protected FxAccountStatusFragment statusFragment;

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.statusFragment = new FxAccountStatusFragment();
        this.getSupportFragmentManager().beginTransaction().replace(0x1020002, (Fragment)this.statusFragment).commit();
        this.maybeSetHomeButtonEnabled();
    }

    @TargetApi(value=14)
    protected void maybeSetHomeButtonEnabled() {
        if (Build.VERSION.SDK_INT < 14) {
            Logger.debug(LOG_TAG, "Not enabling home button; version too low.");
            return;
        }
        ActionBar actionBar = this.getActionBar();
        if (actionBar != null) {
            Logger.debug(LOG_TAG, "Enabling home button.");
            actionBar.setHomeButtonEnabled(true);
            return;
        }
        Logger.debug(LOG_TAG, "Not enabling home button.");
    }

    public void onResume() {
        super.onResume();
        AndroidFxAccount androidFxAccount = this.getAndroidFxAccount();
        if (androidFxAccount == null) {
            Logger.warn(LOG_TAG, "Could not get Firefox Account.");
            Intent intent = new Intent((Context)this, FxAccountGetStartedActivity.class);
            intent.setFlags(65536);
            this.startActivity(intent);
            this.setResult(0);
            this.finish();
            return;
        }
        this.statusFragment.refresh(androidFxAccount);
    }

    protected AndroidFxAccount getAndroidFxAccount() {
        Account account = FirefoxAccounts.getFirefoxAccount((Context)this);
        if (account == null) {
            return null;
        }
        return new AndroidFxAccount((Context)this, account);
    }

    @SuppressLint(value={"InlinedApi"})
    public static void maybeDeleteAndroidAccount(final Activity activity, final Account account, final Intent intent) {
        int n;
        TypedValue typedValue;
        if (account == null) {
            Logger.warn(LOG_TAG, "Trying to delete null account; ignoring request.");
            return;
        }
        AccountManagerCallback<Boolean> accountManagerCallback = new AccountManagerCallback<Boolean>(){

            public void run(AccountManagerFuture<Boolean> accountManagerFuture) {
                Logger.info(LOG_TAG, "Account " + Utils.obfuscateEmail(account.name) + " removed.");
                String string2 = activity.getResources().getString(R.string.fxaccount_remove_account_toast, new Object[]{account.name});
                Toast.makeText((Context)activity, (CharSequence)string2, (int)1).show();
                if (intent != null) {
                    intent.setFlags(0x10000000);
                    activity.startActivity(intent);
                }
                activity.finish();
            }
        };
        if (AppConstants.Versions.feature11Plus) {
            typedValue = new TypedValue();
            activity.getTheme().resolveAttribute(16843605, typedValue, true);
            n = typedValue.resourceId;
        } else {
            n = 17301543;
        }
        typedValue = new AlertDialog.Builder((Context)activity).setTitle(R.string.fxaccount_remove_account_dialog_title).setIcon(n).setMessage(R.string.fxaccount_remove_account_dialog_message).setPositiveButton(17039370, new DialogInterface.OnClickListener((AccountManagerCallback)accountManagerCallback){
            final /* synthetic */ AccountManagerCallback val$callback;
            {
                this.val$callback = accountManagerCallback;
            }

            public void onClick(DialogInterface dialogInterface, int n) {
                AccountManager.get((Context)activity).removeAccount(account, this.val$callback, null);
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.cancel();
            }
        }).create();
        typedValue.show();
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n = menuItem.getItemId();
        if (n == 16908332) {
            this.finish();
            return true;
        }
        if (n == R.id.remove_account) {
            FxAccountStatusActivity.maybeDeleteAndroidAccount((Activity)this, FirefoxAccounts.getFirefoxAccount((Context)this), null);
            return true;
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(R.menu.fxaccount_status_menu, menu2);
        return super.onCreateOptionsMenu(menu2);
    }
}

