/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.HardwareUtils;

public class TopSitesThumbnailView
extends ImageView {
    private static final String LOGTAG = "GeckoTopSitesThumbnailView";
    private static final int COLOR_FILTER = 0x46FFFFFF;
    private final int mDefaultColor = this.getResources().getColor(R.color.top_site_default);
    private final float mStrokeWidth;
    private final Paint mBorderPaint;
    private boolean mResize;
    private int mWidth;
    private int mHeight;

    public TopSitesThumbnailView(Context context) {
        this(context, null);
        this.setWillNotDraw(false);
    }

    public TopSitesThumbnailView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.topSitesThumbnailViewStyle);
    }

    public TopSitesThumbnailView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mStrokeWidth = this.getResources().getDisplayMetrics().density * 2.0f;
        this.mResize = false;
        Resources resources = this.getResources();
        this.mBorderPaint = new Paint(1);
        this.mBorderPaint.setColor(resources.getColor(R.color.top_site_border));
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
    }

    public void setImageBitmap(Bitmap bitmap, boolean bl) {
        super.setImageBitmap(bitmap);
        this.mResize = bl;
    }

    public void setImageResource(int n) {
        super.setImageResource(n);
        this.mResize = false;
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.mResize = false;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        if (HardwareUtils.isTablet() && this.mResize) {
            this.setScaleType(ImageView.ScaleType.MATRIX);
            RectF rectF = new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
            Matrix matrix = new Matrix();
            matrix.setRectToRect(rectF, rectF, Matrix.ScaleToFit.CENTER);
            this.setImageMatrix(matrix);
        }
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = (int)((float)this.mWidth * 0.571f);
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.getBackground() == null) {
            this.mBorderPaint.setStrokeWidth(this.mStrokeWidth);
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mBorderPaint);
        }
    }

    public void setBackgroundColorWithOpacityFilter(int n) {
        this.setBackgroundColor(n & 0x46FFFFFF);
    }

    public void setBackgroundColor(int n) {
        if (n == 0) {
            n = this.mDefaultColor;
        }
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.top_sites_thumbnail_bg);
        drawable2.setColorFilter(n, PorterDuff.Mode.SRC_ATOP);
        this.setBackgroundDrawable(drawable2);
    }
}

