/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import java.net.URISyntaxException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.common.telemetry.TelemetryWrapper;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.MigratedFromSync11;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.InfoCollections;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.SyncStorageRecordRequest;
import org.mozilla.gecko.sync.net.SyncStorageRequestDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;
import org.mozilla.gecko.sync.stage.AbstractNonRepositorySyncStage;
import org.mozilla.gecko.sync.stage.NoSuchStageException;

public class MigrationSentinelSyncStage
extends AbstractNonRepositorySyncStage {
    private static final String LOG_TAG = MigrationSentinelSyncStage.class.getSimpleName();
    private static final String META_COLLECTION = "meta";

    @Override
    protected void execute() throws NoSuchStageException {
        InfoCollections infoCollections = this.session.config.infoCollections;
        if (infoCollections == null) {
            this.session.abort(null, "No info/collections set in MigrationSentinelSyncStage.");
            return;
        }
        long l = this.session.config.getLastMigrationSentinelCheckTimestamp();
        if (!infoCollections.updateNeeded(META_COLLECTION, l)) {
            Logger.info(LOG_TAG, "No need to check fresh meta/fxa_credentials.");
            this.session.advance();
            return;
        }
        Logger.info(LOG_TAG, "Fetching meta/fxa_credentials to check for migration sentinel.");
        new MigrationChecker(this.session).check();
    }

    public static class MigrationChecker {
        private static final String META_FXA_CREDENTIALS = "/meta/fxa_credentials";
        private static final String CREDENTIALS_KEY_ID = "id";
        private static final String CREDENTIALS_KEY_SENTINEL = "sentinel";
        private static final String RECORD_ID = "fxa_credentials";
        private static final String SENTINEL_KEY_EMAIL = "email";
        private static final String SENTINEL_KEY_UID = "uid";
        private static final String SENTINEL_KEY_VERIFIED = "verified";
        private static final String SENTINEL_KEY_PASSWORD = "password";
        private static final String SENTINEL_KEY_PREFS = "prefs";
        private static final String PREFS_KEY_AUTH_SERVER_ENDPOINT = "identity.fxaccounts.auth.uri";
        private static final String PREFS_KEY_TOKEN_SERVER_ENDPOINT = "services.sync.tokenServerURI";
        private final GlobalSession session;
        private long fetchTimestamp = -1L;

        MigrationChecker(GlobalSession globalSession) {
            this.session = globalSession;
        }

        private void setTimestamp(long l) {
            this.fetchTimestamp = l == -1L ? System.currentTimeMillis() : l;
        }

        private boolean migrate(String string2, String string3, boolean bl, String string4, String string5, String string6) throws Exception {
            MigratedFromSync11 migratedFromSync11 = new MigratedFromSync11(string2, string3, bl, string4);
            AndroidFxAccount androidFxAccount = AndroidFxAccount.addAndroidAccount(this.session.context, string2, "default", string5, string6, migratedFromSync11, AndroidFxAccount.DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP);
            if (androidFxAccount == null) {
                Logger.warn(LOG_TAG, "Could not add Android account named like: " + Utils.obfuscateEmail(string2));
                return false;
            }
            return true;
        }

        private void migrate(CryptoRecord cryptoRecord) throws Exception {
            this.session.config.persistLastMigrationSentinelCheckTimestamp(this.fetchTimestamp);
            cryptoRecord.keyBundle = this.session.config.syncKeyBundle;
            cryptoRecord.decrypt();
            Logger.info(LOG_TAG, "Migration sentinel could be decrypted; extracting credentials.");
            ExtendedJSONObject extendedJSONObject = cryptoRecord.payload;
            if (!RECORD_ID.equals(extendedJSONObject.getString(CREDENTIALS_KEY_ID))) {
                this.onError(null, "Record payload 'id' was not 'fxa_credentials'; ignoring.");
                return;
            }
            ExtendedJSONObject extendedJSONObject2 = extendedJSONObject.getObject(CREDENTIALS_KEY_SENTINEL);
            if (extendedJSONObject2 == null) {
                this.onError(null, "Record payload did not contain object with key 'sentinel'; ignoring.");
                return;
            }
            extendedJSONObject2.throwIfFieldsMissingOrMisTyped(new String[]{SENTINEL_KEY_EMAIL, SENTINEL_KEY_UID}, String.class);
            extendedJSONObject2.throwIfFieldsMissingOrMisTyped(new String[]{SENTINEL_KEY_VERIFIED}, Boolean.class);
            String string2 = extendedJSONObject2.getString(SENTINEL_KEY_EMAIL);
            String string3 = extendedJSONObject2.getString(SENTINEL_KEY_UID);
            boolean bl = extendedJSONObject2.getBoolean(SENTINEL_KEY_VERIFIED);
            String string4 = extendedJSONObject2.getString(SENTINEL_KEY_PASSWORD);
            ExtendedJSONObject extendedJSONObject3 = extendedJSONObject.getObject(SENTINEL_KEY_PREFS);
            String string5 = null;
            String string6 = null;
            if (extendedJSONObject3 != null) {
                string5 = extendedJSONObject3.getString(PREFS_KEY_AUTH_SERVER_ENDPOINT);
                string6 = extendedJSONObject3.getString(PREFS_KEY_TOKEN_SERVER_ENDPOINT);
            }
            if (string5 == null) {
                string5 = "https://api.accounts.firefox.com/v1";
            }
            if (string6 == null) {
                string6 = "https://token.services.mozilla.com/1.0/sync/1.5";
            }
            Logger.info(LOG_TAG, "Migration sentinel contained valid credentials.");
            if (FxAccountUtils.LOG_PERSONAL_INFORMATION) {
                FxAccountUtils.pii(LOG_TAG, "payload: " + extendedJSONObject.toJSONString());
                FxAccountUtils.pii(LOG_TAG, "email: " + string2);
                FxAccountUtils.pii(LOG_TAG, "uid: " + string3);
                FxAccountUtils.pii(LOG_TAG, "verified: " + bl);
                FxAccountUtils.pii(LOG_TAG, "password: " + string4);
                FxAccountUtils.pii(LOG_TAG, "authServer: " + string5);
                FxAccountUtils.pii(LOG_TAG, "tokenServerURI: " + string6);
            }
            if (this.migrate(string2, string3, bl, string4, string5, string6)) {
                this.session.callback.informMigrated(this.session);
                this.onMigrated();
            } else {
                this.onError(null, "Could not add Android account.");
            }
        }

        private void onMigrated() {
            Logger.info(LOG_TAG, "Account migrated!");
            TelemetryWrapper.addToHistogram("FENNEC_SYNC11_MIGRATIONS_SUCCEEDED", 1);
            this.session.config.persistLastMigrationSentinelCheckTimestamp(this.fetchTimestamp);
            this.session.abort(null, "Account migrated.");
        }

        private void onCompletedUneventfully() {
            this.session.config.persistLastMigrationSentinelCheckTimestamp(this.fetchTimestamp);
            this.session.advance();
        }

        private void onError(Exception exception, String string2) {
            Logger.info(LOG_TAG, "Could not migrate: " + string2, exception);
            TelemetryWrapper.addToHistogram("FENNEC_SYNC11_MIGRATIONS_FAILED", 1);
            this.session.abort(exception, string2);
        }

        public void check() {
            String string2 = this.session.config.storageURL() + META_FXA_CREDENTIALS;
            try {
                SyncStorageRecordRequest syncStorageRecordRequest = new SyncStorageRecordRequest(string2);
                syncStorageRecordRequest.delegate = new SyncStorageRequestDelegate(){

                    @Override
                    public String ifUnmodifiedSince() {
                        return null;
                    }

                    @Override
                    public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
                        Logger.info(LOG_TAG, "Found /meta/fxa_credentials record; attempting migration.");
                        MigrationChecker.this.setTimestamp(syncStorageResponse.normalizedWeaveTimestamp());
                        TelemetryWrapper.addToHistogram("FENNEC_SYNC11_MIGRATION_SENTINELS_SEEN", 1);
                        try {
                            ExtendedJSONObject extendedJSONObject = syncStorageResponse.jsonObjectBody();
                            CryptoRecord cryptoRecord = CryptoRecord.fromJSONRecord(extendedJSONObject);
                            MigrationChecker.this.migrate(cryptoRecord);
                        }
                        catch (Exception exception) {
                            MigrationChecker.this.onError(exception, "Unable to parse credential response.");
                        }
                    }

                    @Override
                    public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
                        MigrationChecker.this.setTimestamp(syncStorageResponse.normalizedWeaveTimestamp());
                        if (syncStorageResponse.getStatusCode() == 404) {
                            MigrationChecker.this.onCompletedUneventfully();
                            return;
                        }
                        MigrationChecker.this.onError(null, "Failed to fetch.");
                    }

                    @Override
                    public void handleRequestError(Exception exception) {
                        MigrationChecker.this.onError(exception, "Failed to fetch.");
                    }

                    @Override
                    public AuthHeaderProvider getAuthHeaderProvider() {
                        return MigrationChecker.this.session.getAuthHeaderProvider();
                    }
                };
                syncStorageRecordRequest.get();
            }
            catch (URISyntaxException uRISyntaxException) {
                this.onError(uRISyntaxException, "Malformed credentials URI.");
            }
        }
    }
}

