/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import org.mozilla.gecko.NotificationClient;
import org.mozilla.gecko.NotificationService;

public class ServiceNotificationClient
extends NotificationClient {
    private static final String LOGTAG = "GeckoServiceNotificationClient";
    private final ServiceConnection mConnection = new NotificationServiceConnection();
    private boolean mBound;
    private final Context mContext;

    public ServiceNotificationClient(Context context) {
        this.mContext = context;
    }

    @Override
    protected void bind() {
        super.bind();
        Intent intent = new Intent(this.mContext, NotificationService.class);
        this.mContext.bindService(intent, this.mConnection, 1);
    }

    @Override
    protected void unbind() {
        super.unbind();
        if (this.mBound) {
            this.mBound = false;
            this.mContext.unbindService(this.mConnection);
        }
    }

    class NotificationServiceConnection
    implements ServiceConnection {
        NotificationServiceConnection() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            NotificationService.NotificationBinder notificationBinder = (NotificationService.NotificationBinder)iBinder;
            ServiceNotificationClient.this.connectHandler(notificationBinder.getService().getNotificationHandler());
            ServiceNotificationClient.this.mBound = true;
        }

        public void onServiceDisconnected(ComponentName componentName) {
            Log.e((String)ServiceNotificationClient.LOGTAG, (String)"Notification service disconnected", (Throwable)new Exception());
        }
    }
}

