/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa.oauth;

import ch.boye.httpclientandroidlib.HttpResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Executor;
import org.mozilla.gecko.background.fxa.oauth.FxAccountAbstractClient;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.Resource;

public class FxAccountOAuthClient10
extends FxAccountAbstractClient {
    protected static final String LOG_TAG = FxAccountOAuthClient10.class.getSimpleName();
    protected static final String AUTHORIZATION_RESPONSE_TYPE = "token";
    protected static final String JSON_KEY_ACCESS_TOKEN = "access_token";
    protected static final String JSON_KEY_ASSERTION = "assertion";
    protected static final String JSON_KEY_CLIENT_ID = "client_id";
    protected static final String JSON_KEY_RESPONSE_TYPE = "response_type";
    protected static final String JSON_KEY_SCOPE = "scope";
    protected static final String JSON_KEY_STATE = "state";
    protected static final String JSON_KEY_TOKEN_TYPE = "token_type";
    protected static final String[] AUTHORIZATION_RESPONSE_REQUIRED_STRING_FIELDS = new String[]{"access_token", "scope", "token_type"};

    public FxAccountOAuthClient10(String string2, Executor executor) {
        super(string2, executor);
    }

    public void authorization(String string2, String string3, String string4, String string5, FxAccountAbstractClient.RequestDelegate<AuthorizationResponse> requestDelegate) {
        BaseResource baseResource;
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "authorization"));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.invokeHandleError(requestDelegate, uRISyntaxException);
            return;
        }
        baseResource.delegate = new FxAccountAbstractClient.ResourceDelegate<AuthorizationResponse>((Resource)baseResource, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(AUTHORIZATION_RESPONSE_REQUIRED_STRING_FIELDS, String.class);
                    String string2 = extendedJSONObject.getString(FxAccountOAuthClient10.JSON_KEY_ACCESS_TOKEN);
                    String string3 = extendedJSONObject.getString(FxAccountOAuthClient10.JSON_KEY_TOKEN_TYPE);
                    String string4 = extendedJSONObject.getString(FxAccountOAuthClient10.JSON_KEY_SCOPE);
                    this.delegate.handleSuccess(new AuthorizationResponse(string2, string3, string4));
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put(JSON_KEY_RESPONSE_TYPE, AUTHORIZATION_RESPONSE_TYPE);
        extendedJSONObject.put(JSON_KEY_CLIENT_ID, string2);
        extendedJSONObject.put(JSON_KEY_ASSERTION, string3);
        if (string5 != null) {
            extendedJSONObject.put(JSON_KEY_SCOPE, string5);
        }
        if (string4 != null) {
            extendedJSONObject.put(JSON_KEY_STATE, string4);
        }
        this.post(baseResource, extendedJSONObject, requestDelegate);
    }

    public static class AuthorizationResponse {
        public final String access_token;
        public final String token_type;
        public final String scope;

        public AuthorizationResponse(String string2, String string3, String string4) {
            this.access_token = string2;
            this.token_type = string3;
            this.scope = string4;
        }
    }
}

