/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import org.mozilla.gecko.gfx.BufferedImage;
import org.mozilla.gecko.gfx.Layer;

public abstract class TileLayer
extends Layer {
    private static final String LOGTAG = "GeckoTileLayer";
    protected final BufferedImage mImage;
    private PaintMode mPaintMode;

    public TileLayer(BufferedImage bufferedImage, PaintMode paintMode) {
        super(bufferedImage.getSize());
        this.mPaintMode = paintMode;
        this.mImage = bufferedImage;
    }

    protected boolean repeats() {
        return this.mPaintMode == PaintMode.REPEAT;
    }

    protected boolean stretches() {
        return this.mPaintMode == PaintMode.STRETCH;
    }

    public abstract void destroy();

    public void setPaintMode(PaintMode paintMode) {
        this.mPaintMode = paintMode;
    }

    public static enum PaintMode {
        NORMAL,
        REPEAT,
        STRETCH;

    }
}

