/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserBookmarksRepositorySession;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserRepositoryDataAccessor;
import org.mozilla.gecko.sync.repositories.android.BrowserContractHelpers;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.domain.BookmarkRecord;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class AndroidBrowserBookmarksDataAccessor
extends AndroidBrowserRepositoryDataAccessor {
    private static final String LOG_TAG = "BookmarksDataAccessor";
    private static final String BOOKMARK_IS_FOLDER = "type = 0";
    private static final String GUID_SHOULD_TRACK = "guid NOT IN ('tags', 'places', 'pinned')";
    private static final String EXCLUDE_SPECIAL_GUIDS_WHERE_CLAUSE;
    public static final String TYPE_FOLDER = "folder";
    public static final String TYPE_BOOKMARK = "bookmark";
    private final RepoUtils.QueryHelper queryHelper;
    private final String[] GUID_AND_ID = new String[]{"guid", "_id"};

    public AndroidBrowserBookmarksDataAccessor(Context context) {
        super(context);
        this.queryHelper = new RepoUtils.QueryHelper(context, this.getUri(), LOG_TAG);
    }

    @Override
    protected Uri getUri() {
        return BrowserContractHelpers.BOOKMARKS_CONTENT_URI;
    }

    protected static Uri getPositionsUri() {
        return BrowserContractHelpers.BOOKMARKS_POSITIONS_CONTENT_URI;
    }

    @Override
    public void wipe() {
        Uri uri = this.getUri();
        Logger.info(LOG_TAG, "wiping (except for special guids): " + uri);
        this.context.getContentResolver().delete(uri, EXCLUDE_SPECIAL_GUIDS_WHERE_CLAUSE, null);
    }

    protected Cursor getGuidsIDsForFolders() throws NullCursorException {
        String string2 = "type = 0 AND guid NOT IN ('tags', 'places', 'pinned')";
        return this.queryHelper.safeQuery(".getGuidsIDsForFolders", this.GUID_AND_ID, string2, null, null);
    }

    public int updatePositions(ArrayList<String> arrayList) {
        int n = arrayList.size();
        if (n == 0) {
            return 0;
        }
        Logger.debug(LOG_TAG, "Updating positions for " + n + " items.");
        String[] stringArray = arrayList.toArray(new String[n]);
        return this.context.getContentResolver().update(AndroidBrowserBookmarksDataAccessor.getPositionsUri(), new ContentValues(), null, stringArray);
    }

    public int bumpModifiedByGUID(Collection<String> collection, long l) {
        int n = collection.size();
        if (n == 0) {
            return 0;
        }
        Logger.debug(LOG_TAG, "Bumping modified for " + n + " items to " + l);
        String string2 = RepoUtils.computeSQLInClause(n, "guid");
        String[] stringArray = collection.toArray(new String[n]);
        ContentValues contentValues = new ContentValues();
        contentValues.put("modified", Long.valueOf(l));
        return this.context.getContentResolver().update(this.getUri(), contentValues, string2, stringArray);
    }

    public int bumpModified(long l, long l2) {
        Logger.debug(LOG_TAG, "Bumping modified for " + l + " to " + l2);
        String string2 = "_id = ?";
        String[] stringArray = new String[]{String.valueOf(l)};
        ContentValues contentValues = new ContentValues();
        contentValues.put("modified", Long.valueOf(l2));
        return this.context.getContentResolver().update(this.getUri(), contentValues, string2, stringArray);
    }

    protected void updateParentAndPosition(String string2, long l, long l2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("parent", Long.valueOf(l));
        if (l2 >= 0L) {
            contentValues.put("position", Long.valueOf(l2));
        }
        this.updateByGuid(string2, contentValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Long> idsForGUIDs(String[] stringArray) throws NullCursorException {
        String string2 = RepoUtils.computeSQLInClause(stringArray.length, "guid");
        try (Cursor cursor = this.queryHelper.safeQuery(".idsForGUIDs", this.GUID_AND_ID, string2, stringArray, null);){
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            if (!cursor.moveToFirst()) {
                HashMap<String, Long> hashMap2 = hashMap;
                return hashMap2;
            }
            int n = cursor.getColumnIndexOrThrow("guid");
            int n2 = cursor.getColumnIndexOrThrow("_id");
            while (!cursor.isAfterLast()) {
                hashMap.put(cursor.getString(n), cursor.getLong(n2));
                cursor.moveToNext();
            }
            HashMap<String, Long> hashMap3 = hashMap;
            return hashMap3;
        }
    }

    protected int moveChildren(String[] stringArray, long l) {
        long l2 = System.currentTimeMillis();
        long l3 = -1L;
        ContentValues contentValues = new ContentValues();
        contentValues.put("parent", Long.valueOf(l));
        contentValues.put("modified", Long.valueOf(l2));
        contentValues.put("position", Long.valueOf(l3));
        String string2 = RepoUtils.computeSQLInClause(stringArray.length, "parent");
        return this.context.getContentResolver().update(this.getUri(), contentValues, string2, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndBuildSpecialGuids() throws NullCursorException {
        String[] stringArray = AndroidBrowserBookmarksRepositorySession.SPECIAL_GUIDS;
        Cursor cursor = this.fetch(stringArray);
        long l = 0L;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(stringArray.length);
        try {
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    String object = RepoUtils.getStringFromCursor(cursor, "guid");
                    if ("places".equals(object)) {
                        l = RepoUtils.getLongFromCursor(cursor, "_id");
                    }
                    int n = RepoUtils.getLongFromCursor(cursor, "deleted") == 1L ? 1 : 0;
                    hashMap.put(object, n != 0);
                    cursor.moveToNext();
                }
            }
        }
        finally {
            cursor.close();
        }
        for (String string2 : stringArray) {
            if (hashMap.containsKey(string2)) {
                if (!((Boolean)hashMap.get(string2)).booleanValue()) continue;
                Logger.info(LOG_TAG, "Undeleting special GUID " + string2);
                ContentValues contentValues = new ContentValues();
                contentValues.put("deleted", Integer.valueOf(0));
                this.updateByGuid(string2, contentValues);
                continue;
            }
            if (string2.equals("places")) {
                Logger.info(LOG_TAG, "No places root. Inserting one.");
                l = this.insertSpecialFolder("places", 0L);
                continue;
            }
            if (string2.equals("mobile")) {
                Logger.info(LOG_TAG, "No mobile folder. Inserting one under the places root.");
                this.insertSpecialFolder("mobile", l);
                continue;
            }
            Logger.info(LOG_TAG, "No " + string2 + " root. Inserting one under places (" + l + ").");
            this.insertSpecialFolder(string2, l);
        }
    }

    private long insertSpecialFolder(String string2, long l) {
        BookmarkRecord bookmarkRecord = new BookmarkRecord(string2);
        bookmarkRecord.title = AndroidBrowserBookmarksRepositorySession.SPECIAL_GUIDS_MAP.get(string2);
        bookmarkRecord.type = TYPE_FOLDER;
        bookmarkRecord.androidParentID = l;
        return ContentUris.parseId((Uri)this.insert(bookmarkRecord));
    }

    @Override
    protected ContentValues getContentValues(Record record) {
        BookmarkRecord bookmarkRecord = (BookmarkRecord)record;
        if (bookmarkRecord.deleted) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("guid", bookmarkRecord.guid);
            contentValues.put("deleted", Integer.valueOf(1));
            return contentValues;
        }
        int n = BrowserContractHelpers.typeCodeForString(bookmarkRecord.type);
        if (n == -1) {
            throw new IllegalStateException("Unexpected record type " + bookmarkRecord.type);
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("guid", bookmarkRecord.guid);
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("title", bookmarkRecord.title);
        contentValues.put("url", bookmarkRecord.bookmarkURI);
        contentValues.put("description", bookmarkRecord.description);
        if (bookmarkRecord.tags == null) {
            bookmarkRecord.tags = new JSONArray();
        }
        contentValues.put("tags", bookmarkRecord.tags.toJSONString());
        contentValues.put("keyword", bookmarkRecord.keyword);
        contentValues.put("parent", Long.valueOf(bookmarkRecord.androidParentID));
        contentValues.put("position", Long.valueOf(bookmarkRecord.androidPosition));
        return contentValues;
    }

    public Cursor getChildren(long l) throws NullCursorException {
        return this.getChildren(l, false);
    }

    public Cursor getChildren(long l, boolean bl) throws NullCursorException {
        String string2 = "parent = ? AND guid <> ? " + (!bl ? "AND deleted = 0" : "");
        String[] stringArray = new String[]{String.valueOf(l), "places"};
        return this.queryHelper.safeQuery(".getChildren", this.getAllColumns(), string2, stringArray, "position, created, _id");
    }

    @Override
    protected String[] getAllColumns() {
        return BrowserContractHelpers.BookmarkColumns;
    }

    static {
        if (AndroidBrowserBookmarksRepositorySession.SPECIAL_GUIDS.length > 0) {
            StringBuilder stringBuilder = new StringBuilder("guid NOT IN (");
            int n = AndroidBrowserBookmarksRepositorySession.SPECIAL_GUIDS.length - 1;
            for (String string2 : AndroidBrowserBookmarksRepositorySession.SPECIAL_GUIDS) {
                stringBuilder.append('\"');
                stringBuilder.append(string2);
                stringBuilder.append('\"');
                if (n-- <= 0) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(')');
            EXCLUDE_SPECIAL_GUIDS_WHERE_CLAUSE = stringBuilder.toString();
        } else {
            EXCLUDE_SPECIAL_GUIDS_WHERE_CLAUSE = null;
        }
    }
}

