/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import org.mozilla.gecko.R;
import org.mozilla.gecko.widget.ThemedEditText;

public class CustomEditText
extends ThemedEditText {
    private OnKeyPreImeListener mOnKeyPreImeListener;
    private OnSelectionChangedListener mOnSelectionChangedListener;
    private OnWindowFocusChangeListener mOnWindowFocusChangeListener;
    private int mHighlightColor;

    public CustomEditText(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setPrivateMode(false);
    }

    public void setOnKeyPreImeListener(OnKeyPreImeListener onKeyPreImeListener) {
        this.mOnKeyPreImeListener = onKeyPreImeListener;
    }

    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        if (this.mOnKeyPreImeListener != null) {
            return this.mOnKeyPreImeListener.onKeyPreIme((View)this, n, keyEvent);
        }
        return false;
    }

    public void setOnSelectionChangedListener(OnSelectionChangedListener onSelectionChangedListener) {
        this.mOnSelectionChangedListener = onSelectionChangedListener;
    }

    protected void onSelectionChanged(int n, int n2) {
        if (this.mOnSelectionChangedListener != null) {
            this.mOnSelectionChangedListener.onSelectionChanged(n, n2);
        }
        super.onSelectionChanged(n, n2);
    }

    public void setOnWindowFocusChangeListener(OnWindowFocusChangeListener onWindowFocusChangeListener) {
        this.mOnWindowFocusChangeListener = onWindowFocusChangeListener;
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (this.mOnWindowFocusChangeListener != null) {
            this.mOnWindowFocusChangeListener.onWindowFocusChanged(bl);
        }
    }

    public int getHighlightColor() {
        return this.mHighlightColor;
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.mHighlightColor = this.getContext().getResources().getColor(bl ? R.color.url_bar_text_highlight_pb : R.color.fennec_ui_orange);
        this.setHighlightColor(this.mHighlightColor);
    }

    public static interface OnWindowFocusChangeListener {
        public void onWindowFocusChanged(boolean var1);
    }

    public static interface OnSelectionChangedListener {
        public void onSelectionChanged(int var1, int var2);
    }

    public static interface OnKeyPreImeListener {
        public boolean onKeyPreIme(View var1, int var2, KeyEvent var3);
    }
}

