/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.annotation.TargetApi;
import android.app.Presentation;
import android.content.Context;
import android.os.Bundle;
import android.support.v7.media.MediaRouter;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.MediaPlayerManager;

@TargetApi(value=17)
public class PresentationMediaPlayerManager
extends MediaPlayerManager {
    private static final String LOGTAG = "Gecko" + PresentationMediaPlayerManager.class.getSimpleName();
    private GeckoPresentation presentation;

    public PresentationMediaPlayerManager() {
        if (!AppConstants.Versions.feature17Plus) {
            throw new IllegalStateException(PresentationMediaPlayerManager.class.getSimpleName() + " does not support < API 17");
        }
    }

    public void onStop() {
        super.onStop();
        if (this.presentation != null) {
            this.presentation.dismiss();
            this.presentation = null;
        }
    }

    @Override
    protected void updatePresentation() {
        Display display;
        if (this.mediaRouter == null) {
            return;
        }
        MediaRouter.RouteInfo routeInfo = this.mediaRouter.getSelectedRoute();
        Display display2 = display = routeInfo != null ? routeInfo.getPresentationDisplay() : null;
        if (display != null) {
            if (this.presentation != null && this.presentation.getDisplay() != display) {
                this.presentation.dismiss();
                this.presentation = null;
            }
            if (this.presentation == null) {
                this.presentation = new GeckoPresentation((Context)this.getActivity(), display);
                try {
                    this.presentation.show();
                }
                catch (WindowManager.InvalidDisplayException invalidDisplayException) {
                    Log.w((String)LOGTAG, (String)"Couldn't show presentation!  Display was removed in the meantime.", (Throwable)invalidDisplayException);
                    this.presentation = null;
                }
            }
        } else if (this.presentation != null) {
            this.presentation.dismiss();
            this.presentation = null;
        }
    }

    private static class SurfaceListener
    implements SurfaceHolder.Callback {
        private SurfaceListener() {
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            GeckoAppShell.scheduleComposite();
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            GeckoAppShell.addPresentationSurface(surfaceHolder.getSurface());
            GeckoAppShell.scheduleComposite();
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            GeckoAppShell.removePresentationSurface(surfaceHolder.getSurface());
        }
    }

    private static final class GeckoPresentation
    extends Presentation {
        private SurfaceView mView;

        public GeckoPresentation(Context context, Display display) {
            super(context, display);
        }

        protected void onCreate(Bundle bundle) {
            super.onCreate(bundle);
            this.mView = new SurfaceView(this.getContext());
            this.setContentView((View)this.mView, new ViewGroup.LayoutParams(-1, -1));
            this.mView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceListener());
        }
    }
}

