/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.util.Log;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SessionParser {
    private static final String LOGTAG = "GeckoSessionParser";

    public abstract void onTabRead(SessionTab var1);

    public void onClosedTabsRead(JSONArray jSONArray) throws JSONException {
    }

    public void parse(String ... stringArray) {
        LinkedList<SessionTab> linkedList = new LinkedList<SessionTab>();
        int n = 0;
        int n2 = -1;
        try {
            for (String string2 : stringArray) {
                JSONObject jSONObject = new JSONObject(string2).getJSONArray("windows").getJSONObject(0);
                JSONArray jSONArray = jSONObject.getJSONArray("tabs");
                int n3 = jSONObject.optInt("selected", -1);
                JSONArray jSONArray2 = jSONObject.optJSONArray("closedTabs");
                if (jSONArray2 != null) {
                    this.onClosedTabsRead(jSONArray2);
                }
                for (int i = 0; i < jSONArray.length(); ++i) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    int n4 = jSONObject2.getInt("index");
                    JSONArray jSONArray3 = jSONObject2.getJSONArray("entries");
                    if (n4 < 1 || jSONArray3.length() < n4) {
                        Log.w((String)LOGTAG, (String)"Session entries and index don't agree.");
                        continue;
                    }
                    JSONObject jSONObject3 = jSONArray3.getJSONObject(n4 - 1);
                    String string3 = jSONObject3.getString("url");
                    String string4 = jSONObject3.optString("title");
                    if (string4.length() == 0) {
                        string4 = string3;
                    }
                    ++n;
                    boolean bl = false;
                    if (n3 == i + 1) {
                        bl = true;
                        n2 = n;
                    }
                    linkedList.add(new SessionTab(string4, string3, bl, jSONObject2));
                }
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"JSON error", (Throwable)jSONException);
            return;
        }
        if (n2 == -1 && linkedList.size() > 0) {
            ((SessionTab)linkedList.getFirst()).mIsSelected = true;
        }
        for (SessionTab sessionTab : linkedList) {
            this.onTabRead(sessionTab);
        }
    }

    public class SessionTab {
        private final String mTitle;
        private final String mUrl;
        private final JSONObject mTabObject;
        private boolean mIsSelected;

        private SessionTab(String string2, String string3, boolean bl, JSONObject jSONObject) {
            this.mTitle = string2;
            this.mUrl = string3;
            this.mIsSelected = bl;
            this.mTabObject = jSONObject;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public boolean isSelected() {
            return this.mIsSelected;
        }

        public JSONObject getTabObject() {
            return this.mTabObject;
        }
    }
}

